/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class TableResizer
extends MouseAdapter
implements MouseMotionListener {
    private static final int _TARGET = 5;
    private static final int _MIN_SIZE = 2;
    private int _resizeItem = -1;
    private boolean _dragged;
    private JTable _table;

    public TableResizer(JTable jTable) {
        this._table = jTable;
        this._table.addMouseListener(this);
        this._table.addMouseMotionListener(this);
    }

    public void dispose() {
        this._table.removeMouseListener(this);
        this._table.removeMouseMotionListener(this);
        this._table = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JTable jTable = this._table;
        if (mouseEvent.isConsumed() || !jTable.isEnabled()) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = jTable.columnAtPoint(point);
        int n2 = jTable.rowAtPoint(point);
        if (n < 0 || n2 < 0) {
            return;
        }
        if (TableResizer._isResizing(jTable, n, n2, mouseEvent.getX(), mouseEvent.getY()) != -1) {
            jTable.setCursor(this._getResizeCursor());
            mouseEvent.consume();
        } else {
            jTable.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JTable jTable = this._table;
        if (mouseEvent.isConsumed() || !jTable.isEnabled()) {
            return;
        }
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        if (!bl) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = jTable.columnAtPoint(point);
        int n2 = jTable.rowAtPoint(point);
        if (n < 0 || n2 < 0) {
            return;
        }
        this._resizeItem = TableResizer._isResizing(jTable, n, n2, mouseEvent.getX(), mouseEvent.getY());
        if (this._resizeItem != -1) {
            if (mouseEvent.getClickCount() == 2) {
                int n3 = 0;
                int n4 = jTable.getRowCount();
                int n5 = 0;
                int n6 = jTable.getColumnModel().getColumnMargin() * 2;
                int n7 = 0;
                while (n7 < n4) {
                    TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n7, n3);
                    Component component = jTable.prepareRenderer(tableCellRenderer, n7, n3);
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.width + n6 > n5) {
                        n5 = dimension.width + n6 + 1;
                    }
                    ++n7;
                }
                this._setWidth(jTable.getColumnModel().getColumn(n3), n5);
            } else {
                this._dragged = false;
                jTable.setCursor(this._getResizeCursor());
                if (jTable.getCellEditor() != null) {
                    jTable.getCellEditor().stopCellEditing();
                }
                mouseEvent.consume();
            }
        } else {
            jTable.setCursor(Cursor.getDefaultCursor());
            this._resizeItem = -1;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            this._dragged = true;
            this._setSize(mouseEvent, false);
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._resizeItem != -1) {
            if (this._dragged) {
                this._setSize(mouseEvent, true);
            }
            this._table.setCursor(Cursor.getDefaultCursor());
            mouseEvent.consume();
        }
        this._resizeItem = -1;
        this._dragged = false;
    }

    private static int _isResizing(JTable jTable, int n, int n2, int n3, int n4) {
        int n5 = -1;
        if ((n3 -= TableResizer._getColumnPosition(jTable, n)) >= 0 && n3 <= 5) {
            n5 = n - 1;
        } else {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            int n6 = tableColumn.getWidth();
            if (n3 >= n6 - 5 && n3 <= n6) {
                n5 = n;
            }
        }
        if (n5 == -1) {
            return -1;
        }
        if (n5 == jTable.getColumnCount() - 1) {
            return -1;
        }
        return n5;
    }

    private static int _getColumnPosition(JTable jTable, int n) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnMargin();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 += tableColumnModel.getColumn(n4).getWidth() + n2;
            ++n4;
        }
        return n3;
    }

    private void _setSize(MouseEvent mouseEvent, boolean bl) {
        JTable jTable = this._table;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this._resizeItem);
        int n = mouseEvent.getX() - TableResizer._getColumnPosition(this._table, this._resizeItem);
        if (n > jTable.getWidth() - 10) {
            n = jTable.getWidth() - 10;
        }
        this._setWidth(tableColumn, n);
    }

    private void _setWidth(TableColumn tableColumn, int n) {
        JTable jTable = this._table;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = n - tableColumn.getWidth();
        tableColumn.setWidth(n);
        tableColumn.setPreferredWidth(n);
        int n3 = tableColumnModel.getColumnCount() - 1;
        TableColumn tableColumn2 = tableColumnModel.getColumn(n3);
        int n4 = tableColumn2.getWidth() - n2;
        tableColumn2.setWidth(n4);
        tableColumn2.setPreferredWidth(n4);
        jTable.revalidate();
        jTable.repaint();
    }

    private Cursor _getResizeCursor() {
        return Cursor.getPredefinedCursor(10);
    }
}

