/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.ExtendedPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.beans.ArrayPropertyEditor;
import oracle.bali.inspector.beans.BeansPropertyEditorRenderer;
import oracle.bali.inspector.beans.BeansPropertyEditorValueEditor;
import oracle.bali.inspector.swing.AbstractTableCellEditor;
import oracle.bali.inspector.swing.NonNullComboBoxModel;

abstract class AbstractPropertyEditorFactory
implements PropertyEditorFactory {
    private transient PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    protected static final Object INVALID_PROPERTY;
    private static final PropertyEditor INVALID_PROPERTY_EDITOR;
    private boolean _ignoreEvents;
    private Object _target;
    private transient Object _value;
    private transient Object _displayValue;
    private transient PropertyEditor _editor = INVALID_PROPERTY_EDITOR;
    private TableCellEditor _cellEditor;
    private Object _propertyID;
    static /* synthetic */ Class class$oracle$bali$inspector$editors$CharEditor;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$sun$beans$editors$FontEditor;
    static /* synthetic */ Class class$oracle$bali$inspector$editors$FontEditor;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$sun$beans$editors$ColorEditor;
    static /* synthetic */ Class class$oracle$bali$inspector$editors$ColorEditor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$sun$beans$editors$IntEditor;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$sun$beans$editors$BoolEditor;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Short;

    protected AbstractPropertyEditorFactory(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this._target = object;
        this.invalidateCachedValues();
    }

    public Object getTarget() {
        return this._target;
    }

    public void invalidateCachedValues() {
        this._value = INVALID_PROPERTY;
        this._displayValue = INVALID_PROPERTY;
    }

    public boolean updateValueIfNecessary(Object object) {
        if (object != this._value) {
            this._value = object;
            this._displayValue = INVALID_PROPERTY;
            return true;
        }
        return false;
    }

    public abstract Class getType();

    public abstract boolean setValue(Object var1) throws Exception;

    public abstract String getDisplayName();

    public String getName() {
        return null;
    }

    public String getShortDescription() {
        return null;
    }

    public boolean isExpert() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public abstract Object getValue(Object var1) throws Exception;

    public Object getDisplayValue() throws Exception {
        if (this._displayValue == INVALID_PROPERTY) {
            PropertyEditor propertyEditor;
            Object object = this.getValue(this._target);
            if (object != null && (propertyEditor = this.__getPropertyEditor()) != null) {
                this._ignoreEvents = true;
                propertyEditor.setValue(object);
                this._ignoreEvents = false;
                String string = propertyEditor.getAsText();
                if (string != null) {
                    object = string;
                }
            }
            this._displayValue = object;
        }
        return this._displayValue;
    }

    public PropertyEditorFactory getPropertyEditorFactory() {
        return this.__getPropertyEditor() != null ? this : null;
    }

    public Object getPropertyID() {
        if (this._propertyID == null) {
            this._propertyID = this.createPropertyID();
        }
        return this._propertyID;
    }

    public abstract boolean isReadable();

    public abstract boolean isWritable();

    public Object getEditorValue() {
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        return propertyEditor == null ? null : propertyEditor.getValue();
    }

    public void setEditorValue(Object object) {
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        if (propertyEditor != null) {
            this._ignoreEvents = true;
            propertyEditor.setValue(object);
            this._ignoreEvents = false;
        }
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        if (propertyEditor instanceof PropertyEditorFactory && ((PropertyEditorFactory)((Object)propertyEditor)).hasValueRenderer()) {
            return ((PropertyEditorFactory)((Object)propertyEditor)).getValueRenderer();
        }
        if (propertyEditor != null && propertyEditor.isPaintable()) {
            return BeansPropertyEditorRenderer.getTableCellRenderer();
        }
        return DisplayValueRenderer.getTableCellRenderer();
    }

    public boolean hasInPlaceEditor() {
        PropertyEditorFactory propertyEditorFactory;
        Class clazz = this.getType();
        if (Boolean.TYPE == clazz || (class$java$util$Date == null ? (class$java$util$Date = AbstractPropertyEditorFactory.class$("java.util.Date")) : class$java$util$Date) == clazz) {
            return true;
        }
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        PropertyEditorFactory propertyEditorFactory2 = propertyEditorFactory = propertyEditor instanceof PropertyEditorFactory ? (PropertyEditorFactory)((Object)propertyEditor) : null;
        return propertyEditor == null ? false : propertyEditor.getAsText() != null || propertyEditorFactory != null && propertyEditorFactory.hasInPlaceEditor() || clazz == (class$java$lang$String == null ? (class$java$lang$String = AbstractPropertyEditorFactory.class$("java.lang.String")) : class$java$lang$String);
    }

    public TableCellEditor getInPlaceEditor(Locale locale) {
        Class clazz = this.getType();
        if (this._cellEditor == null) {
            TableCellEditor tableCellEditor = null;
            PropertyEditor propertyEditor = this.__getPropertyEditor();
            if (propertyEditor instanceof PropertyEditorFactory) {
                PropertyEditorFactory propertyEditorFactory = (PropertyEditorFactory)((Object)propertyEditor);
                tableCellEditor = propertyEditorFactory.getInPlaceEditor(locale);
            } else if (Boolean.TYPE == clazz) {
                Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.FALSE};
                NonNullComboBoxModel nonNullComboBoxModel = new NonNullComboBoxModel(objectArray);
                JComboBox<Object> jComboBox = new JComboBox<Object>(nonNullComboBoxModel);
                jComboBox.setRenderer(new DefaultListCellRenderer(){

                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        if (Boolean.TRUE.equals(object)) {
                            object = "True";
                        } else if (Boolean.FALSE.equals(object)) {
                            object = "False";
                        }
                        return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    }
                });
                tableCellEditor = new DefaultCellEditor(jComboBox);
                jComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Heavyweight");
            } else {
                Object[] objectArray;
                Object[] objectArray2 = objectArray = propertyEditor == null ? null : propertyEditor.getTags();
                if (objectArray != null) {
                    NonNullComboBoxModel nonNullComboBoxModel = new NonNullComboBoxModel(objectArray);
                    JComboBox jComboBox = new JComboBox(nonNullComboBoxModel);
                    tableCellEditor = new DefaultCellEditor(jComboBox);
                    jComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Heavyweight");
                } else if (this._isNumber(clazz)) {
                    NumberEditor numberEditor = new NumberEditor(clazz);
                    tableCellEditor = numberEditor;
                } else if (propertyEditor != null && (propertyEditor.getAsText() != null || clazz == (class$java$lang$String == null ? (class$java$lang$String = AbstractPropertyEditorFactory.class$("java.lang.String")) : class$java$lang$String))) {
                    tableCellEditor = BeansPropertyEditorValueEditor.getTextFieldEditor();
                }
            }
            this._cellEditor = tableCellEditor;
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        ExtendedPropertyEditor extendedPropertyEditor = this._getExtendedEditor();
        return extendedPropertyEditor == null ? false : extendedPropertyEditor.supportsSmallCustomEditor();
    }

    public Component getTearOffEditor() {
        ExtendedPropertyEditor extendedPropertyEditor = this._getExtendedEditor();
        return extendedPropertyEditor == null ? null : extendedPropertyEditor.getSmallCustomEditor();
    }

    public boolean hasAdvancedEditor() {
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        return propertyEditor == null ? false : propertyEditor.supportsCustomEditor();
    }

    public Component getAdvancedEditor() {
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        return propertyEditor == null ? null : propertyEditor.getCustomEditor();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected PropertyEditor createPropertyEditor() {
        Class<?> clazz;
        PropertyEditor propertyEditor;
        PropertyEditor propertyEditor2 = null;
        Class clazz2 = this.getType();
        if (clazz2 != null && (propertyEditor2 = PropertyEditorManager.findEditor(clazz2)) == null && clazz2.isArray() && (propertyEditor = PropertyEditorManager.findEditor(clazz = clazz2.getComponentType())) != null) {
            propertyEditor2 = ArrayPropertyEditor.getPropertyEditor();
        }
        if (propertyEditor2 != null) {
            propertyEditor2.addPropertyChangeListener(this.getPropertyChangeListener());
        }
        return propertyEditor2;
    }

    protected void setCachedDisplayValue(Object object) {
        this._displayValue = object;
    }

    protected void setCachedValue(Object object) {
        this._value = object;
    }

    protected Object getCachedValue() {
        return this._value;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        return new Listen();
    }

    protected abstract Object createPropertyID();

    final PropertyEditor __getPropertyEditor() {
        if (this._editor == INVALID_PROPERTY_EDITOR) {
            this._editor = this.createPropertyEditor();
        }
        return this._editor;
    }

    private final ExtendedPropertyEditor _getExtendedEditor() {
        PropertyEditor propertyEditor = this.__getPropertyEditor();
        if (propertyEditor instanceof ExtendedPropertyEditor) {
            return (ExtendedPropertyEditor)propertyEditor;
        }
        return null;
    }

    private boolean _isNumber(Class clazz) {
        return clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractPropertyEditorFactory.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = AbstractPropertyEditorFactory.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE || clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = AbstractPropertyEditorFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal) || clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = AbstractPropertyEditorFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger) || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = AbstractPropertyEditorFactory.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractPropertyEditorFactory.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = AbstractPropertyEditorFactory.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE || clazz == (class$java$lang$Number == null ? (class$java$lang$Number = AbstractPropertyEditorFactory.class$("java.lang.Number")) : class$java$lang$Number) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = AbstractPropertyEditorFactory.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PropertyEditor propertyEditor;
        PropertyEditor propertyEditor2;
        if (PropertyEditorManager.findEditor(Character.TYPE) == null) {
            PropertyEditorManager.registerEditor(Character.TYPE, class$oracle$bali$inspector$editors$CharEditor == null ? (class$oracle$bali$inspector$editors$CharEditor = AbstractPropertyEditorFactory.class$("oracle.bali.inspector.editors.CharEditor")) : class$oracle$bali$inspector$editors$CharEditor);
        }
        if ((propertyEditor2 = PropertyEditorManager.findEditor(class$java$awt$Font == null ? (class$java$awt$Font = AbstractPropertyEditorFactory.class$("java.awt.Font")) : class$java$awt$Font)) == null || propertyEditor2.getClass() == (class$sun$beans$editors$FontEditor == null ? (class$sun$beans$editors$FontEditor = AbstractPropertyEditorFactory.class$("sun.beans.editors.FontEditor")) : class$sun$beans$editors$FontEditor)) {
            PropertyEditorManager.registerEditor(class$java$awt$Font == null ? (class$java$awt$Font = AbstractPropertyEditorFactory.class$("java.awt.Font")) : class$java$awt$Font, class$oracle$bali$inspector$editors$FontEditor == null ? (class$oracle$bali$inspector$editors$FontEditor = AbstractPropertyEditorFactory.class$("oracle.bali.inspector.editors.FontEditor")) : class$oracle$bali$inspector$editors$FontEditor);
        }
        if ((propertyEditor = PropertyEditorManager.findEditor(class$java$awt$Color == null ? (class$java$awt$Color = AbstractPropertyEditorFactory.class$("java.awt.Color")) : class$java$awt$Color)) == null || propertyEditor.getClass() == (class$sun$beans$editors$ColorEditor == null ? (class$sun$beans$editors$ColorEditor = AbstractPropertyEditorFactory.class$("sun.beans.editors.ColorEditor")) : class$sun$beans$editors$ColorEditor)) {
            PropertyEditorManager.registerEditor(class$java$awt$Color == null ? (class$java$awt$Color = AbstractPropertyEditorFactory.class$("java.awt.Color")) : class$java$awt$Color, class$oracle$bali$inspector$editors$ColorEditor == null ? (class$oracle$bali$inspector$editors$ColorEditor = AbstractPropertyEditorFactory.class$("oracle.bali.inspector.editors.ColorEditor")) : class$oracle$bali$inspector$editors$ColorEditor);
        }
        if (PropertyEditorManager.findEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractPropertyEditorFactory.class$("java.lang.Integer")) : class$java$lang$Integer) == null) {
            PropertyEditorManager.registerEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractPropertyEditorFactory.class$("java.lang.Integer")) : class$java$lang$Integer, class$sun$beans$editors$IntEditor == null ? (class$sun$beans$editors$IntEditor = AbstractPropertyEditorFactory.class$("sun.beans.editors.IntEditor")) : class$sun$beans$editors$IntEditor);
        }
        if (PropertyEditorManager.findEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractPropertyEditorFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean) == null) {
            PropertyEditorManager.registerEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractPropertyEditorFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$sun$beans$editors$BoolEditor == null ? (class$sun$beans$editors$BoolEditor = AbstractPropertyEditorFactory.class$("sun.beans.editors.BoolEditor")) : class$sun$beans$editors$BoolEditor);
        }
        INVALID_PROPERTY = new Object();
        INVALID_PROPERTY_EDITOR = PropertyEditorManager.findEditor(Integer.TYPE);
    }

    private class NumberEditor
    extends AbstractTableCellEditor
    implements ActionListener {
        private NumberTextField _field = new NumberTextField();

        public NumberEditor(Class clazz) {
            this._field.setBorder(new EmptyBorder(0, 2, 0, 0));
            this._field.setDataType(clazz);
            this._field.addActionListener(this);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Number) {
                this._field.setNumber((Number)object);
            } else if (object instanceof String) {
                this._field.setText(object.toString());
            } else {
                this._field.setNumber(null);
            }
            return this._field;
        }

        public Object getCellEditorValue() {
            return this._field.getNumber();
        }

        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            Object object2 = object = eventObject == null ? null : eventObject.getSource();
            if (object != null && object instanceof Component) {
                return ((Component)object).isEnabled();
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }
    }

    private class Listen
    implements PropertyChangeListener {
        private Listen() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!AbstractPropertyEditorFactory.this._ignoreEvents) {
                AbstractPropertyEditorFactory.this._changeSupport.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

