/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.inspector.beans.BeansPropertyID;
import oracle.bali.inspector.beans.IndexedPropertyEditor;

class BeansPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private PropertyDescriptor _propertyDescriptor;
    private transient Object _propertyID;

    public BeansPropertyEditorFactory(Object object, PropertyDescriptor propertyDescriptor) {
        super(object);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this._propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this._propertyDescriptor;
    }

    public String getDisplayName() {
        return this.getPropertyDescriptor().getDisplayName();
    }

    public String getName() {
        return this.getPropertyDescriptor().getName();
    }

    public String getShortDescription() {
        return this.getPropertyDescriptor().getShortDescription();
    }

    public boolean isExpert() {
        return this.getPropertyDescriptor().isExpert();
    }

    public boolean isHidden() {
        return this.getPropertyDescriptor().isHidden();
    }

    public boolean setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, Exception {
        boolean bl = this.getCachedValue() != object;
        try {
            Method method = this.getPropertyDescriptor().getWriteMethod();
            if (method != null) {
                method.invoke(this.getTarget(), object);
            }
        }
        catch (Exception exception) {
            if (object instanceof String) {
                this.__getPropertyEditor().setAsText((String)object);
                object = this.__getPropertyEditor().getValue();
                Method method = this.getPropertyDescriptor().getWriteMethod();
                if (method != null) {
                    method.invoke(this.getTarget(), object);
                }
            }
            this.__getPropertyEditor().setValue(object);
        }
        this.setCachedValue(object);
        this.setCachedDisplayValue(AbstractPropertyEditorFactory.INVALID_PROPERTY);
        return bl;
    }

    public Object getValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object2 = this.getCachedValue();
        if (object2 == AbstractPropertyEditorFactory.INVALID_PROPERTY) {
            Method method = this.getPropertyDescriptor().getReadMethod();
            object2 = method != null ? method.invoke(object, null) : PropertyModel.DOES_NOT_EXIST;
            this.setCachedValue(object2);
        }
        return object2;
    }

    public boolean isReadable() {
        return this.getPropertyDescriptor().getReadMethod() != null || this.getPropertyDescriptor() instanceof IndexedPropertyDescriptor;
    }

    public boolean isWritable() {
        return this.getPropertyDescriptor().getWriteMethod() != null && !this.getType().isArray();
    }

    public Class getType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    protected Object createPropertyID() {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor();
        return new BeansPropertyID(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), propertyDescriptor instanceof IndexedPropertyDescriptor);
    }

    protected PropertyEditor createPropertyEditor() {
        PropertyEditor propertyEditor = null;
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor();
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (clazz != null) {
            try {
                propertyEditor = (PropertyEditor)clazz.newInstance();
            }
            catch (Exception exception) {
                propertyEditor = null;
            }
        }
        if (propertyEditor == null) {
            IndexedPropertyDescriptor indexedPropertyDescriptor;
            Class<?> clazz2;
            PropertyEditor propertyEditor2;
            Class<?> clazz3 = propertyDescriptor.getPropertyType();
            if (propertyDescriptor instanceof IndexedPropertyDescriptor && (propertyEditor2 = PropertyEditorManager.findEditor(clazz2 = (indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType())) != null) {
                propertyEditor = IndexedPropertyEditor.getPropertyEditor();
            }
        }
        if (propertyEditor != null) {
            propertyEditor.addPropertyChangeListener(this.getPropertyChangeListener());
        } else {
            propertyEditor = super.createPropertyEditor();
        }
        return propertyEditor;
    }
}

