/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class BeansPropertyEditorRenderer
extends DefaultTableCellRenderer {
    private PropertyEditor _editor;
    private static final TableCellRenderer _INSTANCE = new BeansPropertyEditorRenderer();

    private BeansPropertyEditorRenderer() {
    }

    public static TableCellRenderer getTableCellRenderer() {
        return _INSTANCE;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        PropertyEditorFactory propertyEditorFactory = propertyModel.getPropertyEditorFactory(n);
        this._editor = propertyEditorFactory instanceof AbstractPropertyEditorFactory ? ((AbstractPropertyEditorFactory)propertyEditorFactory).__getPropertyEditor() : null;
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    public void paintComponent(Graphics graphics) {
        this.setValue(null);
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        super.paintComponent(graphics);
        if (this._editor != null) {
            this._editor.paintValue(graphics, rectangle);
        }
    }
}

