/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;
import oracle.bali.share.util.IntegerUtils;

class IndexedPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private int _index;
    private IndexedPropertyDescriptor _descriptor;

    public IndexedPropertyEditorFactory(Object object, IndexedPropertyDescriptor indexedPropertyDescriptor, int n) {
        super(object);
        this._index = n;
        this._descriptor = indexedPropertyDescriptor;
    }

    public int getIndex() {
        return this._index;
    }

    public IndexedPropertyDescriptor getIndexedPropertyDescriptor() {
        return this._descriptor;
    }

    public String getDisplayName() {
        return Integer.toString(this.getIndex());
    }

    public String getName() {
        return this.getIndexedPropertyDescriptor().getName();
    }

    public String getShortDescription() {
        return this.getIndexedPropertyDescriptor().getShortDescription();
    }

    public boolean setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        boolean bl = this.getCachedValue() != object;
        Method method = this.getIndexedPropertyDescriptor().getIndexedWriteMethod();
        if (method != null) {
            method.invoke(this.getTarget(), IntegerUtils.getInteger((int)this.getIndex()), object);
            this.setCachedValue(object);
            this.setCachedDisplayValue(AbstractPropertyEditorFactory.INVALID_PROPERTY);
        }
        return bl;
    }

    public Object getValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object object2 = this.getCachedValue();
        if (object2 == AbstractPropertyEditorFactory.INVALID_PROPERTY) {
            Method method = this.getIndexedPropertyDescriptor().getIndexedReadMethod();
            if (method != null) {
                Integer n = IntegerUtils.getInteger((int)this.getIndex());
                object2 = method.invoke(object, n);
            } else {
                object2 = PropertyModel.DOES_NOT_EXIST;
            }
            this.setCachedValue(object2);
        }
        return object2;
    }

    public boolean isReadable() {
        return this.getIndexedPropertyDescriptor().getIndexedReadMethod() != null;
    }

    public boolean isWritable() {
        return this.getIndexedPropertyDescriptor().getIndexedWriteMethod() != null;
    }

    protected Object createPropertyID() {
        return new Object();
    }

    public Class getType() {
        return this.getIndexedPropertyDescriptor().getIndexedPropertyType();
    }
}

