/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObject
implements DBObject {
    private String _name;
    private DynamicPropertySetImpl _props;
    private transient DBObjectID _id;

    protected AbstractDBObject() {
    }

    protected AbstractDBObject(String string) {
        this(string, null);
    }

    protected AbstractDBObject(String string, DBObjectID dBObjectID) {
        this._name = string;
        this._id = dBObjectID;
    }

    @Override
    public final Object copyTo(Object object) {
        return this.copyTo((DBObject)object, null, false);
    }

    @Override
    public final DBObject copyTo(DBObject dBObject, boolean bl) {
        return this.copyTo(dBObject, null, bl);
    }

    public abstract DBObject copyTo(DBObject var1, DBObject var2, boolean var3);

    protected void copyToImpl(AbstractDBObject abstractDBObject, boolean bl) {
        abstractDBObject._name = this._name;
        if (this._props == null || this._props.getProperties() == null) {
            abstractDBObject._props = null;
        } else {
            if (abstractDBObject._props != null) {
                abstractDBObject._props.clear();
            }
            for (Object k : this._props.getProperties().keySet()) {
                Object object = this._props.getProperty((String)k);
                if (object instanceof AbstractDBObject) {
                    object = ((AbstractDBObject)object).copyTo(null, abstractDBObject, bl);
                } else if (object instanceof Copyable) {
                    object = ((Copyable)object).copyTo(null);
                }
                abstractDBObject.setProperty((String)k, object);
            }
        }
        if (bl) {
            abstractDBObject.setID(TemporaryObjectID.createID(abstractDBObject, this));
        }
    }

    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        return ModelUtil.areEqual((Object)this._name, (Object)abstractDBObject._name) && ModelUtil.areEqual((Object)this._props, (Object)abstractDBObject._props);
    }

    protected int compareToImpl(AbstractDBObject abstractDBObject) {
        String string = abstractDBObject.getName();
        return this._name == null ? (string == null ? 0 : -1) : (string == null ? 1 : this._name.compareTo(string));
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this._name != null ? this._name.hashCode() : 0;
    }

    @Override
    public void setName(String string) {
        this._name = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setID(DBObjectID dBObjectID) {
        this._id = dBObjectID;
    }

    @Override
    public DBObjectID getID() {
        return this._id;
    }

    public Map getProperties() {
        return this._props == null ? null : this._props.getProperties();
    }

    public Object getProperty(String string) {
        return this._props == null ? null : this._props.getProperty(string);
    }

    public Object getProperty(String string, Object object) {
        return this._props == null ? object : this._props.getProperty(string, object);
    }

    public void setProperties(Map map) {
        if (map != null && map.size() > 0) {
            if (this._props == null) {
                this._props = new DynamicPropertySetImpl();
            }
            this._props.setProperties(map);
        }
    }

    public void setProperty(String string, Object object) {
        if (this._props == null) {
            this._props = new DynamicPropertySetImpl();
        }
        this._props.setProperty(string, object);
    }

    @Override
    public final DBObject[] getOwnedObjects() {
        return this.getOwnedObjects(null);
    }

    @Override
    public final DBObject[] getOwnedObjects(String ... stringArray) {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        this.getOwnedObjectsImpl(arrayList, stringArray);
        return arrayList.toArray(new DBObject[arrayList.size()]);
    }

    @Override
    public final DBObject findOwnedObject(String string, String string2) {
        if (string2 != null) {
            DBObject[] dBObjectArray = this.getOwnedObjects(string);
            int n = 0;
            while (dBObjectArray != null && n < dBObjectArray.length) {
                if (string2.equals(dBObjectArray[n].getName())) {
                    return dBObjectArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        Map map;
        if (this._props != null && (map = this._props.getProperties()) != null) {
            for (Object v : map.values()) {
                if (!(v instanceof DBObject) || !this.includesType(((DBObject)v).getType(), new String[0])) continue;
                collection.add((DBObject)v);
            }
        }
    }

    protected final boolean includesType(String string, String ... stringArray) {
        if (ModelUtil.hasNonNullElement((Object[])stringArray)) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    @Override
    public final DBObjectID[] getReferenceIDs() {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        this.getReferenceIDsImpl(arrayList);
        return arrayList.toArray(new DBObjectID[arrayList.size()]);
    }

    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        return false;
    }
}

