/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;

public abstract class AbstractDBObjectBuilder
implements DBObjectBuilder {
    private String _type;
    private AbstractDBObjectProvider _pro;

    protected AbstractDBObjectBuilder(AbstractDBObjectProvider abstractDBObjectProvider, String string) {
        this._type = string;
        this._pro = abstractDBObjectProvider;
    }

    protected void sqlTrace(String string, Object[] objectArray) {
        AbstractDatabase.sqlTrace(this._pro.getName(), string, objectArray);
    }

    protected String getObjectType() {
        return this._type;
    }

    public abstract SchemaObject createObject(String var1, Schema var2, DBObjectID var3);

    public final void buildObject(SchemaObject schemaObject) throws DBException {
        ((AbstractSchemaObject)schemaObject).setBuilder(null);
        this.fillInObject(schemaObject);
        this.markAsBuilt((AbstractSchemaObject)schemaObject);
        this.registerObject(schemaObject);
    }

    protected abstract void fillInObject(SchemaObject var1) throws DBException;

    protected void registerObject(SchemaObject schemaObject) throws DBException {
        SchemaObjectManager schemaObjectManager;
        SchemaObjectManager schemaObjectManager2 = schemaObjectManager = this._pro == null ? null : this._pro.getObjectManager();
        if (schemaObjectManager != null) {
            schemaObjectManager.registerObject(schemaObject);
        }
    }

    protected boolean needsBuilding(AbstractSchemaObject abstractSchemaObject, String string) {
        return abstractSchemaObject.isBuilt(string) ^ true;
    }

    protected void markAsBuilt(AbstractSchemaObject abstractSchemaObject) {
        abstractSchemaObject.setBuilder(null);
        abstractSchemaObject.clearBuiltList();
    }

    protected void ensureComponent(AbstractSchemaObject abstractSchemaObject, String string) throws DBException {
        if (this.needsBuilding(abstractSchemaObject, string)) {
            this.buildObjectComponent(abstractSchemaObject, string);
        }
    }

    public final void buildObjectComponent(SchemaObject schemaObject, String string) throws DBException {
        if (this.canBuildComponents()) {
            ((AbstractSchemaObject)schemaObject).setBuilt(string);
            this.fillInObjectComponent(schemaObject, string);
            this.registerObject(schemaObject);
        } else {
            this.buildObject(schemaObject);
        }
    }

    protected void fillInObjectComponent(SchemaObject schemaObject, String string) throws DBException {
        if (!string.equals("Timestamp")) {
            this.buildObject(schemaObject);
        }
    }

    protected boolean canBuildComponents() {
        return false;
    }
}

