/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObjectProvider
implements DBObjectProvider {
    public static final int MIXED_CASE_NAME_POLICY = 0;
    public static final int LOWER_CASE_NAME_POLICY = 1;
    public static final int UPPER_CASE_NAME_POLICY = 2;
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    private SchemaObjectManager m_objManager;
    private Map _typeMap;
    private String[] _objTypes;
    private int _casePolicy;
    private List m_listeners;
    protected static final String[] EMPTY_LIST = new String[0];

    void $init$() {
        this._typeMap = new HashMap();
        this._casePolicy = -1;
    }

    public final void removeProviderListener(DBObjectProviderListener dBObjectProviderListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(dBObjectProviderListener);
        }
    }

    public final void addProviderListener(DBObjectProviderListener dBObjectProviderListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(dBObjectProviderListener);
    }

    protected final void fireProviderClosed() {
        DBUtil.getLog().trace("fire provider {0} closed", (Object)this.getName());
        if (this.m_listeners != null) {
            ArrayList arrayList = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                dBObjectProviderListener.providerClosed(this);
            }
        }
    }

    protected final void fireProviderOpened() {
        DBUtil.getLog().trace("fire provider {0} opened", (Object)this.getName());
        if (this.m_listeners != null) {
            ArrayList arrayList = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                dBObjectProviderListener.providerOpened(this);
            }
        }
    }

    protected final void fireProviderReloaded() {
        DBUtil.getLog().trace("fire provider {0} reloaded", (Object)this.getName());
        if (this.m_listeners != null) {
            ArrayList arrayList = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                dBObjectProviderListener.providerReloaded(this);
            }
        }
    }

    protected final void fireSchemaAdded(Schema schema) {
        DBUtil.getLog().trace("fire schema {0} added to {1}", (Object)schema.getName(), (Object)this.getName());
        if (this.m_listeners != null) {
            ArrayList arrayList = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                dBObjectProviderListener.schemaAdded(this, schema);
            }
        }
    }

    protected final void fireSchemaUpdated(DBObjectChange dBObjectChange) {
        DBUtil.getLog().trace("fire schema {0} updated in {1}", (Object)dBObjectChange.getDBObject().getName(), (Object)this.getName());
        this.schemaUpdated(dBObjectChange);
        if (this.m_listeners != null) {
            ArrayList arrayList = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                dBObjectProviderListener.schemaUpdated(this, dBObjectChange);
            }
        }
    }

    protected void schemaUpdated(DBObjectChange dBObjectChange) {
    }

    protected final void fireSchemaRemoved(Schema schema) {
        DBUtil.getLog().trace("fire schema {0} removed from {1}", (Object)schema.getName(), (Object)this.getName());
        if (this.m_listeners != null) {
            ArrayList arrayList = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                dBObjectProviderListener.schemaRemoved(this, schema);
            }
        }
    }

    public final void fireObjectsAdded(Schema schema, SchemaObject[] schemaObjectArray) {
        if (ModelUtil.hasNonNullElement((Object[])schemaObjectArray)) {
            Log log = DBUtil.getLog();
            if (log.isEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("fire SchemaObjects added to ");
                stringBuffer.append(this.getName());
                stringBuffer.append(": ");
                int n = 0;
                while (n < schemaObjectArray.length) {
                    stringBuffer.append(DBUtil.getFullyQualifiedName(schemaObjectArray[n], true));
                    stringBuffer.append(" ");
                    ++n;
                }
                log.trace(stringBuffer.toString());
            }
            if (this.m_listeners != null) {
                ArrayList arrayList = new ArrayList(this.m_listeners);
                for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                    dBObjectProviderListener.schemaObjectsAdded(this, schemaObjectArray[0].getSchema(), schemaObjectArray);
                }
            }
        }
    }

    protected final void fireObjectsRemoved(Schema schema, SchemaObject[] schemaObjectArray) {
        if (ModelUtil.hasNonNullElement((Object[])schemaObjectArray)) {
            Log log = DBUtil.getLog();
            if (log.isEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("fire SchemaObjects removed from ");
                stringBuffer.append(this.getName());
                stringBuffer.append(": ");
                int n = 0;
                while (n < schemaObjectArray.length) {
                    stringBuffer.append(DBUtil.getFullyQualifiedName(schemaObjectArray[n], true));
                    stringBuffer.append(" ");
                    ++n;
                }
                log.trace(stringBuffer.toString());
            }
            if (this.m_listeners != null) {
                ArrayList arrayList = new ArrayList(this.m_listeners);
                for (DBObjectProviderListener dBObjectProviderListener : arrayList) {
                    dBObjectProviderListener.schemaObjectsRemoved(this, schema, schemaObjectArray);
                }
            }
        }
    }

    public void registerType(String string, DBObjectBuilder dBObjectBuilder, DBObjectValidator dBObjectValidator) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        if (objectTypeEntry == null) {
            objectTypeEntry = new ObjectTypeEntry(string, dBObjectBuilder, dBObjectValidator, null);
            this._typeMap.put(string, objectTypeEntry);
            this._objTypes = null;
        } else {
            if (dBObjectBuilder != null) {
                ObjectTypeEntry.mav$setBuilder(objectTypeEntry, dBObjectBuilder);
            }
            if (dBObjectValidator != null) {
                ObjectTypeEntry.mav$setValidator(objectTypeEntry, dBObjectValidator);
            }
        }
    }

    public void registerBuilder(String string, DBObjectBuilder dBObjectBuilder) {
        this.registerType(string, dBObjectBuilder, null);
    }

    public void unregisterBuilder(String string) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        if (ObjectTypeEntry.mav$getValidator(objectTypeEntry) == null) {
            this._typeMap.remove(string);
            this._objTypes = null;
        } else {
            ObjectTypeEntry.mav$setBuilder(objectTypeEntry, null);
        }
    }

    protected DBObjectBuilder getBuilderForType(String string) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        return objectTypeEntry != null ? ObjectTypeEntry.mav$getBuilder(objectTypeEntry) : null;
    }

    public void registerValidator(String string, DBObjectValidator dBObjectValidator) {
        this.registerType(string, null, dBObjectValidator);
    }

    public void unregisterValidator(String string) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        if (ObjectTypeEntry.mav$getBuilder(objectTypeEntry) == null) {
            this._typeMap.remove(string);
            this._objTypes = null;
        } else {
            ObjectTypeEntry.mav$setValidator(objectTypeEntry, null);
        }
    }

    protected DBObjectValidator getValidatorForType(String string) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        return objectTypeEntry != null ? ObjectTypeEntry.mav$getValidator(objectTypeEntry) : null;
    }

    protected SchemaObject findObject(String string, Schema schema, String string2) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        return objectTypeEntry != null ? ObjectTypeEntry.mav$findObject(objectTypeEntry, schema, string2) : null;
    }

    protected final SchemaObject findObject(DBObjectID dBObjectID) {
        ObjectTypeEntry objectTypeEntry;
        SchemaObject schemaObject = null;
        if (dBObjectID != null && (objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(dBObjectID.getType())) != null) {
            schemaObject = ObjectTypeEntry.mav$findObject(objectTypeEntry, dBObjectID);
        }
        return schemaObject;
    }

    public void destroyCache() {
        this._typeMap.clear();
        this._objTypes = null;
    }

    protected final void clearCache(String string) {
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        if (objectTypeEntry != null) {
            ObjectTypeEntry.mav$clearCache(objectTypeEntry);
        }
    }

    protected final void clearAllCaches() {
        Iterator iterator = this._typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            this.clearCache((String)iterator.next());
        }
        if (this.m_objManager != null) {
            this.m_objManager.clearAllCaches();
        }
    }

    protected SchemaObjectManager getObjectManager() {
        if (this.m_objManager == null) {
            this.m_objManager = this.createObjectManager();
        }
        return this.m_objManager;
    }

    protected SchemaObjectManager createObjectManager() {
        return new SchemaObjectManager(this);
    }

    protected void cacheObject(SchemaObject schemaObject) {
        if (schemaObject != null) {
            String string = schemaObject.getType();
            ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
            if (objectTypeEntry != null) {
                ObjectTypeEntry.mav$addObjectToCache(objectTypeEntry, schemaObject);
            }
            this.getObjectManager().registerObject(schemaObject);
        }
    }

    protected final void uncacheObject(SchemaObject schemaObject) {
        if (schemaObject != null) {
            String string = schemaObject.getType();
            ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
            if (objectTypeEntry != null) {
                ObjectTypeEntry.mav$removeObjectFromCache(objectTypeEntry, schemaObject.getSchema(), schemaObject.getName());
            }
            if (this.m_objManager != null) {
                this.m_objManager.unregisterObject(schemaObject);
            }
        }
    }

    protected String[] listObjectsImpl(String string, Schema schema, String string2) throws DBException {
        SchemaObject[] schemaObjectArray = this.listObjectsImpl(new String[]{string}, schema, string2);
        String[] stringArray = new String[schemaObjectArray.length];
        int n = 0;
        while (n < schemaObjectArray.length) {
            stringArray[n] = schemaObjectArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    protected SchemaObject[] listObjectsImpl(String[] stringArray, Schema schema, String string) throws DBException {
        return new SchemaObject[0];
    }

    protected SchemaObject getObjectImpl(String string, Schema schema, String string2) throws DBException {
        SchemaObject schemaObject = null;
        ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(string);
        if (objectTypeEntry != null) {
            schemaObject = ObjectTypeEntry.mav$findObject(objectTypeEntry, schema, string2);
            if (schemaObject == null) {
                schemaObject = this.createSchemaObjectImpl(string, schema, string2);
                if (schemaObject != null) {
                    ObjectTypeEntry.mav$cacheObject(objectTypeEntry, schemaObject);
                }
            } else {
                SchemaObject schemaObject2;
                Long l = (Long)schemaObject.getProperty(TIMESTAMP_PROPERTY);
                if (l != null) {
                    Long l2 = this.getExternalTimestamp(schemaObject);
                    if (l2 == null || l2.compareTo(l) > 0) {
                        ObjectTypeEntry.mav$removeObjectFromCache(objectTypeEntry, schemaObject.getSchema(), schemaObject.getName());
                        SchemaObject schemaObject3 = this.createSchemaObjectImpl(string, schema, string2);
                        if (schemaObject3 == null) {
                            schemaObject = null;
                        } else if (ModelUtil.areDifferent((Object)schemaObject, (Object)schemaObject3)) {
                            DBUtil.updateObjectAndIDs(schemaObject, schemaObject3);
                            ObjectTypeEntry.mav$cacheObject(objectTypeEntry, schemaObject);
                            DBObjectChange.fireObjectUpdated(schemaObject);
                        }
                    }
                } else if (((AbstractSchemaObject)schemaObject).needsInitialization() && (schemaObject2 = this.createSchemaObjectImpl(string, schema, string2)) == null) {
                    ObjectTypeEntry.mav$removeObjectFromCache(objectTypeEntry, schemaObject.getSchema(), schemaObject.getName());
                    schemaObject = null;
                }
            }
        }
        return schemaObject;
    }

    protected DBObject findByID(DBObjectID dBObjectID) throws DBException {
        ObjectTypeEntry objectTypeEntry;
        SchemaObject schemaObject = null;
        if (dBObjectID != null && (objectTypeEntry = (ObjectTypeEntry)this._typeMap.get(dBObjectID.getType())) != null) {
            schemaObject = ObjectTypeEntry.mav$findObject(objectTypeEntry, dBObjectID);
            if (schemaObject == null) {
                schemaObject = this.createByIDImpl(dBObjectID);
                if (schemaObject != null) {
                    ObjectTypeEntry.mav$cacheObject(objectTypeEntry, schemaObject);
                }
            } else {
                Long l;
                Long l2 = (Long)schemaObject.getProperty(TIMESTAMP_PROPERTY);
                if (l2 != null && ((l = this.getExternalTimestamp(schemaObject)) == null || l.compareTo(l2) > 0)) {
                    SchemaObject schemaObject2 = this.createByIDImpl(dBObjectID);
                    if (schemaObject2 == null) {
                        ObjectTypeEntry.mav$removeObjectFromCache(objectTypeEntry, schemaObject.getSchema(), schemaObject.getName());
                        schemaObject = null;
                    } else if (ModelUtil.areDifferent((Object)schemaObject, (Object)schemaObject2)) {
                        ObjectTypeEntry.mav$updateCachedObject(objectTypeEntry, schemaObject, schemaObject2);
                    }
                }
            }
        }
        return schemaObject;
    }

    protected SchemaObject createSchemaObjectImpl(String string, Schema schema, String string2) throws DBException {
        SchemaObject[] schemaObjectArray = this.listObjectsImpl(new String[]{string}, schema, string2);
        int n = 0;
        while (schemaObjectArray != null && n < schemaObjectArray.length) {
            if (string2.equals(schemaObjectArray[n].getName())) {
                return schemaObjectArray[n];
            }
            ++n;
        }
        return null;
    }

    protected SchemaObject createByIDImpl(DBObjectID dBObjectID) throws DBException {
        return null;
    }

    protected Long getExternalTimestamp(SchemaObject schemaObject) throws DBException {
        return null;
    }

    protected final void markForLazyInit(AbstractSchemaObject abstractSchemaObject) {
        DBObjectBuilder dBObjectBuilder = this.getBuilderForType(abstractSchemaObject.getType());
        if (dBObjectBuilder != null) {
            abstractSchemaObject.setBuilder(dBObjectBuilder);
        }
    }

    protected abstract int getCasePolicy();

    protected boolean needsQuoting(String string) {
        boolean bl = true;
        if (this.isValidName(null, string)) {
            if (this._casePolicy == -1) {
                this._casePolicy = this.getCasePolicy();
            }
            switch (this._casePolicy) {
                case 2: {
                    bl = ModelUtil.areDifferent((Object)string, (Object)string.toUpperCase());
                    break;
                }
                case 1: {
                    bl = ModelUtil.areDifferent((Object)string, (Object)string.toLowerCase());
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static String convertObject(DBObject dBObject) {
        String string = dBObject != null ? dBObject.getName() : "";
        return ModelUtil.hasLength((String)string) ? string : "";
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String[] listObjectTypes() {
        if (this._objTypes == null) {
            Set set = this._typeMap.entrySet();
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : set) {
                ObjectTypeEntry objectTypeEntry = (ObjectTypeEntry)entry.getValue();
                if (objectTypeEntry == null || ObjectTypeEntry.mav$getBuilder(objectTypeEntry) == null) continue;
                arrayList.add(entry.getKey());
            }
            this._objTypes = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(this._objTypes);
        }
        return this._objTypes;
    }

    public boolean supportsObjectType(String string) {
        if (this._objTypes == null) {
            this.listObjectTypes();
        }
        return Arrays.binarySearch(this._objTypes, string) >= 0;
    }

    public String[] listObjects(String string, Schema schema) throws DBException {
        return this.listObjects(string, schema, null);
    }

    public final String[] listObjects(String string, Schema schema, String string2) throws DBException {
        return this.listObjectsImpl(string, schema, string2);
    }

    public SchemaObject[] listObjects(String[] stringArray, Schema schema) throws DBException {
        return this.listObjects(stringArray, schema, null);
    }

    public final SchemaObject[] listObjects(String[] stringArray, Schema schema, String string) throws DBException {
        return this.listObjectsImpl(stringArray, schema, string);
    }

    public SchemaObject getObject(String string, Schema schema, String string2) throws DBException {
        return this.getObjectImpl(string, schema, string2);
    }

    public boolean hasPriviledge(String string, Schema schema, String string2) {
        return true;
    }

    public final boolean isValidName(String string) {
        return this.isValidName(null, string);
    }

    public final boolean isValidName(String string, String string2) {
        try {
            this.validateName(string, string2);
        }
        catch (InvalidNameException invalidNameException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final void validateName(String string) throws InvalidNameException {
        this.validateName(null, string);
    }

    public void validateName(String string, String string2) throws InvalidNameException {
    }

    public String quoteIdentifier(String string, boolean bl) throws DBException {
        String string2 = this.getIdentifierQuoteString();
        String string3 = string2 = string2 != null ? string2.trim() : "";
        if (!ModelUtil.hasLength((String)string)) {
            string = null;
        } else if (string2.length() == 0) {
            if (!this.isValidName(null, string)) {
                string = null;
            }
        } else if ((bl || this.needsQuoting(string)) && !this.isValidName(null, string = DBUtil.quoteName(string, string2))) {
            string = null;
        }
        if (string == null) {
            throw new DBException(null, "Invalid name");
        }
        return string;
    }

    public String getInternalName(String string, String string2) {
        return this.convertToInternal(string);
    }

    public String getInternalName(String string) {
        return this.getInternalName(string, null);
    }

    protected String convertToInternal(String string) {
        String string2 = this.getIdentifierQuoteString();
        String string3 = string;
        string3.trim();
        if (ModelUtil.hasLength((String)string2)) {
            int n = string2.length();
            int n2 = string.length();
            int n3 = string.indexOf(string2);
            int n4 = string.lastIndexOf(string2);
            if (n2 > n && n3 == 0 && n4 == n2 - n) {
                string3 = string.substring(n3 + n, n4);
                n3 = string3.indexOf(string2);
                while (n3 > -1 && n3 < string3.length()) {
                    n4 = string3.indexOf(string2, n3 + n);
                    if (n4 == n3 + n) {
                        string3 = string3.substring(0, n3 + 1) + string3.substring(n4 + n);
                    }
                    n3 = string3.indexOf(string2, n3 + n);
                }
            }
        }
        if (ModelUtil.areEqual((Object)string3, (Object)string)) {
            if (this._casePolicy == -1) {
                this._casePolicy = this.getCasePolicy();
            }
            switch (this._casePolicy) {
                case 2: {
                    string3 = string.toUpperCase();
                    break;
                }
                case 1: {
                    string3 = string.toLowerCase();
                    break;
                }
            }
        }
        return string3;
    }

    public String getExternalName(String string, String string2) {
        return this.convertToExternal(string);
    }

    public String getExternalName(String string) {
        return this.convertToExternal(string);
    }

    protected String convertToExternal(String string) {
        try {
            string = this.quoteIdentifier(string, false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return string;
    }

    public DataType[] listSupportedDataTypes() {
        Class<?> clazz = this.getClass();
        if (clazz == JdbcDatabase.class) {
            return DataTypeRegistry.getInstance().getAnsiTypes();
        }
        return DataTypeRegistry.getInstance().listDataTypes(this.getClass());
    }

    public DataType getDataType(String string) {
        DataType dataType = null;
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        Class<?> clazz = this.getClass();
        dataType = clazz == JdbcDatabase.class ? dataTypeRegistry.findAnsiType(string) : dataTypeRegistry.findDataType(string, clazz);
        if (dataType == null) {
            DBUtil.getLog().trace("DataTypeRegistry had no \"" + string + "\" for provider " + clazz.getName());
            dataType = dataTypeRegistry.createUserDataType(string, clazz);
        }
        return dataType;
    }

    public void validateObject(DBObject dBObject) throws ValidationException {
        DBObjectValidator dBObjectValidator = this.getValidatorForType(dBObject.getType());
        if (dBObjectValidator == null) {
            throw new MissingValidatorException(dBObject);
        }
        dBObjectValidator.validateObject(dBObject);
    }

    public void validateObject(DBObject dBObject, String string) throws ValidationException {
        DBObjectValidator dBObjectValidator;
        if (string == null) {
            this.validateObject(dBObject);
        }
        if ((dBObjectValidator = this.getValidatorForType(dBObject.getType())) == null) {
            throw new MissingValidatorException(dBObject);
        }
        dBObjectValidator.validateObject(dBObject, string);
    }

    public void validateSchema(Schema schema) throws ValidationException {
        this.validateObject(schema);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
        DBObjectValidator dBObjectValidator = this.getValidatorForType(dBObject2.getType());
        if (dBObjectValidator == null) {
            throw new MissingValidatorException(dBObject2);
        }
        dBObjectValidator.validateObject(dBObject, dBObject2);
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2, String string) throws ValidationException {
        DBObjectValidator dBObjectValidator;
        if (string == null) {
            this.validateObject(dBObject, dBObject2);
        }
        if ((dBObjectValidator = this.getValidatorForType(dBObject2.getType())) == null) {
            throw new MissingValidatorException(dBObject2);
        }
        dBObjectValidator.validateObject(dBObject, dBObject2, string);
    }

    public void validateSchema(Schema schema, Schema schema2) throws ValidationException {
        this.validateObject((DBObject)schema, schema2);
    }

    public void validateUniqueName(String string, DBObject dBObject, String string2) throws NameInUseException {
        if (ModelUtil.hasLength((String)string2)) {
            string = this.normaliseType(string);
            if (dBObject instanceof Schema) {
                SchemaObject[] schemaObjectArray = null;
                try {
                    schemaObjectArray = this.listObjects(this.listObjectTypes(), (Schema)dBObject);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (schemaObjectArray != null) {
                    int n = 0;
                    while (n < schemaObjectArray.length) {
                        if (string.equals("INDEX") || string.equals("CONSTRAINT")) {
                            this.checkChildrenNames(string2, schemaObjectArray[n].getOwnedObjects(string));
                        } else if (string2.equals(schemaObjectArray[n].getName())) {
                            throw new NameInUseException(string2, schemaObjectArray[n].getName(), schemaObjectArray[n].getType());
                        }
                        ++n;
                    }
                }
            } else if (dBObject instanceof SchemaObject) {
                this.checkChildrenNames(string2, dBObject.getOwnedObjects(string));
            }
        }
    }

    public String getUniqueName(String string, DBObject dBObject, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = this.normaliseType(string);
        if (!ModelUtil.hasLength((String)string2)) {
            string2 = string + 1;
        }
        if (dBObject instanceof Schema) {
            SchemaObject[] schemaObjectArray = null;
            try {
                schemaObjectArray = this.listObjects(this.listObjectTypes(), (Schema)dBObject);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (schemaObjectArray != null) {
                int n = 0;
                while (n < schemaObjectArray.length) {
                    if (string.equals("INDEX") || string.equals("CONSTRAINT")) {
                        this.addChildrenNames(schemaObjectArray[n].getOwnedObjects(string), arrayList);
                    } else {
                        arrayList.add(schemaObjectArray[n].getName());
                    }
                    ++n;
                }
            }
        } else if (dBObject instanceof SchemaObject) {
            this.addChildrenNames(dBObject.getOwnedObjects(string), arrayList);
        }
        return DBUtil.getUniqueName(arrayList, string2);
    }

    private void addChildrenNames(DBObject[] dBObjectArray, Collection collection) {
        int n = 0;
        while (n < dBObjectArray.length) {
            collection.add(dBObjectArray[n].getName());
            ++n;
        }
    }

    private void checkChildrenNames(String string, DBObject[] dBObjectArray) throws NameInUseException {
        int n = 0;
        while (n < dBObjectArray.length) {
            if (string.equals(dBObjectArray[n].getName())) {
                throw new NameInUseException(string, dBObjectArray[n].getParent().getName(), dBObjectArray[n].getParent().getType());
            }
            ++n;
        }
    }

    protected String normaliseType(String string) {
        return string.equals("UniqueConstraint") || string.equals("PKConstraint") || string.equals("FKConstraint") || string.equals("CheckConstraint") ? "CONSTRAINT" : string;
    }

    public Schema[] listSchemas(boolean bl) throws DBException {
        throw new UnsupportedOperationException("listSchemas(boolean)");
    }

    public boolean canRestrictSchemaList() {
        return false;
    }

    protected abstract String getName();

    public abstract boolean canCreate(SchemaObject var1, boolean var2);

    public abstract void createObject(SchemaObject var1, boolean var2) throws DBException;

    public abstract void createObjects(SchemaObject[] var1, boolean var2) throws DBException;

    public abstract boolean canDelete(SchemaObject var1, boolean var2);

    public abstract void deleteObject(SchemaObject var1, boolean var2) throws DBException;

    public abstract void deleteObjects(SchemaObject[] var1, boolean var2) throws DBException;

    public abstract void undeleteObject(SchemaObject var1) throws DBException;

    public abstract void undeleteObjects(SchemaObject[] var1) throws DBException;

    public abstract void updateObject(SchemaObject var1, SchemaObject var2) throws DBException;

    public abstract void updateObjects(SchemaObject[] var1, SchemaObject[] var2) throws DBException;

    public abstract Schema[] listSchemas() throws DBException;

    public abstract Schema getSchema(String var1) throws DBException;

    public abstract boolean canCreate(Schema var1, boolean var2);

    public abstract void createSchema(Schema var1, boolean var2) throws DBException;

    public abstract boolean canDelete(Schema var1, boolean var2);

    public abstract void deleteSchema(Schema var1, boolean var2) throws DBException;

    public abstract void updateSchema(Schema var1, Schema var2) throws DBException;

    public AbstractDBObjectProvider() {
        this.$init$();
    }

    private class ObjectTypeEntry {
        private Map _objectMap;
        private Map _idToObjectMap;
        private String _type;
        private DBObjectBuilder _builder;
        private DBObjectValidator _validator;
        static final /* synthetic */ boolean $assertionsDisabled;

        void $init$() {
            this._objectMap = new HashMap();
            this._idToObjectMap = new HashMap();
        }

        private ObjectTypeEntry(String string, DBObjectBuilder dBObjectBuilder, DBObjectValidator dBObjectValidator) {
            this.$init$();
            this._type = string;
            this._builder = dBObjectBuilder;
            this._validator = dBObjectValidator;
        }

        private DBObjectBuilder getBuilder() {
            return this._builder;
        }

        static {
            $assertionsDisabled = ObjectTypeEntry.class.desiredAssertionStatus() ^ true;
        }

        private void setBuilder(DBObjectBuilder dBObjectBuilder) {
            if (!$assertionsDisabled && dBObjectBuilder == null) {
                throw new AssertionError();
            }
            this._builder = dBObjectBuilder;
        }

        private DBObjectValidator getValidator() {
            return this._validator;
        }

        private void setValidator(DBObjectValidator dBObjectValidator) {
            this._validator = dBObjectValidator;
        }

        private SchemaObject findObject(Schema schema, String string) {
            String string2 = this._getKey(schema, string);
            return (SchemaObject)this._objectMap.get(string2);
        }

        private SchemaObject findObject(DBObjectID dBObjectID) {
            return (SchemaObject)this._idToObjectMap.get(dBObjectID);
        }

        private void cacheObject(SchemaObject schemaObject) {
            String string = this._getKey(schemaObject.getSchema(), schemaObject.getName());
            this._objectMap.put(string, schemaObject);
            DBObjectID dBObjectID = schemaObject.getID();
            if (dBObjectID != null) {
                this._idToObjectMap.put(dBObjectID, schemaObject);
            }
        }

        private void updateCachedObject(SchemaObject schemaObject, SchemaObject schemaObject2) {
            String string = this._getKey(schemaObject.getSchema(), schemaObject.getName());
            DBObjectID dBObjectID = schemaObject.getID();
            DBUtil.updateObjectAndIDs(schemaObject, schemaObject2);
            String string2 = this._getKey(schemaObject.getSchema(), schemaObject.getName());
            DBObjectID dBObjectID2 = schemaObject.getID();
            if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                this._objectMap.remove(string);
                this._objectMap.put(string2, schemaObject);
            }
            if (ModelUtil.areDifferent((Object)dBObjectID, (Object)dBObjectID2)) {
                if (dBObjectID != null) {
                    this._idToObjectMap.remove(dBObjectID);
                }
                if (dBObjectID2 != null) {
                    this._idToObjectMap.put(dBObjectID2, schemaObject);
                }
            }
            DBObjectChange.fireObjectUpdated(schemaObject);
        }

        private void clearCache() {
            this._objectMap.clear();
            this._idToObjectMap.clear();
        }

        private void addObjectToCache(SchemaObject schemaObject) {
            SchemaObject schemaObject2 = this.findObject(schemaObject.getSchema(), schemaObject.getName());
            if (schemaObject2 != schemaObject) {
                if (schemaObject2 != null) {
                    this.removeObjectFromCache(schemaObject.getSchema(), schemaObject.getName());
                }
                if (schemaObject != null) {
                    this.cacheObject(schemaObject);
                }
            }
        }

        private void removeObjectFromCache(Schema schema, String string) {
            DBObjectID dBObjectID;
            SchemaObject schemaObject = (SchemaObject)this._objectMap.remove(this._getKey(schema, string));
            if (schemaObject != null && this._idToObjectMap.get(dBObjectID = schemaObject.getID()) == schemaObject) {
                this._idToObjectMap.remove(dBObjectID);
            }
        }

        private String _getKey(Schema schema, String string) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = string2 = schema != null ? schema.getName() : null;
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append('\n');
            stringBuffer.append(string);
            return stringBuffer.toString();
        }

        static DBObjectBuilder mav$getBuilder(ObjectTypeEntry objectTypeEntry) {
            return objectTypeEntry.getBuilder();
        }

        static SchemaObject mav$findObject(ObjectTypeEntry objectTypeEntry, DBObjectID dBObjectID) {
            return objectTypeEntry.findObject(dBObjectID);
        }

        static void mav$cacheObject(ObjectTypeEntry objectTypeEntry, SchemaObject schemaObject) {
            objectTypeEntry.cacheObject(schemaObject);
        }

        static void mav$removeObjectFromCache(ObjectTypeEntry objectTypeEntry, Schema schema, String string) {
            objectTypeEntry.removeObjectFromCache(schema, string);
        }

        static void mav$updateCachedObject(ObjectTypeEntry objectTypeEntry, SchemaObject schemaObject, SchemaObject schemaObject2) {
            objectTypeEntry.updateCachedObject(schemaObject, schemaObject2);
        }

        static SchemaObject mav$findObject(ObjectTypeEntry objectTypeEntry, Schema schema, String string) {
            return objectTypeEntry.findObject(schema, string);
        }

        static void mav$addObjectToCache(ObjectTypeEntry objectTypeEntry, SchemaObject schemaObject) {
            objectTypeEntry.addObjectToCache(schemaObject);
        }

        static void mav$clearCache(ObjectTypeEntry objectTypeEntry) {
            objectTypeEntry.clearCache();
        }

        static DBObjectValidator mav$getValidator(ObjectTypeEntry objectTypeEntry) {
            return objectTypeEntry.getValidator();
        }

        static void mav$setValidator(ObjectTypeEntry objectTypeEntry, DBObjectValidator dBObjectValidator) {
            objectTypeEntry.setValidator(dBObjectValidator);
        }

        static void mav$setBuilder(ObjectTypeEntry objectTypeEntry, DBObjectBuilder dBObjectBuilder) {
            objectTypeEntry.setBuilder(dBObjectBuilder);
        }

        ObjectTypeEntry(String string, DBObjectBuilder dBObjectBuilder, DBObjectValidator dBObjectValidator, 1 var5_5) {
            this(string, dBObjectBuilder, dBObjectValidator);
        }

        public final class 1 {
        }
    }
}

