/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.SchemaValidator;
import oracle.javatools.db.validators.SequenceValidator;
import oracle.javatools.db.validators.SynonymValidator;
import oracle.javatools.util.Log;

public abstract class AbstractDatabase
extends AbstractDBObjectProvider
implements Database {
    public static final String SQLSTATE_NOT_IMPLEMENTED = "S1C00";
    private String _connName;
    private Connection _conn;
    private DDLGenerator _defaultGen;

    protected AbstractDatabase(String string, Connection connection) {
        this._connName = string;
        this._conn = connection;
        DBUtil.getLog().trace("{0}: new {1}", (Object)string, (Object)this.getClass().getName());
        this.registerBuilders();
        this.registerValidators();
    }

    protected void sqlTrace(String string) {
        AbstractDatabase.sqlTrace(this._connName, string, null);
    }

    protected void sqlTrace(String string, Object[] objectArray) {
        AbstractDatabase.sqlTrace(this._connName, string, objectArray);
    }

    static void sqlTrace(String string, String string2, Object[] objectArray) {
        Log log = DBUtil.getSQLLog();
        if (log.isEnabled()) {
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != null) {
                        string2 = string2.replaceFirst("\\?", "'" + objectArray[n].toString() + "'");
                    }
                    ++n;
                }
            }
            log.trace("{0}: {1}", (Object)string, (Object)string2);
        }
    }

    protected void registerValidators() {
        this.registerValidator("SCHEMA", new SchemaValidator(this));
        this.registerValidator("SEQUENCE", new SequenceValidator(this));
        this.registerValidator("SYNONYM", new SynonymValidator(this));
        this.registerValidator("INDEX", new IndexValidator(this));
        this.registerValidator("CONSTRAINT", new ConstraintValidator(this));
        this.registerValidator("COLUMN", new ColumnValidator(this));
    }

    protected void setDDLGenerator(DDLGenerator dDLGenerator) {
        this._defaultGen = dDLGenerator;
    }

    public DDLGenerator getDDLGenerator() {
        return this._defaultGen;
    }

    protected boolean exists(SchemaObject schemaObject) {
        return schemaObject != null && this.exists(schemaObject.getType(), AbstractDatabase.convertObject(schemaObject.getSchema()), AbstractDatabase.convertObject(schemaObject));
    }

    protected abstract void registerBuilders();

    public Connection getConnection() {
        try {
            DatabaseMetaData databaseMetaData = this._conn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.reconnect();
        }
        return this._conn;
    }

    public String getName() {
        return this._connName;
    }

    public String getConnectionName() {
        return this._connName;
    }

    private void reconnect() {
        this.close();
        try {
            Connection connection = DatabaseFactory.createConnection(this);
            if (connection != null) {
                this._conn = connection;
            }
        }
        catch (Exception exception) {
            this.close();
        }
    }

    public void close() {
        if (this._conn != null) {
            try {
                this._conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clearAllCaches();
            this.fireProviderClosed();
        }
    }

    public boolean exists(String string, String string2, String string3) {
        boolean bl = false;
        try {
            bl = this.getObject(string, this.getSchema(string2), string3) != null;
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return bl;
    }

    public boolean isObjectValid(String string, String string2, String string3) {
        return this.exists(string, string2, string3);
    }

    protected final Schema createSchema(String string) {
        Schema schema = new Schema(string);
        return schema;
    }

    protected void finishCreate(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) throws DBException {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>();
        DBException dBException = null;
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject schemaObject;
            SchemaObject schemaObject2 = schemaObjectArray[n];
            SchemaObject schemaObject3 = schemaObjectArray2 == null ? null : schemaObjectArray2[n];
            Schema schema = this.getSchema(schemaObject2.getSchema().getName());
            if (schemaObject3 != null) {
                this.uncacheObject(schemaObject3);
            }
            if ((schemaObject = this.getCreatedObject(schemaObject2.getType(), schema, schemaObject2.getName())) == null) {
                DBException dBException2 = new DBException((DBObject)schemaObject2, "Error fetching new object back from the database");
                if (dBException == null) {
                    dBException = dBException2;
                } else {
                    dBException.setNextException(dBException2);
                }
            } else if (schemaObject3 != null) {
                DBUtil.updateObjectAndIDs(schemaObject3, schemaObject);
                this.cacheObject(schemaObject3);
                DBObjectChange.fireObjectUpdated(schemaObject3);
            } else {
                DBObjectBuilder dBObjectBuilder = this.getBuilderForType(schemaObject.getType());
                arrayList.add(schemaObject);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            SchemaObject[] schemaObjectArray3 = arrayList.toArray(new SchemaObject[arrayList.size()]);
            this.fireObjectsAdded(schemaObjectArray3[0].getSchema(), schemaObjectArray3);
        }
        if (dBException != null) {
            throw dBException;
        }
    }

    protected SchemaObject getCreatedObject(String string, Schema schema, String string2) throws DBException {
        return this.getObject(string, schema, string2);
    }

    protected void finishDelete(Schema schema, SchemaObject[] schemaObjectArray) {
        this.fireObjectsRemoved(schema, schemaObjectArray);
        int n = 0;
        while (n < schemaObjectArray.length) {
            if (schemaObjectArray[n] instanceof Index) {
                Table table = ((Index)schemaObjectArray[n]).getTable();
                table.removeIndex((Index)schemaObjectArray[n]);
                DBObjectChange.fireObjectUpdated(table);
            }
            SchemaObjectManager schemaObjectManager = this.getObjectManager();
            DBObjectID[] dBObjectIDArray = schemaObjectManager.getSchemaObjectReferers(schemaObjectArray[n], false);
            int n2 = 0;
            while (n2 < dBObjectIDArray.length) {
                try {
                    SchemaObject schemaObject = (SchemaObject)dBObjectIDArray[n2].resolveID();
                    schemaObjectManager.cascadeDelete(schemaObjectArray[n], schemaObject);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                ++n2;
            }
            this.uncacheObject(schemaObjectArray[n]);
            ++n;
        }
    }

    public void createObjects(SchemaObject[] schemaObjectArray, boolean bl) throws DBException {
        int n = 0;
        while (n < schemaObjectArray.length) {
            this.createObject(schemaObjectArray[n], bl);
            ++n;
        }
    }

    protected SchemaObject createByIDImpl(DBObjectID dBObjectID) throws DBException {
        BaseObjectID baseObjectID;
        SchemaObject schemaObject = null;
        if (dBObjectID instanceof BaseObjectID && (schemaObject = this.createSchemaObjectImpl((baseObjectID = (BaseObjectID)dBObjectID).getType(), baseObjectID.getSchema(), baseObjectID.getName())) != null) {
            schemaObject.setID(dBObjectID);
        }
        return schemaObject;
    }

    public void deleteObjects(SchemaObject[] schemaObjectArray, boolean bl) throws DBException {
        int n = 0;
        while (n < schemaObjectArray.length) {
            this.deleteObject(schemaObjectArray[n], bl);
            ++n;
        }
    }

    public void updateObjects(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) throws DBException {
        if (schemaObjectArray.length != schemaObjectArray2.length) {
            throw new IllegalArgumentException("New and old objects must have a 1:1 correspondance.");
        }
        int n = 0;
        while (n < schemaObjectArray.length) {
            this.updateObject(schemaObjectArray[n], schemaObjectArray2[n]);
            ++n;
        }
    }

    public String getDatabaseSource(String string, Schema schema, String string2) throws DBException {
        return null;
    }

    public String getDatabaseSource(String string, Schema schema, String string2, String string3) throws DBException {
        return null;
    }

    public Schema getDefaultSchema() throws DBException {
        return this.getSchema(this.getUserName());
    }

    String[] getDatabaseMultiSource(String string, Schema schema, String string2) throws DBException {
        return null;
    }

    public Long getTimestamp(String string, Schema schema, String string2) throws DBException {
        return null;
    }

    public Long getTimestamp(DBObjectID dBObjectID) throws DBException {
        return null;
    }

    public boolean supportsDebugging() {
        return false;
    }

    protected SchemaObject getObjectImpl(String string, Schema schema, String string2) throws DBException {
        ComplexType complexType;
        if ("TYPE".equals(string) && (complexType = DataTypeRegistry.getInstance().findComplexType(string2, schema.getName(), this.getClass())) != null) {
            return complexType;
        }
        return super.getObjectImpl(string, schema, string2);
    }

    protected DatabaseDescriptor getDescriptor() {
        return DatabaseFactory.getDatabaseDescriptor(this.getClass());
    }

    protected int getCasePolicy() {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor != null) {
            return databaseDescriptor.getCasePolicy();
        }
        return 2;
    }

    public String getIdentifierQuoteString() {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor != null) {
            return databaseDescriptor.getIdentifierQuoteString();
        }
        return super.getIdentifierQuoteString();
    }

    public final void validateName(String string, String string2) throws InvalidNameException {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor != null) {
            databaseDescriptor.validateName(string, string2);
        }
    }
}

