/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaObject
extends AbstractDBObject
implements SchemaObject {
    private Schema _schema;
    private DBObjectBuilder _builder;
    private Set<String> _built;
    private List<SchemaObjectListener> _listeners;

    protected AbstractSchemaObject() {
    }

    protected AbstractSchemaObject(String string, Schema schema, DBObjectID dBObjectID) {
        super(string, dBObjectID);
        this._schema = schema;
    }

    protected AbstractSchemaObject(String string, Schema schema) {
        this(string, schema, null);
    }

    protected void copyToImpl(AbstractSchemaObject abstractSchemaObject, boolean bl) {
        this.checkInit();
        super.copyToImpl(abstractSchemaObject, bl);
        abstractSchemaObject._schema = this._schema;
    }

    protected boolean equalsImpl(AbstractSchemaObject abstractSchemaObject) {
        this.checkInit();
        abstractSchemaObject.checkInit();
        return super.equalsImpl(abstractSchemaObject) && ModelUtil.areEqual((Object)this._schema, (Object)abstractSchemaObject._schema);
    }

    @Override
    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    void setBuilder(DBObjectBuilder dBObjectBuilder) {
        this._builder = dBObjectBuilder;
    }

    void clearBuiltList() {
        this._built = null;
    }

    void setBuilt(String string) {
        if (string != null && this._builder != null) {
            if (this._built == null) {
                this._built = new HashSet<String>();
            }
            this._built.add(string);
        }
    }

    synchronized boolean isBuilt(String string) {
        return this._built != null && this._built.contains(string);
    }

    protected boolean needsInitialization() {
        return this._builder != null;
    }

    protected synchronized void checkInit(String string) {
        if (this._builder == null) {
            return;
        }
        if (string != null && this.isBuilt(string)) {
            return;
        }
        long l = System.currentTimeMillis();
        DBObjectBuilder dBObjectBuilder = this._builder;
        if (string == null) {
            this._builder = null;
        } else {
            this.setBuilt(string);
        }
        try {
            if (string == null) {
                dBObjectBuilder.buildObject(this);
            } else {
                dBObjectBuilder.buildObjectComponent(this, string);
            }
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        l = System.currentTimeMillis() - l;
        DBUtil.getLog().trace("Building {0} of {1}.{2} took {3}ms", new Object[]{string == null ? "all" : string, this._schema == null ? "null" : this._schema.getName(), this.getName(), Long.toString(l)});
    }

    protected void checkInit() {
        this.checkInit(null);
    }

    @Override
    public DBObject getParent() {
        return null;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        this.checkInit();
        super.getOwnedObjectsImpl(collection, stringArray);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        this.checkInit();
        super.getReferenceIDsImpl(collection);
    }

    @Override
    public final void removeObjectListener(SchemaObjectListener schemaObjectListener) {
        if (this._listeners != null) {
            this._listeners.remove(schemaObjectListener);
        }
    }

    @Override
    public final void addObjectListener(SchemaObjectListener schemaObjectListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<SchemaObjectListener>();
        }
        this._listeners.add(schemaObjectListener);
    }

    @Override
    public final void fireObjectUpdated(DBObjectChange dBObjectChange) {
        if (this._listeners != null) {
            dBObjectChange.log();
            SchemaObjectListener[] schemaObjectListenerArray = this._listeners.toArray(new SchemaObjectListener[this._listeners.size()]);
            int n = 0;
            while (n < schemaObjectListenerArray.length) {
                if (schemaObjectListenerArray != null) {
                    schemaObjectListenerArray[n].schemaObjectUpdated(dBObjectChange);
                }
                ++n;
            }
        }
    }

    @Override
    public Map getProperties() {
        this.checkInit();
        return super.getProperties();
    }

    @Override
    public Object getProperty(String string) {
        this.checkInit(string);
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(String string, Object object) {
        this.checkInit(string);
        return super.getProperty(string, object);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.checkInit(string);
        super.setProperty(string, object);
    }

    @Override
    public void setProperties(Map map) {
        this.checkInit();
        super.setProperties(map);
    }
}

