/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

public final class BaseObjectID
extends AbstractDBObjectID {
    private Schema _schema;
    private String _name;
    private AbstractDatabase _db;
    private String _label;
    private int _hash;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static BaseObjectID createObjectID(Schema schema, String string, String string2, AbstractDatabase abstractDatabase) {
        return new BaseObjectID(schema, string, string2, abstractDatabase, null);
    }

    public static BaseObjectID createObjectID(Schema schema, String string, String string2, AbstractDatabase abstractDatabase, BaseObjectID baseObjectID) {
        return new BaseObjectID(schema, string, string2, abstractDatabase, baseObjectID);
    }

    static {
        $assertionsDisabled = BaseObjectID.class.desiredAssertionStatus() ^ true;
    }

    private BaseObjectID(Schema schema, String string, String string2, AbstractDatabase abstractDatabase, DBObjectID dBObjectID) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && abstractDatabase == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && schema == null && dBObjectID == null) {
            throw new AssertionError();
        }
        this._schema = schema;
        this._name = string;
        this._db = abstractDatabase;
        this.setType(string2);
        this.setParent(dBObjectID);
    }

    public synchronized String toString() {
        if (this._label == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getType()).append('(');
            String string = AbstractDBObjectProvider.convertObject(this._schema);
            if (ModelUtil.hasLength((String)string)) {
                stringBuffer.append(string).append('.');
            }
            stringBuffer.append(this._name).append(')');
            this._label = stringBuffer.toString();
        }
        return this._label;
    }

    public DBObject resolveID() throws DBException {
        if (this.getParent() != null) {
            return this.resolveFromParent();
        }
        if (this._db == null) {
            throw new DBException(null, "ID has not been given a database to resolve with");
        }
        return this._db.findByID(this);
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(DBObjectID dBObjectID, boolean bl) {
        return dBObjectID instanceof BaseObjectID && this.equalsImpl((BaseObjectID)dBObjectID);
    }

    private boolean equalsImpl(BaseObjectID baseObjectID) {
        return ModelUtil.areEqual((Object)this.getType(), (Object)baseObjectID.getType()) && ModelUtil.areEqual((Object)this._schema, (Object)baseObjectID._schema) && ModelUtil.areEqual((Object)this._name, (Object)baseObjectID._name);
    }
}

