/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
extends AbstractDBObject {
    private Object _default;
    private boolean _notNull;
    private DataTypeUsage _dataTypeUsage;
    private transient Relation _relation;
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final String TYPE = "COLUMN";

    public Column() {
    }

    public Column(String string) {
        super(string);
    }

    public Column(String string, DataTypeUsage dataTypeUsage) {
        super(string);
        this._dataTypeUsage = dataTypeUsage;
    }

    static {
        $assertionsDisabled = Column.class.desiredAssertionStatus() ^ true;
    }

    public Column(String string, DataType dataType) {
        super(string);
        if (dataType != null && dataType.getID() != null) {
            try {
                DataType dataType2 = (DataType)dataType.getID().resolveID();
                if (!$assertionsDisabled && dataType2 == null) {
                    throw new AssertionError();
                }
                this._dataTypeUsage = dataType2.createDefaultUsage();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
    }

    public Column(String string, DBObjectID dBObjectID) {
        super(string);
        if (dBObjectID != null) {
            try {
                DataType dataType = (DataType)dBObjectID.resolveID();
                if (!$assertionsDisabled && dataType == null) {
                    throw new AssertionError();
                }
                this._dataTypeUsage = dataType.createDefaultUsage();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        Column column = dBObject != null ? (Column)dBObject : new Column();
        this.copyToImpl(column, bl);
        return column;
    }

    protected void copyToImpl(Column column, boolean bl) {
        super.copyToImpl(column, bl);
        column._default = this._default;
        column._notNull = this._notNull;
        column._dataTypeUsage = this._dataTypeUsage == null ? null : (DataTypeUsage)this._dataTypeUsage.copyTo(null);
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equalsImpl((Column)object);
    }

    protected boolean equalsImpl(Column column) {
        return super.equalsImpl(column) && ModelUtil.areEqual((Object)this._default, (Object)column._default) && this._notNull == column._notNull && ModelUtil.areEqual((Object)this._dataTypeUsage, (Object)column._dataTypeUsage);
    }

    public void setDefault(Object object) {
        this._default = object;
    }

    public Object getDefault() {
        return this._default;
    }

    public boolean isNotNull() {
        return this._notNull;
    }

    public void setNotNull(boolean bl) {
        this._notNull = bl;
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this._dataTypeUsage = dataTypeUsage;
    }

    public DataTypeUsage getDataTypeUsage() {
        return this._dataTypeUsage;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Relation getRelation() throws TransientMarker {
        return this._relation;
    }

    public void setRelation(Relation relation) {
        this._relation = relation;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        DBObjectID dBObjectID;
        super.getReferenceIDsImpl(collection);
        if (this._dataTypeUsage != null && (dBObjectID = this._dataTypeUsage.getDataTypeID()) != null) {
            collection.add(dBObjectID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        DBObjectID dBObjectID;
        if (this._dataTypeUsage != null && (dBObjectID = this._dataTypeUsage.getDataTypeID()) != null && map.containsKey(dBObjectID)) {
            this._dataTypeUsage.setDataTypeID(map.get(dBObjectID));
            return true;
        }
        return super.replaceReferenceIDs(map);
    }

    @Override
    public DBObject getParent() {
        return this._relation;
    }

    public Long getPrecision() throws TransientMarker {
        if (this._dataTypeUsage == null) {
            return null;
        }
        Long l = DataTypeHelper.getLongAttributeValue(this._dataTypeUsage, "precision");
        Long l2 = DataTypeHelper.getLongAttributeValue(this._dataTypeUsage, "size");
        return l == null ? l2 : l;
    }

    public void setPrecision(Long l) {
        if (this._dataTypeUsage != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(this._dataTypeUsage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null) {
                if (dataType.hasDataTypeAttribute("precision")) {
                    this._dataTypeUsage.putAttributeValue("precision", l);
                }
                if (dataType.hasDataTypeAttribute("size")) {
                    this._dataTypeUsage.putAttributeValue("size", l);
                }
            }
        }
    }

    public Long getScale() throws TransientMarker {
        if (this._dataTypeUsage == null) {
            return null;
        }
        return DataTypeHelper.getLongAttributeValue(this._dataTypeUsage, "scale");
    }

    public void setScale(Long l) {
        if (this._dataTypeUsage != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(this._dataTypeUsage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null && dataType.hasDataTypeAttribute("scale")) {
                this._dataTypeUsage.putAttributeValue("scale", l);
            }
        }
    }
}

