/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.Relation;
import oracle.javatools.util.ModelUtil;

public abstract class ColumnConstraint
extends Constraint {
    private List<Column> _columns;

    void $init$() {
        this._columns = new ArrayList<Column>();
    }

    ColumnConstraint() {
        this.$init$();
    }

    ColumnConstraint(String string, Relation relation) {
        super(string, relation);
        this.$init$();
    }

    protected void copyToImpl(ColumnConstraint columnConstraint, Relation relation, boolean bl) {
        super.copyToImpl(columnConstraint, bl);
        columnConstraint._columns.clear();
        for (Column column : this._columns) {
            if (relation == null) {
                columnConstraint.addColumn((Column)column.copyTo(null, relation, bl));
                continue;
            }
            columnConstraint.addColumn(relation.getColumn(column.getName()));
        }
    }

    protected boolean equalsImpl(ColumnConstraint columnConstraint) {
        return super.equalsImpl(columnConstraint) && ModelUtil.areEqual(this._columns, columnConstraint._columns);
    }

    public Column[] getColumns() {
        return this._columns.toArray(new Column[this._columns.size()]);
    }

    public void setColumns(Column[] columnArray) {
        this._columns = new ArrayList<Column>(Arrays.asList(columnArray));
    }

    public void addColumn(Column column) {
        if (!this._columns.contains(column)) {
            this._columns.add(column);
        }
    }

    public void removeColumn(Column column) {
        if (this._columns.contains(column)) {
            this._columns.remove(column);
        }
    }

    public void setRelation(Relation relation) {
        super.setRelation(relation);
        if (relation != null && this._columns != null) {
            for (Column column : this._columns) {
                if (column.getRelation() != null) continue;
                column.setRelation(relation);
            }
        }
    }
}

