/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.Log;

public class DBObjectChange {
    public static final String NAME_PROPERTY = "name";
    private DBObject m_obj;
    private static final String ADD_KEY = "ADDED";
    private static final String KID_KEY = "CHILDREN";
    private static final String PROP_KEY = "PROPERTIES";
    private static final String DEL_KEY = "REMOVED";
    private static final String ORD_KEY = "ORDERED";

    protected DBObjectChange(DBObject dBObject) {
        this.m_obj = dBObject;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    public List getOwnedObjectsAdded() {
        return null;
    }

    public List getOwnedObjectsRemoved() {
        return null;
    }

    public Map getPropertiesChanged() {
        return null;
    }

    public Map getOwnedObjectsChanged() {
        return null;
    }

    Map getOwnedObjectsReordered() {
        return null;
    }

    public boolean hasNameChanged() {
        Map map = this.getPropertiesChanged();
        return map != null && (map.containsKey(NAME_PROPERTY) || map.containsKey("Name "));
    }

    void log() {
        Log log = DBUtil.getLog();
        if (log.isEnabled()) {
            DBObject dBObject = this.getDBObject();
            if (dBObject == null) {
                log.trace("DBObjectChange fired on null object!");
            } else {
                log.trace("DBObjectChange on {0} {1}:", (Object)dBObject.getType(), (Object)dBObject.getName());
            }
        }
    }

    public static void fireObjectUpdated(SchemaObject schemaObject) {
        Impl impl = new Impl(schemaObject, null);
        schemaObject.fireObjectUpdated(impl);
    }

    public static void fireChildrenAdded(SchemaObject schemaObject, List list) {
        Impl impl = new Impl(schemaObject, null);
        Impl.ra$m_changes(impl).put(ADD_KEY, list);
        schemaObject.fireObjectUpdated(impl);
    }

    public static void fireChildrenRemoved(SchemaObject schemaObject, List list) {
        Impl impl = new Impl(schemaObject, null);
        Impl.ra$m_changes(impl).put(DEL_KEY, list);
        schemaObject.fireObjectUpdated(impl);
    }

    public static void firePropertyChanged(SchemaObject schemaObject, PropertyChangeEvent propertyChangeEvent) {
        Impl impl = new Impl(schemaObject, null);
        HashMap<String, PropertyChangeEvent> hashMap = new HashMap<String, PropertyChangeEvent>(1);
        hashMap.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent);
        Impl.ra$m_changes(impl).put(PROP_KEY, hashMap);
        schemaObject.fireObjectUpdated(impl);
    }

    public static void firePropertiesChanged(SchemaObject schemaObject, Map map) {
        Impl impl = new Impl(schemaObject, null);
        Impl.ra$m_changes(impl).put(PROP_KEY, map);
        schemaObject.fireObjectUpdated(impl);
    }

    public static void fireObjectUpdated(SchemaObject schemaObject, List list, List list2, Map map) {
        Impl impl = new Impl(schemaObject, null);
        Impl.ra$m_changes(impl).put(ADD_KEY, list);
        Impl.ra$m_changes(impl).put(DEL_KEY, list2);
        Impl.ra$m_changes(impl).put(PROP_KEY, map);
        schemaObject.fireObjectUpdated(impl);
    }

    public static void fireSchemaUpdated(AbstractDBObjectProvider abstractDBObjectProvider, Schema schema, Map map) {
        Impl impl = new Impl(schema, null);
        Impl.ra$m_changes(impl).put(PROP_KEY, map);
        abstractDBObjectProvider.fireSchemaUpdated(impl);
    }

    public static class Impl
    extends DBObjectChange {
        private Map m_changes;

        void $init$() {
            this.m_changes = new HashMap();
        }

        private Impl(DBObject dBObject) {
            super(dBObject);
            this.$init$();
        }

        private List getChangeList(String string) {
            if (this.m_changes.containsKey(string)) {
                return (List)this.m_changes.get(string);
            }
            return new ArrayList(0);
        }

        private Map getChangeMap(String string) {
            if (this.m_changes.containsKey(string)) {
                return (Map)this.m_changes.get(string);
            }
            return new HashMap(0);
        }

        public List getOwnedObjectsAdded() {
            return this.getChangeList(DBObjectChange.ADD_KEY);
        }

        public Map getOwnedObjectsChanged() {
            return this.getChangeMap(DBObjectChange.KID_KEY);
        }

        public List getOwnedObjectsRemoved() {
            return this.getChangeList(DBObjectChange.DEL_KEY);
        }

        public Map getOwnedObjectsReordered() {
            return this.getChangeMap(DBObjectChange.ORD_KEY);
        }

        public Map getPropertiesChanged() {
            return this.getChangeMap(DBObjectChange.PROP_KEY);
        }

        void log() {
            super.log();
            Log log = DBUtil.getLog();
            if (log.isEnabled()) {
                for (String string : this.m_changes.keySet()) {
                    log.trace(" |- {0}: {1}", (Object)string, (Object)this.convert(this.m_changes.get(string)));
                }
            }
        }

        private String convert(Object object) {
            if (object instanceof List) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e instanceof DBObject) {
                        stringBuffer.append(((DBObject)e).getName());
                    } else {
                        stringBuffer.append(e.toString());
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                return stringBuffer.toString();
            }
            if (object instanceof Map) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = ((Map)object).keySet().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next().toString());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                return stringBuffer.toString();
            }
            return object == null ? null : object.toString();
        }

        Impl(DBObject dBObject, 1 var2_2) {
            this(dBObject);
        }

        static Map ra$m_changes(Impl impl) {
            return impl.m_changes;
        }

        public final class 1 {
        }
    }
}

