/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;

public interface DBObjectProvider {
    public static final String CREATE_PRIVILEDGE = "CREATE";
    public static final String DELETE_PRIVILEDGE = "DELETE";
    public static final String MODIFY_PRIVILEDGE = "MODIFY";

    public void addProviderListener(DBObjectProviderListener var1);

    public void removeProviderListener(DBObjectProviderListener var1);

    public boolean canCreate(SchemaObject var1, boolean var2);

    public void createObject(SchemaObject var1, boolean var2) throws DBException;

    public void createObjects(SchemaObject[] var1, boolean var2) throws DBException;

    public void deleteObject(SchemaObject var1, boolean var2) throws DBException;

    public void deleteObjects(SchemaObject[] var1, boolean var2) throws DBException;

    public void undeleteObject(SchemaObject var1) throws DBException;

    public void undeleteObjects(SchemaObject[] var1) throws DBException;

    public boolean hasPriviledge(String var1, Schema var2, String var3);

    public String getUniqueName(String var1, DBObject var2, String var3);

    public void validateUniqueName(String var1, DBObject var2, String var3) throws NameInUseException;

    public boolean isValidName(String var1);

    public boolean isValidName(String var1, String var2);

    public void validateName(String var1) throws InvalidNameException;

    public void validateName(String var1, String var2) throws InvalidNameException;

    public String quoteIdentifier(String var1, boolean var2) throws DBException;

    public String getInternalName(String var1);

    public String getInternalName(String var1, String var2);

    public String getExternalName(String var1);

    public String getExternalName(String var1, String var2);

    public String getIdentifierQuoteString();

    public boolean canDelete(SchemaObject var1, boolean var2);

    public void validateObject(DBObject var1) throws ValidationException;

    public void validateObject(DBObject var1, String var2) throws ValidationException;

    public void validateObject(DBObject var1, DBObject var2) throws ValidationException;

    public void validateObject(DBObject var1, DBObject var2, String var3) throws ValidationException;

    public void validateSchema(Schema var1) throws ValidationException;

    public void validateSchema(Schema var1, Schema var2) throws ValidationException;

    public SchemaObject getObject(String var1, Schema var2, String var3) throws DBException;

    public void updateObject(SchemaObject var1, SchemaObject var2) throws DBException;

    public void updateObjects(SchemaObject[] var1, SchemaObject[] var2) throws DBException;

    public String[] listObjects(String var1, Schema var2) throws DBException;

    public String[] listObjects(String var1, Schema var2, String var3) throws DBException;

    public SchemaObject[] listObjects(String[] var1, Schema var2) throws DBException;

    public SchemaObject[] listObjects(String[] var1, Schema var2, String var3) throws DBException;

    public Long getTimestamp(String var1, Schema var2, String var3) throws DBException;

    public Long getTimestamp(DBObjectID var1) throws DBException;

    public String[] listObjectTypes();

    public boolean supportsObjectType(String var1);

    public DataType[] listSupportedDataTypes();

    public DataType getDataType(String var1);

    public Schema[] listSchemas() throws DBException;

    public Schema[] listSchemas(boolean var1) throws DBException;

    public boolean canRestrictSchemaList();

    public Schema getSchema(String var1) throws DBException;

    public Schema getDefaultSchema() throws DBException;

    public boolean canCreate(Schema var1, boolean var2);

    public void createSchema(Schema var1, boolean var2) throws DBException;

    public void updateSchema(Schema var1, Schema var2) throws DBException;

    public boolean canDelete(Schema var1, boolean var2);

    public void deleteSchema(Schema var1, boolean var2) throws DBException;
}

