/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.JdbcDatabaseFactory;
import oracle.javatools.db.SQLServer.SQLServerDatabaseFactory;
import oracle.javatools.db.db2.DB2UniversalDatabaseFactory;
import oracle.javatools.db.informix.InformixDynamicServerFactory;
import oracle.javatools.db.mysql.MySQLDatabaseFactory;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.db.sybase.AdaptiveServerDatabaseFactory;
import oracle.javatools.db.timesten.TimesTenDatabaseFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectProviderFactory {
    private static List<DBObjectProviderFactory> s_factories;
    private static Map<Object, DBObjectProvider> s_providers;
    private static DBObjectProviderFactory[] s_defaultFactories;

    protected abstract DBObjectProvider createProviderImpl(Object var1) throws DBException;

    protected boolean canCache(Object object) {
        return true;
    }

    static {
        s_defaultFactories = new DBObjectProviderFactory[]{OracleDatabaseFactory.getInstance(), new MySQLDatabaseFactory(), new SQLServerDatabaseFactory(), new AdaptiveServerDatabaseFactory(), new DB2UniversalDatabaseFactory(), new InformixDynamicServerFactory(), new TimesTenDatabaseFactory(), new JdbcDatabaseFactory()};
    }

    public static void registerFactory(DBObjectProviderFactory dBObjectProviderFactory) {
        if (s_factories == null) {
            s_factories = new ArrayList<DBObjectProviderFactory>();
        }
        if (!s_factories.contains(dBObjectProviderFactory)) {
            s_factories.add(dBObjectProviderFactory);
        }
    }

    public static DBObjectProvider findProvider(Object object) {
        if (object != null && s_providers != null) {
            return s_providers.get(object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBObjectProvider findOrCreateProvider(Object object) throws DBException {
        if (object != null) {
            if (s_providers != null && s_providers.containsKey(object)) {
                return s_providers.get(object);
            }
            Object object2 = object;
            synchronized (object2) {
                for (DBObjectProviderFactory dBObjectProviderFactory : DBObjectProviderFactory.factories()) {
                    DBObjectProvider dBObjectProvider = DBObjectProviderFactory.createProviderFromFactory(dBObjectProviderFactory, object);
                    if (dBObjectProvider == null) continue;
                    DBObjectProvider dBObjectProvider2 = dBObjectProvider;
                    return dBObjectProvider2;
                }
            }
        }
        return null;
    }

    protected static final Collection<DBObjectProviderFactory> factories() {
        ArrayList<DBObjectProviderFactory> arrayList = new ArrayList<DBObjectProviderFactory>();
        if (s_factories != null) {
            arrayList.addAll(s_factories);
        }
        arrayList.addAll(Arrays.asList(s_defaultFactories));
        return arrayList;
    }

    protected static final Collection<DBObjectProvider> providers() {
        return new ArrayList<DBObjectProvider>(s_providers.values());
    }

    private static final DBObjectProvider createProviderFromFactory(DBObjectProviderFactory dBObjectProviderFactory, Object object) throws DBException {
        try {
            DBObjectProvider dBObjectProvider = dBObjectProviderFactory.createProviderImpl(object);
            if (dBObjectProvider != null) {
                if (dBObjectProviderFactory.canCache(object)) {
                    if (s_providers == null) {
                        s_providers = new HashMap<Object, DBObjectProvider>();
                    }
                    s_providers.put(object, dBObjectProvider);
                }
                DBObjectProvider dBObjectProvider2 = dBObjectProvider;
                return dBObjectProvider2;
            }
        }
        catch (Exception exception) {
            if (exception instanceof DBException) {
                throw (DBException)exception;
            }
            DBUtil.logStackTrace(exception);
            throw new DBException(exception);
        }
        return null;
    }

    public static final DBObjectProvider uncacheProvider(Object object) {
        if (object != null && s_providers != null && s_providers.containsKey(object)) {
            return s_providers.remove(object);
        }
        return null;
    }
}

