/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil
implements Comparator {
    private static final String LOG_NAME = "db_api";
    private static final String SQL_LOG_NAME = "db_sql";
    private static final Log SQL_LOG = new Log("db_api", "db_sql");
    private static final Log LOG = new Log("db_api");
    private static Comparator typeComparator;
    private static Comparator nameComparator;
    private boolean compareByType;

    protected DBUtil() {
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof DBObject && object2 instanceof DBObject) {
            return this.compareImpl((DBObject)object, (DBObject)object2);
        }
        return object.toString().compareTo(object2.toString());
    }

    private int compareImpl(DBObject dBObject, DBObject dBObject2) {
        String string;
        int n;
        if (this.compareByType && (n = this.compareType(dBObject, dBObject2)) != 0) {
            return n;
        }
        String string2 = dBObject.getName();
        int n2 = string2.compareTo(string = dBObject2.getName());
        if (n2 == 0 && !this.compareByType) {
            return this.compareType(dBObject, dBObject2);
        }
        return n2;
    }

    private int compareType(DBObject dBObject, DBObject dBObject2) {
        String string = dBObject.getType();
        String string2 = dBObject2.getType();
        return string.compareTo(string2);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DBUtil && ((DBUtil)object).compareByType == this.compareByType;
    }

    public static final Log getLog() {
        return LOG;
    }

    public static final void logStackTrace(Throwable throwable) {
        if (LOG.isEnabled()) {
            LOG.trace(throwable.getMessage());
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = 0;
            while (n < stackTraceElementArray.length) {
                LOG.trace(stackTraceElementArray[n].toString());
                ++n;
            }
        }
    }

    public static final void logStackTrace() {
        DBUtil.logStackTrace(new Exception(LOG_NAME));
    }

    public static final Log getSQLLog() {
        return SQL_LOG;
    }

    public static Comparator getTypeComparator() {
        if (typeComparator == null) {
            typeComparator = new DBUtil();
            ((DBUtil)DBUtil.typeComparator).compareByType = true;
        }
        return typeComparator;
    }

    public static Comparator getNameComparator() {
        if (nameComparator == null) {
            nameComparator = new DBUtil();
            ((DBUtil)DBUtil.nameComparator).compareByType = false;
        }
        return nameComparator;
    }

    public static Map<DBObjectID, DBObjectID> getTemporaryIDMap(DBObject[] dBObjectArray) {
        HashMap<DBObjectID, DBObjectID> hashMap = new HashMap<DBObjectID, DBObjectID>();
        DBObject[] dBObjectArray2 = dBObjectArray;
        int n = 0;
        while (n < dBObjectArray2.length) {
            DBObject dBObject = dBObjectArray2[n];
            DBObjectID dBObjectID = dBObject.getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                try {
                    DBObject dBObject2 = ((TemporaryObjectID)dBObjectID).resolveOriginalID();
                    hashMap.put(dBObject2.getID(), dBObjectID);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return hashMap;
    }

    public static DBObject makeTemporaryCopy(DBObject dBObject) {
        DBObject dBObject2 = dBObject.copyTo(null, true);
        return dBObject2;
    }

    public static boolean replaceReferenceIDs(DBObject dBObject, Map<DBObjectID, DBObjectID> map) {
        boolean bl = dBObject.replaceReferenceIDs(map);
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            bl = DBUtil.replaceReferenceIDs(dBObjectArray[n], map) || bl;
            ++n;
        }
        return bl;
    }

    public static void updateObjectAndIDs(DBObject dBObject, DBObject dBObject2) {
        dBObject2.copyTo(dBObject);
        dBObject.setID(dBObject2.getID());
        DBUtil.updateChildIDs(dBObject, dBObject2);
    }

    private static void updateChildIDs(DBObject dBObject, DBObject dBObject2) {
        DBObject[] dBObjectArray = dBObject2.getOwnedObjects();
        int n = 0;
        while (dBObjectArray != null && n < dBObjectArray.length) {
            DBObject dBObject3 = DBUtil.findMatchingChild(dBObject, dBObjectArray[n]);
            if (dBObject3 != null) {
                dBObject3.setID(dBObjectArray[n].getID());
                DBUtil.updateChildIDs(dBObject3, dBObjectArray[n]);
            }
            ++n;
        }
    }

    private static DBObject findMatchingChild(DBObject dBObject, DBObject dBObject2) {
        String string = dBObject2.getName();
        if (string == null) {
            DBObject[] dBObjectArray = dBObject.getOwnedObjects(dBObject2.getType());
            if (dBObjectArray != null && dBObjectArray.length == 1) {
                return dBObjectArray[0];
            }
        } else {
            return dBObject.findOwnedObject(dBObject2.getType(), dBObject2.getName());
        }
        return null;
    }

    public static DBObject findChildInCopy(DBObject dBObject, DBObject dBObject2, DBObject dBObject3) {
        if (dBObject == null || dBObject2 == null || dBObject3 == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (dBObject == dBObject3) {
            return dBObject2;
        }
        DBObject[] dBObjectArray = dBObject2.getOwnedObjects();
        int n = 0;
        while (dBObjectArray != null && n < dBObjectArray.length) {
            DBObjectID dBObjectID = dBObjectArray[n].getID();
            if (dBObjectID instanceof TemporaryObjectID) {
                DBObject dBObject4;
                DBObject dBObject5 = null;
                try {
                    dBObject5 = ((TemporaryObjectID)dBObjectID).resolveOriginalID();
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (dBObject5 == dBObject3) {
                    return dBObjectArray[n];
                }
                if (dBObject5 != null && (dBObject4 = DBUtil.findChildInCopy(dBObject5, dBObjectArray[n], dBObject3)) != null) {
                    return dBObject4;
                }
            }
            ++n;
        }
        return null;
    }

    public static String getUniqueName(Collection collection, String string) {
        return DBUtil.getUniqueName(collection, string, true);
    }

    public static String getUniqueName(Collection collection, String string, boolean bl) {
        String string2 = null;
        if (collection == null || !collection.contains(string)) {
            string2 = string;
        } else {
            int n = 1;
            int n2 = string.length() - 1;
            if (bl) {
                while (Character.isDigit(string.charAt(n2))) {
                    if (n2 > 0) {
                        --n2;
                        continue;
                    }
                    n2 = string.length() - 1;
                    break;
                }
                try {
                    n = Integer.parseInt(string.substring(n2 + 1));
                    string = string.substring(0, n2 + 1);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (Character.isDigit(string.charAt(n2))) {
                string = string + "_";
            }
            int n3 = n;
            while (string2 == null) {
                String string3 = string + n3;
                if (!collection.contains(string3)) {
                    string2 = string3;
                }
                ++n3;
            }
        }
        return string2;
    }

    public static String getFullyQualifiedName(DBObject dBObject) {
        return DBUtil.getFullyQualifiedName(dBObject, false);
    }

    public static String getFullyQualifiedName(DBObject dBObject, boolean bl) {
        Schema schema;
        DBObject dBObject2 = dBObject.getParent();
        String string = null;
        string = dBObject2 == null ? (dBObject instanceof SchemaObject && bl ? ((schema = ((SchemaObject)dBObject).getSchema()) == null ? "" : schema.getName() + ".") : "") : DBUtil.getFullyQualifiedName(dBObject2, bl) + ".";
        string = string + dBObject.getName();
        return string;
    }

    public static Schema getSchema(DBObject dBObject) {
        if (dBObject instanceof Schema) {
            return (Schema)dBObject;
        }
        if (dBObject instanceof SchemaObject) {
            return ((SchemaObject)dBObject).getSchema();
        }
        DBObject dBObject2 = dBObject.getParent();
        return dBObject2 == null ? null : DBUtil.getSchema(dBObject2);
    }

    public static SchemaObject getSchemaObject(DBObject dBObject) {
        DBObject dBObject2 = dBObject.getParent();
        if (dBObject2 != null) {
            return DBUtil.getSchemaObject(dBObject2);
        }
        if (dBObject instanceof SchemaObject) {
            return (SchemaObject)dBObject;
        }
        return null;
    }

    public static SchemaObject getProviderDefinition(SchemaObject schemaObject, DBObjectProvider dBObjectProvider) throws DBException {
        return dBObjectProvider.getObject(schemaObject.getType(), schemaObject.getSchema(), schemaObject.getName());
    }

    public static SchemaObject[] getProviderDefinitions(SchemaObject[] schemaObjectArray, DBObjectProvider dBObjectProvider) throws DBException {
        SchemaObject[] schemaObjectArray2 = new SchemaObject[schemaObjectArray.length];
        int n = 0;
        while (n < schemaObjectArray.length) {
            if (schemaObjectArray[n] != null) {
                schemaObjectArray2[n] = DBUtil.getProviderDefinition(schemaObjectArray[n], dBObjectProvider);
            }
            ++n;
        }
        return schemaObjectArray2;
    }

    public static String quoteName(String string, String string2) {
        if (ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2)) {
            int n = string.indexOf(string2);
            while (n > -1 && n < string.length()) {
                string = string.substring(0, n) + string2 + string.substring(n);
                n = string.indexOf(string2, n + string2.length() + 1);
            }
            string = string2 + string + string2;
        }
        return string;
    }

    public static boolean isDangling(DBObjectID dBObjectID) {
        boolean bl = false;
        if (dBObjectID instanceof DBReferenceID) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                bl = dBObject == null;
            }
            catch (DBException dBException) {
                bl = true;
            }
        }
        return bl;
    }
}

