/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AttributeChangeEvent;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.Properties;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.BeanDiffer;
import oracle.javatools.db.diff.ColumnConstraintDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DataTypeUsageDiffer;
import oracle.javatools.db.diff.DeclarativeSQLQueryDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.FKConstraintDiffer;
import oracle.javatools.db.diff.IndexDiffer;
import oracle.javatools.db.diff.IndexObjectDiffer;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.OrderedListDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.diff.SQLFragmentComparator;
import oracle.javatools.db.diff.SQLFragmentDiffer;
import oracle.javatools.db.diff.SourceObjectDiffer;
import oracle.javatools.db.diff.SpecPlSqlDiffer;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyIterator;

public class DDLDiff
extends DiffContext {
    public static final int BASIC_RECONCILE_DO_IT = 12;
    public static final String REFERENCEDCOLUMN = "ReferencedColumn";
    public static final String REFERENCED_SCHEMA = "ReferencedSchema";
    public static final String REFERENCED_RELATION = "ReferencedRelation";
    public static final String REFERENCED_CONSTRAINT = "ReferencedConstraintName";
    public static final String COLUMNS = "columns";
    private static HashMap nameMap;
    private int m_reconcile_type;
    private Index m_curIndex;
    private ArrayList m_events;
    private EventLists m_curEvents;
    private boolean m_diagnosticPrint;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = DDLDiff.class.desiredAssertionStatus() ^ true;
        nameMap = new HashMap();
        nameMap.put(REFERENCED_CONSTRAINT, "referenceID");
    }

    void $init$() {
        this.m_reconcile_type = 0;
        this.m_events = new ArrayList();
        this.m_diagnosticPrint = false;
    }

    public DDLDiff(SchemaObject schemaObject, SchemaObject schemaObject2, int n) {
        this.$init$();
        this.m_reconcile_type = n;
        DiffEngine diffEngine = new DiffEngine();
        diffEngine.registerDiffer(new BeanDiffer(), Object.class);
        diffEngine.registerDiffer(new IndexDiffer(), Index.class);
        diffEngine.registerDiffer(new IndexObjectDiffer(), IndexObject.class);
        diffEngine.registerDiffer(new DBObjectDiffer(), DBObject.class);
        diffEngine.registerDiffer(new DataTypeUsageDiffer(), DataTypeUsage.class);
        diffEngine.registerDiffer(new ColumnConstraintDiffer(), ColumnConstraint.class);
        diffEngine.registerDiffer(new FKConstraintDiffer(), FKConstraint.class);
        diffEngine.registerDiffer(new DeclarativeSQLQueryDiffer(), DeclarativeSQLQuery.class);
        diffEngine.registerDiffer(new SQLFragmentDiffer(), SQLFragment.class);
        diffEngine.registerDiffer(new SourceObjectDiffer(), SourceObject.class);
        diffEngine.registerDiffer(new SpecPlSqlDiffer(), SpecPlSql.class);
        diffEngine.registerListDiffer(new ListDiffer(), Object.class);
        diffEngine.registerListDiffer(new OrderedListDiffer(), Column.class);
        diffEngine.registerListDiffer(new OrderedListDiffer(), IndexObject.class);
        diffEngine.registerComparator(new SQLFragmentComparator(), SQLFragment.class);
        diffEngine.registerComparator(new DBObjectComparator(), DBObject.class);
        this.setEngine(diffEngine);
        ResultSet resultSet = new ResultSet(null, null, null, -1, -1, "SchemaObjects", "LIST");
        ResultSet resultSet2 = new ResultSet(resultSet, schemaObject, schemaObject2, null, "MAP");
        this.setResult(resultSet);
        diffEngine.diff(schemaObject, schemaObject2, resultSet2, (DiffContext)this);
        if (12 == n) {
            if (this.m_diagnosticPrint) {
                this.getResult().print();
            }
            if (!$assertionsDisabled && !"LIST".equals(this.getResult().getType())) {
                throw new AssertionError();
            }
            for (ResultSet resultSet3 : this.getResult().getAllObjectsList()) {
                this.update(resultSet3);
            }
        }
    }

    public final void fireObjectUpdated() {
        int n = 0;
        while (n < this.m_events.size()) {
            EventLists eventLists = (EventLists)this.m_events.get(n);
            if (eventLists.getCurB() != null) {
                DBObjectChange.fireObjectUpdated(eventLists.getCurB(), eventLists.getAddedList(), eventLists.getRemovedList(), eventLists.getChangedMap());
            }
            ++n;
        }
    }

    private String mapName(String string) {
        String string2 = string;
        if (nameMap.containsKey(string)) {
            string2 = (String)nameMap.get(string);
        }
        return string2;
    }

    private void update(ResultSet resultSet) {
        if (!resultSet.isSame()) {
            if ("MAP" == resultSet.getType()) {
                boolean bl;
                EventLists eventLists = null;
                DBObject dBObject = (DBObject)resultSet.a();
                DBObject dBObject2 = (DBObject)resultSet.b();
                boolean bl2 = bl = dBObject instanceof Index || dBObject2 instanceof Index;
                if (bl) {
                    this.m_curIndex = (Index)dBObject2;
                }
                SchemaObject schemaObject = null;
                SchemaObject schemaObject2 = null;
                if (dBObject != null && dBObject instanceof SchemaObject) {
                    schemaObject = (SchemaObject)dBObject;
                }
                if (dBObject2 != null && dBObject2 instanceof SchemaObject) {
                    schemaObject2 = (SchemaObject)dBObject2;
                }
                if (schemaObject != null || schemaObject2 != null) {
                    eventLists = this.m_curEvents;
                    this.m_curEvents = new EventLists(schemaObject, schemaObject2);
                    this.m_events.add(this.m_curEvents);
                }
                Map map = resultSet.getBonlyMap();
                Map map2 = resultSet.getAonlyMap();
                Map map3 = resultSet.getModifiedObjectMap();
                Properties properties = dBObject != null ? new Properties(dBObject) : null;
                Properties properties2 = dBObject2 != null ? new Properties(dBObject2) : null;
                ArrayList arrayList = new ArrayList();
                if (dBObject instanceof Table) {
                    ResultSet resultSet2 = (ResultSet)resultSet.getAllObjectsMap().get(COLUMNS);
                    this.updateList(resultSet, resultSet2);
                }
                Iterator iterator = map3.keySet().iterator();
                while (iterator.hasNext()) {
                    ResultSet resultSet3 = (ResultSet)map3.get(iterator.next());
                    String string = resultSet3.getName();
                    if (dBObject instanceof Table && COLUMNS.equals(string)) continue;
                    if ((this.m_curEvents.getCurA() instanceof Table || this.m_curEvents.getCurA() instanceof View || this.m_curEvents.getCurA() instanceof Index) && "LIST" == resultSet3.getType()) {
                        if (!resultSet3.isSame() && dBObject instanceof ColumnConstraint && COLUMNS.equals(string)) {
                            this.updateColumnConstraint((ColumnConstraint)dBObject, (ColumnConstraint)dBObject2);
                            continue;
                        }
                        if (REFERENCEDCOLUMN.equals(string)) continue;
                        this.updateList(resultSet, resultSet3);
                        continue;
                    }
                    this.updateProperty(string, dBObject, dBObject2, properties, properties2, arrayList, resultSet3);
                }
                this.setPropertiesNow(dBObject2, properties2, arrayList);
                if (eventLists != null) {
                    this.m_curEvents = eventLists;
                }
                if (bl) {
                    this.m_curIndex = null;
                }
            } else if ("LIST" == resultSet.getType()) {
                Class<?> clazz = null;
                List list = resultSet.getAllObjectsList();
                ResultSet resultSet4 = (ResultSet)list.get(0);
                clazz = resultSet4.a() != null ? resultSet4.a().getClass() : resultSet4.b().getClass();
                List list2 = resultSet.getAonlyList();
                List list3 = resultSet.getBonlyList();
                List list4 = resultSet.getModifiedObjectList();
                int n = 0;
                while (n < list3.size()) {
                    ResultSet resultSet5 = (ResultSet)list3.get(n);
                    DBObject dBObject = (DBObject)resultSet5.b();
                    if (this.m_curEvents.getCurB() instanceof Relation) {
                        this.dropColOrConOrIndex((Relation)this.m_curEvents.getCurB(), dBObject);
                    } else if (this.m_curEvents.getCurB() instanceof Index) {
                        this.dropColExpr((Index)this.m_curEvents.getCurB(), dBObject);
                    } else {
                        throw new IllegalStateException("Unrecognised object type");
                    }
                    ++n;
                }
                int n2 = 0;
                while (n2 < list2.size()) {
                    ResultSet resultSet6 = (ResultSet)list2.get(n2);
                    int n3 = resultSet6.getIndexOfA();
                    DBObject dBObject = (DBObject)resultSet6.a();
                    if (this.m_curEvents.getCurB() instanceof Relation) {
                        this.addColOrConOrIndex((Relation)this.m_curEvents.getCurB(), dBObject, n3);
                    } else if (this.m_curEvents.getCurB() instanceof Index) {
                        this.addIndexObject((Index)this.m_curEvents.getCurB(), dBObject, n3);
                    } else {
                        throw new IllegalStateException("Unrecognised object type");
                    }
                    ++n2;
                }
                for (ResultSet resultSet7 : list4) {
                    this.update(resultSet7);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    private void updateProperty(String string, DBObject dBObject, DBObject dBObject2, Properties properties, Properties properties2, ArrayList arrayList, ResultSet resultSet) {
        Object object;
        String string2 = this.mapName(string);
        Object object2 = dBObject != null ? properties.get(string2) : null;
        Object object3 = object = dBObject2 != null ? properties2.get(string2) : null;
        if (dBObject != null || dBObject2 != null) {
            arrayList.add(new PropertyChangeEvent(dBObject, string2, object, object2));
        }
    }

    private void updateList(ResultSet resultSet, ResultSet resultSet2) {
        if (resultSet2.isChildListReorder()) {
            this.copyList((DBObject)resultSet.a(), (DBObject)resultSet.b(), resultSet2);
        } else {
            this.update(resultSet2);
        }
    }

    private void updateColumnConstraint(ColumnConstraint columnConstraint, ColumnConstraint columnConstraint2) {
        if (!columnConstraint.equals(columnConstraint2)) {
            Relation relation = columnConstraint2.getRelation();
            Column[] columnArray = columnConstraint.getColumns();
            Column[] columnArray2 = new Column[columnArray.length];
            int n = 0;
            while (n < columnArray.length) {
                Column column = columnArray[n];
                columnArray2[n] = relation.getColumn(column.getName());
                ++n;
            }
            columnConstraint2.setColumns(columnArray2);
            ArrayList<AttributeChangeEvent> arrayList = new ArrayList<AttributeChangeEvent>();
            arrayList.add(new AttributeChangeEvent(columnConstraint2, 1));
        }
    }

    private void fireChildListReordered(DBObject dBObject) {
        ArrayList<AttributeChangeEvent> arrayList = new ArrayList<AttributeChangeEvent>();
        if (dBObject instanceof Relation) {
            arrayList.add(new AttributeChangeEvent(this.m_curEvents.getCurB(), 2));
        } else if (dBObject instanceof ColumnConstraint) {
            arrayList.add(new AttributeChangeEvent(this.m_curEvents.getCurB(), 1));
        }
    }

    private void copyList(DBObject dBObject, DBObject dBObject2, ResultSet resultSet) {
        String string = resultSet.getName();
        PropertyInfo propertyInfo = this.getPropertyInfo(dBObject, string);
        PropertyInfo propertyInfo2 = this.getPropertyInfo(dBObject2, string);
        try {
            DBObject[] dBObjectArray = (DBObject[])propertyInfo.getPropertyValue((Object)dBObject);
            Class<?> clazz = dBObjectArray[0].getClass();
            DBObject[] dBObjectArray2 = (DBObject[])Array.newInstance(clazz, dBObjectArray.length);
            int n = 0;
            while (n < dBObjectArray.length) {
                dBObjectArray2[n] = (DBObject)clazz.newInstance();
                dBObjectArray[n].copyTo(dBObjectArray2[n]);
                dBObjectArray2[n].setID(dBObjectArray[n].getID());
                ++n;
            }
            propertyInfo2.setPropertyValue((Object)dBObject2, (Object)dBObjectArray2);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (ResultSet resultSet2 : resultSet.getBonlyList()) {
                if (this.m_curEvents.getCurB() instanceof Table && dBObject2 instanceof Index) {
                    this.dropColExpr((Index)dBObject2, (DBObject)resultSet2.b());
                    continue;
                }
                arrayList.add(resultSet2.b());
            }
            if (arrayList.size() > 0) {
                this.m_curEvents.getRemovedList().addAll(arrayList);
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (ResultSet resultSet3 : resultSet.getAonlyList()) {
                if (this.m_curEvents.getCurB() instanceof Table && dBObject2 instanceof Index) {
                    int n2 = resultSet3.getIndexOfA();
                    this.addIndexObject((Index)dBObject2, (DBObject)resultSet3.a(), n2);
                    continue;
                }
                arrayList2.add(resultSet3.a());
            }
            if (arrayList2.size() > 0) {
                this.m_curEvents.getAddedList().addAll(arrayList2);
            }
            this.fireChildListReordered(this.getSchemaObject(dBObject2));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Cant copy DBObject " + dBObject.getClass().getName() + " list " + string + " from " + dBObject.getName() + " to " + dBObject2.getName());
        }
    }

    private PropertyInfo getPropertyInfo(Object object, String string) {
        PropertyInfo propertyInfo = null;
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            propertyInfo = propertyIterator.next();
            if (string.equals(propertyInfo.getXMLName())) break;
        }
        if (!$assertionsDisabled && propertyInfo == null) {
            throw new AssertionError((Object)("Cant find property " + string + " in Class " + object.getClass().getName()));
        }
        return propertyInfo;
    }

    private void addIndexObject(Index index, DBObject dBObject, int n) {
        if (!$assertionsDisabled && !(dBObject instanceof IndexObject)) {
            throw new AssertionError();
        }
        IndexObject indexObject = (IndexObject)dBObject.copyTo(null);
        indexObject.setID(dBObject.getID());
        if (n >= 0) {
            index.addColumnExpression(n, indexObject);
        } else {
            index.addColumnExpression(indexObject);
        }
        String string = indexObject.getSQLText();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(index, "columnExpressions", null, string);
        this.getRelationEvent(index.getTable()).getChangedMap().put("indexes", propertyChangeEvent);
        if (this.m_curEvents.getCurB() instanceof Index) {
            this.m_curEvents.getAddedList().add(indexObject);
        }
    }

    private void addColOrConOrIndex(Relation relation, DBObject dBObject, int n) {
        DBObject dBObject2 = null;
        if (dBObject instanceof IndexObject) {
            this.addIndexObject(this.m_curIndex, dBObject, n);
        } else {
            if ("COLUMN".equals(dBObject.getType())) {
                dBObject2 = (DBObject)dBObject.copyTo(null);
                dBObject2.setID(dBObject.getID());
                if (n >= 0) {
                    relation.addColumn(n, (Column)dBObject2);
                } else {
                    relation.addColumn((Column)dBObject2);
                }
                ((Column)dBObject2).setRelation(relation);
            } else if ("CONSTRAINT".equals(dBObject.getType())) {
                dBObject2 = ((Constraint)dBObject).copyTo(null, relation, false);
                dBObject2.setID(dBObject.getID());
                relation.addConstraint((Constraint)dBObject2);
                ((Constraint)dBObject2).setRelation(relation);
            } else if ("INDEX".equals(dBObject.getType())) {
                dBObject2 = (DBObject)dBObject.copyTo(null);
                dBObject2.setID(dBObject.getID());
                ((Table)relation).addIndex((Index)dBObject2);
                ((Index)dBObject2).setTable((Table)relation);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("unrecognised object type " + dBObject.getType() + " (" + dBObject.getName() + ")"));
            }
            this.m_curEvents.getAddedList().add(dBObject2);
        }
    }

    SchemaObject getSchemaObject(DBObject dBObject) {
        SchemaObject schemaObject = null;
        if (dBObject instanceof SchemaObject) {
            schemaObject = (SchemaObject)dBObject;
        } else if (dBObject instanceof Column) {
            schemaObject = ((Column)dBObject).getRelation();
        } else if (dBObject instanceof Constraint) {
            schemaObject = ((Constraint)dBObject).getRelation();
        } else if (dBObject instanceof Index) {
            schemaObject = ((Index)dBObject).getTable();
        }
        return schemaObject;
    }

    private void setPropertiesNow(DBObject dBObject, Properties properties, List list) {
        if (list.size() > 0) {
            for (PropertyChangeEvent propertyChangeEvent : list) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                properties.set(string, object);
                this.m_curEvents.getChangedMap().put(string, propertyChangeEvent);
            }
        }
    }

    private EventLists getRelationEvent(Relation relation) {
        EventLists eventLists = null;
        int n = this.m_events.size() - 1;
        while (n >= 0) {
            EventLists eventLists2 = (EventLists)this.m_events.get(n);
            if (eventLists2.getCurA() instanceof Relation || eventLists2.getCurB() instanceof Relation) {
                eventLists = eventLists2;
                break;
            }
            --n;
        }
        if (eventLists == null) {
            eventLists = new EventLists(null, relation);
            this.m_events.add(eventLists);
        }
        return eventLists;
    }

    private void dropColExpr(Index index, DBObject dBObject) {
        if (!$assertionsDisabled && !(dBObject instanceof IndexObject)) {
            throw new AssertionError();
        }
        index.removeColumnExpression((IndexObject)dBObject);
        String string = ((IndexObject)dBObject).getSQLText();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(index, "columnExpressions", string, null);
        this.getRelationEvent(index.getTable()).getChangedMap().put("indexes", propertyChangeEvent);
        if (this.m_curEvents.getCurB() instanceof Index) {
            this.m_curEvents.getRemovedList().add(dBObject);
        }
    }

    private void dropColOrConOrIndex(Relation relation, DBObject dBObject) {
        if (dBObject instanceof IndexObject) {
            this.dropColExpr(this.m_curIndex, dBObject);
        } else {
            if ("COLUMN".equals(dBObject.getType())) {
                relation.removeColumn((Column)dBObject);
            } else if ("CONSTRAINT".equals(dBObject.getType())) {
                relation.removeConstraint((Constraint)dBObject);
            } else if ("INDEX".equals(dBObject.getType())) {
                ((Table)relation).removeIndex((Index)dBObject);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"unrecognised object type");
            }
            this.m_curEvents.getRemovedList().add(dBObject);
        }
    }

    private class EventLists {
        private SchemaObject m_curA;
        private SchemaObject m_curB;
        private List m_addedList;
        private List m_removedList;
        private Map m_propsChanged;

        void $init$() {
            this.m_addedList = new ArrayList();
            this.m_removedList = new ArrayList();
            this.m_propsChanged = new HashMap();
        }

        public EventLists(SchemaObject schemaObject, SchemaObject schemaObject2) {
            this.$init$();
            this.m_curA = schemaObject;
            this.m_curB = schemaObject2;
        }

        public SchemaObject getCurA() {
            return this.m_curA;
        }

        public SchemaObject getCurB() {
            return this.m_curB;
        }

        public List getAddedList() {
            return this.m_addedList;
        }

        public List getRemovedList() {
            return this.m_removedList;
        }

        public Map getChangedMap() {
            return this.m_propsChanged;
        }
    }
}

