/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.util.ModelUtil;

public abstract class DatabaseFactory
extends DBObjectProviderFactory {
    protected final DBObjectProvider createProviderImpl(Object object) throws DBException {
        if (object instanceof Descriptor) {
            String string = ((Descriptor)object).getName();
            Connection connection = ((Descriptor)object).getConnection();
            return this.createDatabaseImpl(string, connection);
        }
        return null;
    }

    protected final boolean canCache(Object object) {
        return object instanceof Descriptor && ((Descriptor)object).canCache();
    }

    protected abstract Database createDatabaseImpl(String var1, Connection var2) throws DBException;

    protected abstract DatabaseDescriptor getDatabaseDescriptorImpl(Class var1);

    protected Connection createNewConnectionImpl(Database database) throws DBException {
        return null;
    }

    public static final Database findOrCreateDatabase(String string, Connection connection) throws DBException {
        return (Database)DatabaseFactory.findOrCreateProvider(new Descriptor(string, connection));
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Class clazz) {
        for (DBObjectProviderFactory dBObjectProviderFactory : DatabaseFactory.factories()) {
            DatabaseDescriptor databaseDescriptor;
            if (!(dBObjectProviderFactory instanceof DatabaseFactory) || (databaseDescriptor = ((DatabaseFactory)dBObjectProviderFactory).getDatabaseDescriptorImpl(clazz)) == null) continue;
            return databaseDescriptor;
        }
        return null;
    }

    public static final Connection createConnection(Database database) throws DBException {
        for (DBObjectProviderFactory dBObjectProviderFactory : DatabaseFactory.factories()) {
            if (!(dBObjectProviderFactory instanceof DatabaseFactory)) continue;
            long l = System.currentTimeMillis();
            Connection connection = ((DatabaseFactory)dBObjectProviderFactory).createNewConnectionImpl(database);
            if (connection == null) continue;
            DBUtil.getLog().trace("Duplicating connection for {0} took {1}ms", (Object)database.getConnectionName(), (Object)Long.toString(System.currentTimeMillis() - l));
            return connection;
        }
        return database.getConnection();
    }

    protected static class Descriptor {
        private String m_name;
        private Connection m_conn;

        public Descriptor(String string, Connection connection) {
            this.m_name = string;
            this.m_conn = connection;
        }

        public String getName() {
            return this.m_name;
        }

        public Connection getConnection() {
            return this.m_conn;
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = object == this;
            if (!bl && object instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)object;
                if (this.m_name != null && this.m_name.equals(descriptor.m_name)) {
                    bl = this.m_conn == descriptor.m_conn;
                }
            }
            return bl;
        }

        boolean canCache() {
            return ModelUtil.hasLength((String)this.m_name);
        }

        public int hashCode() {
            return this.m_name != null ? this.m_name.hashCode() : 0;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

