/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FKConstraint
extends ColumnConstraint {
    public static final int ON_DELETE_RESTRICT = 0;
    public static final int ON_DELETE_CASCADE = 1;
    public static final int ON_DELETE_SET_NULL = 2;
    public static final int ON_DELETE_NONE = 0;
    private int _onDelete;
    private DBObjectID _refID;
    private boolean _ignorRefSchema;
    public static final String CONSTRAINT_TYPE = "FKConstraint";

    @Override
    void $init$() {
        this._ignorRefSchema = false;
    }

    public FKConstraint() {
        this.$init$();
    }

    public FKConstraint(String string, Relation relation) {
        super(string, relation);
        this.$init$();
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        FKConstraint fKConstraint = dBObject != null ? (FKConstraint)dBObject : new FKConstraint();
        this.copyToImpl(fKConstraint, (Relation)dBObject2, bl);
        return fKConstraint;
    }

    public boolean equals(Object object) {
        return object instanceof FKConstraint && this.equalsImpl((FKConstraint)object);
    }

    protected void copyToImpl(FKConstraint fKConstraint, Relation relation, boolean bl) {
        super.copyToImpl(fKConstraint, relation, bl);
        fKConstraint._onDelete = this._onDelete;
        fKConstraint._refID = this._refID;
        if (relation != null) {
            Constraint[] constraintArray = relation.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                DBObjectID dBObjectID;
                Constraint constraint = constraintArray[n];
                if (constraint instanceof PKConstraint && (dBObjectID = constraint.getID()) != null && dBObjectID.equals(this._refID, false)) {
                    fKConstraint._refID = dBObjectID;
                    break;
                }
                ++n;
            }
        }
    }

    protected boolean equalsImpl(FKConstraint fKConstraint) {
        return super.equalsImpl(fKConstraint) && this._onDelete == fKConstraint._onDelete && ModelUtil.areEqual((Object)this._refID, (Object)fKConstraint._refID);
    }

    public void setIgnorReferencedSchema(boolean bl) {
        this._ignorRefSchema = bl;
    }

    public boolean isReferencedSchemaIgnored() {
        return this._ignorRefSchema;
    }

    public void setReferenceID(DBObjectID dBObjectID) {
        this._refID = dBObjectID;
    }

    public DBObjectID getReferenceID() {
        return this._refID;
    }

    @Override
    public String getConstraintType() {
        return CONSTRAINT_TYPE;
    }

    public int getDeleteMode() {
        return this._onDelete;
    }

    public void setDeleteMode(int n) {
        this._onDelete = n;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        if (this._refID != null) {
            collection.add(this._refID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        if (this._refID != null && map.containsKey(this._refID)) {
            this._refID = map.get(this._refID);
            return true;
        }
        return super.replaceReferenceIDs(map);
    }
}

