/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends AbstractSchemaObject {
    private int _indexType;
    private boolean _unique;
    private boolean _bitmap;
    private transient Table _table;
    private List<Column> _cols;
    private List<IndexObject> m_columnExpressions;
    public static final int INDEX_TYPE_NORMAL = 1;
    public static final int INDEX_TYPE_UNIQUE = 2;
    public static final int INDEX_TYPE_BITMAP = 3;
    public static final int INDEX_TYPE_DOMAIN = 4;
    public static final String TYPE = "INDEX";

    void $init$() {
        this._cols = new ArrayList<Column>();
        this.m_columnExpressions = new ArrayList<IndexObject>();
    }

    public Index() {
        this.$init$();
    }

    public Index(String string, Table table) {
        super(string, table == null ? null : table.getSchema());
        this.$init$();
        this._table = table;
        if (this._table != null) {
            this._table.addIndex(this);
        }
    }

    public Index(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    public Index(String string, Schema schema, Table table) {
        super(string, schema);
        this.$init$();
        this._table = table;
        if (this._table != null) {
            this._table.addIndex(this);
        }
        this.setSchema(schema);
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        Index index = dBObject != null ? (Index)dBObject : new Index();
        this.copyToImpl(index, bl);
        return index;
    }

    protected void copyToImpl(Index index, boolean bl) {
        super.copyToImpl(index, bl);
        index._indexType = this._indexType;
        index._table = this._table;
        index._cols = new ArrayList<Column>(this._cols);
        index.m_columnExpressions.clear();
        for (IndexObject indexObject : this.m_columnExpressions) {
            index.m_columnExpressions.add((IndexObject)indexObject.copyTo(null, index, bl));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Index && this.equalsImpl((Index)object);
    }

    protected boolean equalsImpl(Index index) {
        return super.equalsImpl(index) && this._indexType == index._indexType && ModelUtil.areEqual(this._cols, index._cols) && ModelUtil.areEqual(this.m_columnExpressions, index.m_columnExpressions);
    }

    public int getIndexType() {
        this.checkInit();
        return this._indexType;
    }

    public void setIndexType(int n) {
        this.checkInit();
        this._indexType = n;
    }

    public void setTable(Table table) {
        this._table = table;
    }

    public Table getTable() throws TransientMarker {
        this.checkInit();
        return this._table;
    }

    @Override
    public DBObject getParent() {
        return this.getTable();
    }

    public void setColumns(Column[] columnArray) {
        this.checkInit();
        if (ModelUtil.areDifferent((Object)columnArray, (Object)this.getColumns())) {
            this._cols = Arrays.asList(columnArray);
        }
    }

    public Column[] getColumns() {
        this.checkInit();
        return this._cols.toArray(new Column[this._cols.size()]);
    }

    public void addColumn(Column column) {
        this.checkInit();
        if (!this._cols.contains(column)) {
            this._cols.add(column);
        }
    }

    public void removeColumn(Column column) {
        this.checkInit();
        if (this._cols.contains(column)) {
            this._cols.remove(column);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setColumnExpressions(IndexObject[] indexObjectArray) {
        this.checkInit();
        if (ModelUtil.areDifferent((Object)indexObjectArray, (Object)this.getColumnExpressions())) {
            this.m_columnExpressions = new ArrayList<IndexObject>(Arrays.asList(indexObjectArray));
        }
    }

    public IndexObject[] getColumnExpressions() {
        this.checkInit();
        return this.m_columnExpressions.toArray(new IndexObject[this.m_columnExpressions.size()]);
    }

    public void addColumnExpression(IndexObject indexObject) {
        this.checkInit();
        if (!this.m_columnExpressions.contains(indexObject)) {
            this.m_columnExpressions.add(indexObject);
        }
    }

    public void addColumnExpression(int n, IndexObject indexObject) {
        this.checkInit();
        if (!this.m_columnExpressions.contains(indexObject)) {
            this.m_columnExpressions.add(n, indexObject);
        }
    }

    public void removeColumnExpression(IndexObject indexObject) {
        this.checkInit();
        if (this.m_columnExpressions.contains(indexObject)) {
            this.m_columnExpressions.remove(indexObject);
        }
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("SQLFragment", stringArray) || this.includesType("SQLFragment", stringArray)) {
            collection.addAll(this.m_columnExpressions);
        }
    }

    @Override
    public Schema getSchema() {
        Schema schema = super.getSchema();
        if (schema == null && this._table != null) {
            return this._table.getSchema();
        }
        return schema;
    }

    @Override
    public void setSchema(Schema schema) {
        if (this._table == null || ModelUtil.areDifferent((Object)schema, (Object)this._table.getSchema())) {
            super.setSchema(schema);
        } else {
            super.setSchema(null);
        }
    }
}

