/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcSynonymBuilder;
import oracle.javatools.db.JdbcTableBuilder;
import oracle.javatools.db.JdbcViewBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.util.ModelUtil;

public class JdbcDatabase
extends AbstractDatabase {
    public static final String DEFAULT_SCHEMA_KEY = "isDefaultSchema";
    public static final String ODBC_NOT_IMPLEMENTED = "IM001";
    public static final int DOMAIN_ALL = 65535;
    public static final DataType ANSI_CHAR = new PredefinedDataType(65535, "CHAR");
    public static final DataType ANSI_CHARACTER = new PredefinedDataType(65535, "CHARACTER");
    public static final DataType ANSI_CHAR_VARYING = new PredefinedDataType(65535, "CHAR VARYING");
    public static final DataType ANSI_CHARACTER_VARYING = new PredefinedDataType(65535, "CHARACTER VARYING");
    public static final DataType ANSI_VARCHAR = new PredefinedDataType(65535, "VARCHAR");
    public static final DataType ANSI_CHAR_LARGE_OBJECT = new PredefinedDataType(65535, "CHAR LARGE OBJECT");
    public static final DataType ANSI_CHARACTER_LARGE_OBJECT = new PredefinedDataType(65535, "CHARACTER LARGE OBJECT");
    public static final DataType ANSI_CLOB = new PredefinedDataType(65535, "CLOB");
    public static final DataType ANSI_BIT = new PredefinedDataType(65535, "BIT");
    public static final DataType ANSI_BIT_VARYING = new PredefinedDataType(65535, "BIT VARYING");
    public static final DataType ANSI_NCHAR = new PredefinedDataType(65535, "NCHAR");
    public static final DataType ANSI_NATIONAL_CHAR = new PredefinedDataType(65535, "NATIONAL CHAR");
    public static final DataType ANSI_NATIONAL_CHARACTER = new PredefinedDataType(65535, "NATIONAL CHARACTER");
    public static final DataType ANSI_NCHAR_VARYING = new PredefinedDataType(65535, "NCHAR VARYING");
    public static final DataType ANSI_NATIONAL_CHAR_VARYING = new PredefinedDataType(65535, "NATIONAL CHAR VARYING");
    public static final DataType ANSI_NATIONAL_CHARACTER_VARYING = new PredefinedDataType(65535, "NATIONAL CHARACTER VARYING");
    public static final DataType ANSI_NATIONAL_CHARACTER_LARGE_OBJECT = new PredefinedDataType(65535, "NATIONAL CHARACTER LARGE OBJECT");
    public static final DataType ANSI_NCHAR_LARGE_OBJECT = new PredefinedDataType(65535, "NCHAR LARGE OBJECT");
    public static final DataType ANSI_NCLOB = new PredefinedDataType(65535, "NCLOB");
    public static final DataType ANSI_BINARY_LARGE_OBJECT = new PredefinedDataType(65535, "BINARY LARGE OBJECT");
    public static final DataType ANSI_BLOB = new PredefinedDataType(65535, "BLOB");
    public static final DataType ANSI_NUMERIC = new NumericDataType(65535, "NUMERIC", null);
    public static final DataType ANSI_DECIMAL = new NumericDataType(65535, "DECIMAL", null);
    public static final DataType ANSI_DEC = new NumericDataType(65535, "DEC", null);
    public static final DataType ANSI_INTEGER = new NumericDataType(65535, "INTEGER", null);
    public static final DataType ANSI_INT = new NumericDataType(65535, "INT", null);
    public static final DataType ANSI_BIGINT = new NumericDataType(65535, "BIGINT", null);
    public static final DataType ANSI_SMALLINT = new NumericDataType(65535, "SMALLINT", null);
    public static final DataType ANSI_FLOAT = new NumericDataType(65535, "FLOAT", null);
    public static final DataType ANSI_REAL = new NumericDataType(65535, "REAL", null);
    public static final DataType ANSI_DOUBLE_PRECISION = new NumericDataType(65535, "DOUBLE PRECISION", null);
    public static final DataType ANSI_DATE = new PredefinedDataType(65535, "DATE");
    public static final DataType ANSI_TIME = new PredefinedDataType(65535, "TIME");
    public static final DataType ANSI_TIME_WITH_TIME_ZONE = new PredefinedDataType(65535, "TIME WITH TIME ZONE");
    public static final DataType ANSI_TIME_WITHOUT_TIME_ZONE = new PredefinedDataType(65535, "TIME WITHOUT TIME ZONE");
    public static final DataType ANSI_TIMESTAMP = new PredefinedDataType(65535, "TIMESTAMP");
    public static final DataType ANSI_TIMESTAMP_WITH_TIME_ZONE = new PredefinedDataType(65535, "TIMESTAMP WITH TIME ZONE");
    public static final DataType ANSI_TIMESTAMP_WITHOUT_TIME_ZONE = new PredefinedDataType(65535, "TIMESTAMP WITHOUT TIME ZONE");
    public static final DataType ANSI_BOOLEAN = new PredefinedDataType(65535, "BOOLEAN");
    public static final DataType ANSI_INTERVAL = new PredefinedDataType(65535, "INTERVAL");
    public static final DataType ANSI_ROW = new PredefinedDataType(65535, "ROW");
    public static final DataType ANSI_REF = new PredefinedDataType(65535, "REF");
    protected String _catalog;
    private Map _schemas;
    private String _quoteString;
    private boolean _supportSchemas;

    public JdbcDatabase(String string, Connection connection) {
        super(string, connection);
        ResultSet resultSet = null;
        try {
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                resultSet = databaseMetaData.getSchemas();
                this._supportSchemas = true;
            }
            catch (SQLException sQLException) {}
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public JdbcDatabase(Connection connection) {
        this(null, connection);
    }

    protected int getCasePolicy() {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor == null) {
            int n = 0;
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                if (!databaseMetaData.supportsMixedCaseIdentifiers()) {
                    n = databaseMetaData.storesUpperCaseIdentifiers() ? 2 : 1;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return n;
        }
        return super.getCasePolicy();
    }

    protected void registerBuilders() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Connection connection = this.getConnection();
            this._catalog = connection.getCatalog();
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            ResultSet resultSet = databaseMetaData.getTableTypes();
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).trim());
            }
        }
        catch (SQLException sQLException) {
            hashSet.clear();
            hashSet.add("TABLE");
        }
        boolean bl = this._supportSchemas;
        if (hashSet.contains("TABLE")) {
            this.registerBuilder("TABLE", new JdbcTableBuilder(this, this._catalog, bl));
        }
        if (hashSet.contains("VIEW")) {
            this.registerBuilder("VIEW", new JdbcViewBuilder(this, this._catalog, bl));
        }
        if (hashSet.contains("SYNONYM")) {
            this.registerBuilder("SYNONYM", new JdbcSynonymBuilder(this, this._catalog, bl));
        }
    }

    public String getDatabaseType() {
        return "Generic JDBC";
    }

    public String getUserName() throws DBException {
        String string = null;
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            string = databaseMetaData.getUserName();
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
        return string;
    }

    public boolean hasPriviledge(String string, Schema schema, String string2) {
        if ("CREATE".equals(string2) || "DELETE".equals(string2)) {
            return false;
        }
        return super.hasPriviledge(string, schema, string2);
    }

    public String getIdentifierQuoteString() {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor == null) {
            if (this._quoteString == null) {
                try {
                    DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                    this._quoteString = databaseMetaData.getIdentifierQuoteString();
                }
                catch (SQLException sQLException) {
                    this._quoteString = "";
                }
            }
            return this._quoteString;
        }
        return super.getIdentifierQuoteString();
    }

    public boolean canCreate(SchemaObject schemaObject, boolean bl) {
        return false;
    }

    public boolean canDelete(SchemaObject schemaObject, boolean bl) {
        return false;
    }

    public void createObject(SchemaObject schemaObject, boolean bl) throws DBException {
        throw new DBException((DBObject)schemaObject, (Throwable)new UnsupportedOperationException("Object Creation"));
    }

    public void deleteObject(SchemaObject schemaObject, boolean bl) throws DBException {
        throw new DBException((DBObject)schemaObject, (Throwable)new UnsupportedOperationException("Object Deletion"));
    }

    public void undeleteObject(SchemaObject schemaObject) throws DBException {
        throw new DBException((DBObject)schemaObject, (Throwable)new UnsupportedOperationException("Object Undeletion"));
    }

    public void undeleteObjects(SchemaObject[] schemaObjectArray) throws DBException {
        throw new DBException(new UnsupportedOperationException("Object Undletion"));
    }

    public void validateObject(DBObject dBObject) throws ValidationException {
    }

    public void validateObject(DBObject dBObject, DBObject dBObject2) throws ValidationException {
    }

    public void updateObject(SchemaObject schemaObject, SchemaObject schemaObject2) throws DBException {
        throw new DBException((DBObject)schemaObject, (Throwable)new UnsupportedOperationException("Object Update"));
    }

    public Schema getSchema(String string) throws DBException {
        this.loadSchemas();
        if (string == null) {
            string = "";
        }
        return (Schema)this._schemas.get(string);
    }

    public Schema[] listSchemas() throws DBException {
        this.loadSchemas();
        Collection collection = this._schemas.values();
        return collection.toArray(new Schema[collection.size()]);
    }

    public boolean canCreate(Schema schema, boolean bl) {
        return false;
    }

    public void createSchema(Schema schema, boolean bl) throws DBException {
        throw new DBException((DBObject)schema, (Throwable)new UnsupportedOperationException("Create Schema"));
    }

    public boolean canDelete(Schema schema, boolean bl) {
        return false;
    }

    public void deleteSchema(Schema schema, boolean bl) throws DBException {
        throw new DBException((DBObject)schema, (Throwable)new UnsupportedOperationException("Schema Deletion"));
    }

    public void updateSchema(Schema schema, Schema schema2) throws DBException {
        throw new DBException((DBObject)schema, (Throwable)new UnsupportedOperationException("Schema Update"));
    }

    private void loadSchemas() throws DBException {
        if (this._schemas == null) {
            block14: {
                this._schemas = new TreeMap();
                ResultSet resultSet = null;
                try {
                    try {
                        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                        resultSet = databaseMetaData.getSchemas();
                        while (resultSet.next()) {
                            String string = resultSet.getString(1);
                            this._schemas.put(string, this.createSchema(string));
                        }
                    }
                    catch (SQLException sQLException) {
                        if ("S1C00".equals(sQLException.getSQLState())) {
                            this._schemas.clear();
                            break block14;
                        }
                        throw new DBException(sQLException);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this._schemas.size() == 0) {
                Schema schema = this.createSchema("");
                schema.setProperty(DEFAULT_SCHEMA_KEY, Boolean.TRUE);
                this._schemas.put("", schema);
            }
        }
    }

    static void checkUnsupportedOperation(SQLException sQLException) throws SQLException {
        String string = sQLException.getSQLState();
        if (ModelUtil.areDifferent((Object)string, (Object)"S1C00") && ModelUtil.areDifferent((Object)string, (Object)ODBC_NOT_IMPLEMENTED)) {
            throw sQLException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SchemaObject[] listObjectsImpl(String[] stringArray, Schema schema, String string) throws DBException {
        ArrayList<AbstractSchemaObject> arrayList = new ArrayList<AbstractSchemaObject>();
        boolean bl = false;
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = null;
        String string2 = this._supportSchemas ? JdbcDatabase.convertObject(schema) : null;
        try {
            databaseMetaData = this.getConnection().getMetaData();
            try {
                resultSet = databaseMetaData.getTables(this._catalog, string2, string, stringArray);
                bl = resultSet.next();
                if (!bl) {
                    resultSet = databaseMetaData.getTables(this._catalog, null, string, stringArray);
                    bl = resultSet.next();
                }
            }
            catch (SQLException sQLException) {
                if (!"S1C00".equals(sQLException.getSQLState())) throw sQLException;
                resultSet = databaseMetaData.getTables(this._catalog, null, null, stringArray);
                bl = resultSet.next();
            }
            while (bl) {
                DBObjectBuilder dBObjectBuilder;
                AbstractSchemaObject abstractSchemaObject = null;
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                if (this._catalogMatches(string3) && this._schemaMatches(string2, string4) && (dBObjectBuilder = this.getBuilderForType(string6)) != null) {
                    Schema schema2 = this._supportSchemas ? schema : null;
                    BaseObjectID baseObjectID = BaseObjectID.createObjectID(schema2, string5, string6, this);
                    abstractSchemaObject = (AbstractSchemaObject)dBObjectBuilder.createObject(string5, schema2, baseObjectID);
                }
                if (abstractSchemaObject != null) {
                    this.markForLazyInit(abstractSchemaObject);
                    arrayList.add(abstractSchemaObject);
                }
                bl = resultSet.next();
            }
            return arrayList.toArray(new SchemaObject[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
    }

    protected String normaliseDataTypeName(String string) {
        return string;
    }

    protected String normaliseDefaultValue(DataType dataType, String string) {
        return string;
    }

    private boolean _catalogMatches(String string) {
        return this._catalog == null || this._catalog.equals(string);
    }

    private boolean _schemaMatches(String string, String string2) {
        return !this._supportSchemas || !ModelUtil.hasLength((String)string) || ModelUtil.areEqual((Object)string, (Object)string2);
    }
}

