/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DMDBuilder;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.util.ModelUtil;

public abstract class JdbcRelationBuilder
extends DMDBuilder {
    protected JdbcRelationBuilder(JdbcDatabase jdbcDatabase, String string, String string2, boolean bl) {
        super(jdbcDatabase, string, string2, bl);
    }

    protected abstract Relation createRelation(Schema var1, String var2);

    public SchemaObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Relation relation = this.createRelation(schema, string);
        relation.setID(dBObjectID);
        return relation;
    }

    protected void fillInObject(SchemaObject schemaObject) throws DBException {
        Relation relation = (Relation)schemaObject;
        try {
            Connection connection = this.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.fillInColumns(relation, databaseMetaData);
            this.fillInConstraints(relation, databaseMetaData);
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
    }

    protected void fillInColumns(Relation relation, DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = null;
        ArrayList<Column> arrayList = new ArrayList<Column>(20);
        try {
            JdbcDatabase jdbcDatabase = this.getDatabase();
            resultSet = databaseMetaData.getColumns(this.getCatalog(), this.isUseSchema() ? AbstractDBObjectProvider.convertObject(relation.getSchema()) : null, relation.getName(), "%");
            int n = 0;
            while (resultSet.next()) {
                ++n;
                String string = resultSet.getString(4);
                Column column = new Column(string);
                column.setID(BaseObjectID.createObjectID(null, string, column.getType(), jdbcDatabase, (BaseObjectID)relation.getID()));
                arrayList.add(column);
                column.setRelation(relation);
                String string2 = resultSet.getString(12);
                if (ModelUtil.hasLength((String)string2)) {
                    column.setProperty("Comment", string2);
                }
                column.setNotNull(resultSet.getString(18).trim().equals("NO"));
                String string3 = jdbcDatabase.normaliseDataTypeName(resultSet.getString(6));
                DataType dataType = jdbcDatabase.getDataType(string3);
                if (dataType == null) continue;
                long l = resultSet.getLong(7);
                Long l2 = resultSet.wasNull() ? null : new Long(l);
                l = resultSet.getLong(9);
                Long l3 = resultSet.wasNull() ? null : new Long(l);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("name", string3);
                hashMap.put("size", DataTypeHelper.getAttributeValue(l2, dataType, "size"));
                hashMap.put("precision", DataTypeHelper.getAttributeValue(l2, dataType, "precision"));
                hashMap.put("scale", DataTypeHelper.getAttributeValue(l3, dataType, "scale"));
                column.setDataTypeUsage(dataType.createUsage(hashMap));
                String string4 = resultSet.getString(13);
                if (!ModelUtil.hasLength((String)string4)) continue;
                column.setDefault(jdbcDatabase.normaliseDefaultValue(dataType, string4));
            }
            DBUtil.getLog().trace(">>fillInColumns : " + n + " columns returned for " + relation.getName());
            relation.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void fillInConstraints(Relation relation, DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<PKConstraint> arrayList = new ArrayList<PKConstraint>();
        ResultSet resultSet = null;
        String string = this.getCatalog();
        String string2 = this.isUseSchema() ? AbstractDBObjectProvider.convertObject(relation.getSchema()) : null;
        String string3 = relation.getName();
        try {
            try {
                resultSet = databaseMetaData.getPrimaryKeys(string, string2, string3);
                if (resultSet.next()) {
                    TreeSet<PKCol> treeSet = new TreeSet<PKCol>();
                    String string4 = resultSet.getString(6);
                    string4 = ModelUtil.hasLength((String)string4) ? string4 : JdbcRelationBuilder.makePKName(resultSet.getString(2), resultSet.getString(3));
                    PKConstraint pKConstraint = new PKConstraint(string4, relation);
                    pKConstraint.setID(ConstraintID.createObjectID(relation.getID(), string4, "PKConstraint"));
                    String string5 = resultSet.getString(4);
                    short s = resultSet.getShort(5);
                    treeSet.add(new PKCol(s, string5));
                    while (resultSet.next()) {
                        string5 = resultSet.getString(4);
                        s = resultSet.getShort(5);
                        treeSet.add(new PKCol(s, string5));
                    }
                    for (PKCol pKCol : treeSet) {
                        Column column = relation.getColumn(pKCol._colName);
                        if (column == null) continue;
                        pKConstraint.addColumn(column);
                    }
                    if (pKConstraint.getColumns().length > 0) {
                        relation.addConstraint(pKConstraint);
                        arrayList.add(pKConstraint);
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                JdbcDatabase.checkUnsupportedOperation(sQLException);
            }
            HashMap<String, FKConstraint> hashMap = new HashMap<String, FKConstraint>();
            JdbcDatabase jdbcDatabase = this.getDatabase();
            try {
                ColumnConstraint columnConstraint = null;
                Column[] columnArray = null;
                Column[] columnArray2 = null;
                resultSet = databaseMetaData.getImportedKeys(string, string2, string3);
                while (resultSet.next()) {
                    String string6 = resultSet.getString(2);
                    String string7 = resultSet.getString(3);
                    String string8 = resultSet.getString(4);
                    String string9 = resultSet.getString(6);
                    String string10 = resultSet.getString(7);
                    String string11 = resultSet.getString(8);
                    short s = resultSet.getShort(11);
                    String string12 = resultSet.getString(12);
                    String string13 = resultSet.getString(13);
                    Schema schema = null;
                    try {
                        schema = jdbcDatabase.getSchema(string6);
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    string13 = ModelUtil.hasLength((String)string13) ? string13 : JdbcRelationBuilder.makePKName(string6, string7);
                    FKConstraint fKConstraint = (FKConstraint)hashMap.get(string12);
                    if (fKConstraint == null) {
                        if (columnConstraint != null) {
                            columnConstraint.setColumns(columnArray);
                        }
                        fKConstraint = new FKConstraint(string12, relation);
                        ConstraintID constraintID = ConstraintID.createObjectID(relation.getID(), string12, "FKConstraint");
                        fKConstraint.setID(constraintID);
                        BaseObjectID baseObjectID = BaseObjectID.createObjectID(schema, string7, "TABLE", this.getDatabase());
                        ConstraintID constraintID2 = ConstraintID.createObjectID(baseObjectID, string13, "PKConstraint");
                        fKConstraint.setReferenceID(constraintID2);
                        hashMap.put(string12, fKConstraint);
                        try {
                            UniqueConstraint uniqueConstraint = (UniqueConstraint)fKConstraint.getReferenceID().resolveID();
                            if (uniqueConstraint == null) {
                                throw new SQLException("Unable to recover unique key " + string6 + "." + string7 + "." + string13 + " referenced by foreign key " + string9 + "." + string10 + "." + string12);
                            }
                            columnArray2 = uniqueConstraint.getColumns();
                            columnArray = new Column[columnArray2.length];
                        }
                        catch (DBException dBException) {
                            // empty catch block
                        }
                    }
                    columnConstraint = fKConstraint;
                    columnArray[JdbcRelationBuilder.getColumnPosition((String)string8, columnArray2)] = relation.getColumn(string11);
                    short s2 = s;
                    int n = s2 == 0 ? 1 : (s2 == 2 ? 2 : 0);
                    fKConstraint.setDeleteMode(n);
                }
                if (columnConstraint != null) {
                    columnConstraint.setColumns(columnArray);
                }
            }
            catch (SQLException sQLException) {
                JdbcDatabase.checkUnsupportedOperation(sQLException);
            }
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add((PKConstraint)iterator.next());
            }
            relation.setConstraints(arrayList.toArray(new Constraint[arrayList.size()]));
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String makePKName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (ModelUtil.hasLength((String)string)) {
            stringBuffer.append(string + '#');
        }
        stringBuffer.append(string2 + "#PK");
        return stringBuffer.toString();
    }

    private static int getColumnPosition(String string, Column[] columnArray) {
        int n = 0;
        while (n < columnArray.length) {
            if (string.equals(columnArray[n].getName())) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private static class PKCol
    implements Comparable {
        short _seq;
        String _colName;

        PKCol(short s, String string) {
            this._seq = s;
            this._colName = string;
        }

        public int compareTo(Object object) {
            return this._seq - ((PKCol)object)._seq;
        }
    }
}

