/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.JdbcRelationBuilder;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;

public class JdbcTableBuilder
extends JdbcRelationBuilder {
    protected JdbcTableBuilder(JdbcDatabase jdbcDatabase, String string, boolean bl) {
        super(jdbcDatabase, string, "TABLE", bl);
    }

    public void fillInObject(SchemaObject schemaObject) throws DBException {
        super.fillInObject(schemaObject);
        this._buildIndexes((Table)schemaObject);
    }

    protected Relation createRelation(Schema schema, String string) {
        return new Table(string, schema);
    }

    private void _buildIndexes(Table table) throws DBException {
        HashMap<String, Index> hashMap = new HashMap<String, Index>();
        Schema schema = table.getSchema();
        String string = this.isUseSchema() ? AbstractDBObjectProvider.convertObject(table.getSchema()) : null;
        ResultSet resultSet = null;
        try {
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                resultSet = databaseMetaData.getIndexInfo(this.getCatalog(), string, table.getName(), false, false);
                while (resultSet.next()) {
                    Column column;
                    String string2 = resultSet.getString(6);
                    int n = resultSet.getInt(7);
                    String string3 = resultSet.getString(9);
                    String string4 = resultSet.getString(10);
                    if (n == 0) continue;
                    Index index = (Index)hashMap.get(string2);
                    if (index == null) {
                        index = new Index(string2, table);
                        hashMap.put(string2, index);
                    }
                    if ((column = table.getColumn(string3)) == null) continue;
                    if (string4 != null) {
                        string4 = string4.equals("A") ? "ASC" : "DESC";
                    }
                    IndexObject indexObject = new IndexObject(new ColumnUsage(column.getID()), string4);
                    index.addColumnExpression(indexObject);
                }
            }
            catch (SQLException sQLException) {
                throw new DBException(null, "Error building object", sQLException);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                resultSet = null;
            }
        }
        Collection collection = hashMap.values();
        table.setIndexes(collection.toArray(new Index[collection.size()]));
    }
}

