/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ValidationException;

public class NameInUseException
extends ValidationException {
    private String m_name;
    private String m_userName;
    private String m_userType;

    public NameInUseException(DBObject dBObject) {
        super(dBObject, DBArb.format(46, dBObject == null ? null : dBObject.getName()));
    }

    public NameInUseException(String string) {
        super(null, DBArb.format(46, string));
    }

    public NameInUseException(String string, String string2, String string3) {
        super(null, NameInUseException.getMessage(string, string2, string3));
        this.m_userType = string3;
        this.m_userName = string2;
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getUserType() {
        return this.m_userType;
    }

    private static String getMessage(String string, String string2, String string3) {
        if (string2 != null) {
            return DBArb.format(47, string, string3 == null ? "" : string3.toLowerCase(), string2);
        }
        return DBArb.format(46, string);
    }
}

