/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlSubprogramDeclarator;
import oracle.javatools.util.ModelUtil;

public abstract class PlSqlSubprogram
extends PlSql
implements DeclarativePlSql {
    private DataType m_returnType;
    private List m_paramList;
    private String m_body;

    void $init$() {
        this.m_paramList = new ArrayList();
    }

    public PlSqlSubprogram() {
        this.$init$();
    }

    public PlSqlSubprogram(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    protected void copyToImpl(PlSqlSubprogram plSqlSubprogram, boolean bl) {
        super.copyToImpl(plSqlSubprogram, bl);
        plSqlSubprogram.m_returnType = this.m_returnType;
        plSqlSubprogram.m_paramList.clear();
        for (PlSqlParameter plSqlParameter : this.m_paramList) {
            plSqlSubprogram.addParameter((PlSqlParameter)plSqlParameter.copyTo(null, plSqlSubprogram, bl));
        }
        plSqlSubprogram.m_body = this.m_body;
    }

    protected boolean equalsImpl(PlSqlSubprogram plSqlSubprogram) {
        return super.equalsImpl(plSqlSubprogram) && ModelUtil.areEqual((Object)this.m_returnType, (Object)plSqlSubprogram.m_returnType) && ModelUtil.areEqual((Object)this.m_paramList, (Object)plSqlSubprogram.m_paramList) && ModelUtil.areEqual((Object)this.m_body, (Object)plSqlSubprogram.m_body);
    }

    public DataType getReturnType() {
        this.checkInit();
        return this.m_returnType;
    }

    public void setReturnType(DataType dataType) {
        this.checkInit();
        this.m_returnType = dataType;
    }

    public void setParameters(PlSqlParameter[] plSqlParameterArray) {
        this.checkInit();
        Iterator iterator = this.m_paramList.iterator();
        while (iterator.hasNext()) {
            ((PlSqlParameter)iterator.next()).setPlSql(null);
        }
        if (plSqlParameterArray == null) {
            plSqlParameterArray = new PlSqlParameter[]{};
        }
        int n = plSqlParameterArray.length;
        this.m_paramList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            plSqlParameterArray[n2].setPlSql(this);
            this.m_paramList.add(plSqlParameterArray[n2]);
            ++n2;
        }
    }

    public PlSqlParameter[] getParameters() {
        this.checkInit();
        return this.m_paramList.toArray(new PlSqlParameter[this.m_paramList.size()]);
    }

    public void addParameter(PlSqlParameter plSqlParameter) {
        this.checkInit();
        if (!this.m_paramList.contains(plSqlParameter)) {
            plSqlParameter.setPlSql(this);
            this.m_paramList.add(plSqlParameter);
        }
    }

    public void addParameter(int n, PlSqlParameter plSqlParameter) {
        this.checkInit();
        if (!this.m_paramList.contains(plSqlParameter)) {
            plSqlParameter.setPlSql(this);
            this.m_paramList.add(n, plSqlParameter);
        }
    }

    public PlSqlParameter getParameter(String string) {
        this.checkInit();
        if (string != null) {
            for (PlSqlParameter plSqlParameter : this.m_paramList) {
                if (!ModelUtil.areEqual((Object)plSqlParameter.getName(), (Object)string)) continue;
                return plSqlParameter;
            }
        }
        return null;
    }

    public void removeParameter(PlSqlParameter plSqlParameter) {
        this.checkInit();
        if (this.m_paramList.contains(plSqlParameter)) {
            this.m_paramList.remove(plSqlParameter);
            plSqlParameter.setPlSql(null);
        }
    }

    public PlSqlDeclarator getDeclarator(DBObjectProvider dBObjectProvider) {
        return new PlSqlSubprogramDeclarator(dBObjectProvider);
    }

    public String getBody() {
        return this.m_body;
    }

    public void setBody(String string) {
        this.m_body = string;
    }
}

