/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyIterator;

public class Properties {
    private static HashSet s_ignor;
    private Object m_object;
    private Map m_mapProps;
    private Map m_naturalProps;
    private Map m_children;
    private static NumberFormat formatter;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = Properties.class.desiredAssertionStatus() ^ true;
        s_ignor = new HashSet();
        s_ignor.add("ID");
        s_ignor.add("precision");
        s_ignor.add("scale");
        s_ignor.add("Parent");
        s_ignor.add("Index");
        s_ignor.add("Timestamp");
        formatter = new DecimalFormat("##0.####E0");
    }

    void $init$() {
        this.m_mapProps = new HashMap();
        this.m_naturalProps = new HashMap();
        this.m_children = new HashMap();
    }

    public Properties(Object object) {
        HashMap hashMap;
        this.$init$();
        this.m_object = object;
        PropertyIterator propertyIterator = new PropertyIterator(object);
        while (propertyIterator.hasNext()) {
            PropertyInfo propertyInfo = propertyIterator.next();
            String string = propertyInfo.getXMLName();
            Class clazz = propertyInfo.getPropertyClass();
            if (s_ignor.contains(string)) continue;
            if (clazz.isArray()) {
                this.m_children.put(string, propertyInfo);
                continue;
            }
            if (clazz == Map.class) continue;
            this.m_naturalProps.put(string, propertyInfo);
        }
        if (object instanceof DBObject && (hashMap = (HashMap)((DBObject)object).getProperties()) != null) {
            for (String string : hashMap.keySet()) {
                if (s_ignor.contains(string)) continue;
                this.m_mapProps.put(string, hashMap.get(string));
            }
        }
    }

    public static void ignor(String string) {
        s_ignor.add(string);
    }

    public void set(String string, Object object) {
        if (this.m_naturalProps.containsKey(string)) {
            PropertyInfo propertyInfo = (PropertyInfo)this.m_naturalProps.get(string);
            try {
                propertyInfo.setPropertyValue(this.m_object, object);
            }
            catch (Exception exception) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Cant set property: " + string.toString()));
                }
            }
        } else if (this.m_object instanceof DBObject) {
            ((DBObject)this.m_object).setProperty(string, object);
        }
    }

    public Object get(Object object) {
        Object object2 = null;
        if (this.m_naturalProps.containsKey(object)) {
            object2 = ((PropertyInfo)this.m_naturalProps.get(object)).getPropertyValue(this.m_object);
        } else if (this.m_children.containsKey(object)) {
            object2 = ((PropertyInfo)this.m_children.get(object)).getPropertyValue(this.m_object);
        } else if (this.m_object instanceof DBObject && object instanceof String) {
            object2 = ((DBObject)this.m_object).getProperty((String)object);
        }
        return object2;
    }

    public String getEVal(Object object) {
        String string = "";
        Object object2 = this.get(object);
        string = object2 instanceof BigInteger && ((BigInteger)object2).abs().compareTo(new BigInteger("100000000")) > 0 ? formatter.format(object2) : this.getStringVal(object);
        return string;
    }

    public String getStringVal(Object object) {
        String string = "";
        try {
            if ("dataTypeID".equals(object)) {
                DBObjectID dBObjectID = (DBObjectID)this.get(object);
                DataType dataType = (DataType)dBObjectID.resolveID();
                string = dataType.getName();
            } else {
                Object object2 = this.get(object);
                if (object2 != null) {
                    string = object2.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean containsKey(Object object) {
        return this.m_mapProps.containsKey(object) || this.m_naturalProps.containsKey(object) || this.m_children.containsKey(object);
    }

    public void remove(Object object) {
        if (this.m_mapProps.containsKey(object)) {
            this.m_mapProps.remove(object);
        } else if (this.m_naturalProps.containsKey(object)) {
            this.m_naturalProps.remove(object);
        } else {
            this.m_children.remove(object);
        }
    }

    public Set keySet() {
        HashSet hashSet = new HashSet(this.m_naturalProps.keySet());
        hashSet.addAll(this.m_mapProps.keySet());
        return hashSet;
    }

    public Set childKeySet() {
        return this.m_children.keySet();
    }
}

