/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Relation
extends AbstractSchemaObject {
    private List<Column> _colList;
    private List<Constraint> _consList;

    void $init$() {
        this._colList = new ArrayList<Column>();
        this._consList = new ArrayList<Constraint>();
    }

    protected Relation() {
        this.$init$();
    }

    protected Relation(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    protected void copyToImpl(Relation relation, boolean bl) {
        super.copyToImpl(relation, bl);
        relation._colList.clear();
        for (Column column : this._colList) {
            relation.addColumn((Column)column.copyTo(null, relation, bl));
        }
        relation._consList.clear();
        for (Constraint constraint : this._consList) {
            relation.addConstraint((Constraint)constraint.copyTo(null, relation, bl));
        }
    }

    protected boolean equalsImpl(Relation relation) {
        boolean bl = super.equalsImpl(relation) && ModelUtil.areEqual(this._colList, relation._colList) && ModelUtil.areEqual(this._consList, relation._consList);
        return bl;
    }

    public void setColumns(Column[] columnArray) {
        this.checkInit("COLUMN");
        Iterator<Column> iterator = this._colList.iterator();
        while (iterator.hasNext()) {
            iterator.next().setRelation(null);
        }
        if (columnArray == null) {
            columnArray = new Column[]{};
        }
        int n = columnArray.length;
        this._colList = new ArrayList<Column>(n);
        int n2 = 0;
        while (n2 < n) {
            columnArray[n2].setRelation(this);
            this._colList.add(columnArray[n2]);
            ++n2;
        }
    }

    public Column[] getColumns() {
        this.checkInit("COLUMN");
        return this._colList.toArray(new Column[this._colList.size()]);
    }

    public void addColumn(Column column) {
        this.checkInit("COLUMN");
        if (!this._colList.contains(column)) {
            column.setRelation(this);
            this._colList.add(column);
        }
    }

    public void addColumn(int n, Column column) {
        this.checkInit("COLUMN");
        if (!this._colList.contains(column)) {
            column.setRelation(this);
            this._colList.add(n, column);
        }
    }

    public Column getColumn(String string) {
        this.checkInit("COLUMN");
        if (string != null) {
            for (Column column : this._colList) {
                if (!ModelUtil.areEqual((Object)column.getName(), (Object)string)) continue;
                return column;
            }
        }
        return null;
    }

    public void removeColumn(Column column) {
        this.checkInit("COLUMN");
        if (this._colList.contains(column)) {
            this._colList.remove(column);
            column.setRelation(null);
        }
    }

    public Constraint[] getConstraints() {
        this.checkInit("CONSTRAINT");
        return this._consList.toArray(new Constraint[this._consList.size()]);
    }

    public void setConstraints(Constraint[] constraintArray) {
        this.checkInit("CONSTRAINT");
        Iterator<Constraint> iterator = this._consList.iterator();
        while (iterator.hasNext()) {
            iterator.next().setRelation(null);
        }
        if (constraintArray == null) {
            constraintArray = new Constraint[]{};
        }
        int n = constraintArray.length;
        this._consList = new ArrayList<Constraint>(n);
        int n2 = 0;
        while (n2 < n) {
            constraintArray[n2].setRelation(this);
            this._consList.add(constraintArray[n2]);
            ++n2;
        }
    }

    public Constraint getConstraint(String string) {
        this.checkInit("CONSTRAINT");
        if (string != null) {
            for (Constraint constraint : this._consList) {
                if (!ModelUtil.areEqual((Object)constraint.getName(), (Object)string)) continue;
                return constraint;
            }
        }
        return null;
    }

    public void addConstraint(Constraint constraint) {
        this.checkInit("CONSTRAINT");
        if (!this._consList.contains(constraint)) {
            constraint.setRelation(this);
            this._consList.add(constraint);
        }
    }

    public void removeConstraint(Constraint constraint) {
        this.checkInit("CONSTRAINT");
        if (this._consList.contains(constraint)) {
            this._consList.remove(constraint);
            constraint.setRelation(null);
        }
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("COLUMN", stringArray)) {
            collection.addAll(this._colList);
        }
        if (this.includesType("CONSTRAINT", stringArray)) {
            collection.addAll(this._consList);
        }
        if (stringArray != null) {
            for (Constraint constraint : this._consList) {
                if (!this.includesType(constraint.getConstraintType(), stringArray)) continue;
                collection.add(constraint);
            }
        }
    }

    static boolean isRelation(String string) {
        return string.equals("TABLE") || string.equals("VIEW");
    }
}

