/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;

public class SQLServerDatabaseDescriptor
extends DatabaseDescriptor {
    private static final int MAX_NAME_LENGTH = 128;
    private static final int MAX_TEMP_NAME_LENGTH = 116;
    private static final char QUOTE_IDENTIFIER = '\"';
    private static final char OPEN_QUOTE_IDENTIFIER = '[';
    private static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SELECT", "SESION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT"));

    public int getCasePolicy() {
        return 0;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public void validateName(String string, String string2) throws InvalidNameException {
        boolean bl = true;
        String string3 = "";
        try {
            SQLServerDatabaseDescriptor.validateIdentifier(string2, '\"', 128, "_$#@", false, RESERVED_WORDS, this.getCasePolicy());
        }
        catch (InvalidNameException invalidNameException) {
            bl = false;
            string3 = invalidNameException.getMessage();
        }
        char c = string2.charAt(0);
        if (bl && c != '\"' && !Character.isLetter(c) && c != '_' && c != '#' && c != '@') {
            throw new InvalidNameException(null, DBArb.getString(4));
        }
        if (bl && c == '\"' && string2.indexOf(34, 1) != string2.length() - 1) {
            throw new InvalidNameException(null, DBArb.getString(4));
        }
        if (!bl && c == '[' && string2.indexOf(91, 1) == -1 && string2.indexOf(93, 1) == string2.length() - 1 && string2.length() > 2 && string2.length() < 131) {
            bl = true;
        }
        if (!bl) {
            throw new InvalidNameException(null, string3);
        }
    }
}

