/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.datatypes.DataTypeRegistry;

public class SQLServerDatabaseFactory
extends DatabaseFactory {
    private DatabaseDescriptor m_descriptor;

    public SQLServerDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new SQLServerDatabaseImpl.Registerer(), SQLServerDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String string, Connection connection) {
        if (this.isSQLServerConnection(connection)) {
            return new SQLServerDatabaseImpl(string, connection);
        }
        return null;
    }

    protected boolean isSQLServerConnection(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                boolean bl = string.indexOf("Microsoft SQL Server") > -1;
                return bl;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (SQLServerDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new SQLServerDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

