/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;

public class SQLServerDatabaseImpl
extends JdbcDatabase
implements SQLServerDatabase {
    public SQLServerDatabaseImpl(String string, Connection connection) {
        super(string, connection);
    }

    public DataType getDataType(String string) {
        String[] stringArray = string.trim().toUpperCase().replaceAll("\\s", " ").split("\\b");
        string = stringArray[1];
        if (stringArray[1].equals("NATIONAL")) {
            string = stringArray[1] + stringArray[2] + stringArray[3];
            if (stringArray.length > 5 && stringArray[5].equals("VARYING")) {
                string = string + stringArray[4] + stringArray[5];
            }
        } else if (stringArray.length > 3 && stringArray[3].equals("VARYING")) {
            string = stringArray[1] + stringArray[2] + stringArray[3];
        }
        return super.getDataType(string);
    }

    public static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
            NumericDataType numericDataType = new NumericDataType(65535, "BIGINT", NumericDataType.MIN_MAX_BIGINT);
            NumericDataType numericDataType2 = new NumericDataType(65535, "INT", NumericDataType.MIN_MAX_INT);
            NumericDataType numericDataType3 = new NumericDataType(65535, "SMALLINT", NumericDataType.MIN_MAX_SMALLINT);
            NumericDataType numericDataType4 = new NumericDataType(65535, "TINYINT", NumericDataType.MIN_MAX_UNSIGNED_TINYINT);
            NumericDataType numericDataType5 = new NumericDataType(65535, "BIT", NumericDataType.MIN_MAX_BIT);
            NumericDataType numericDataType6 = new NumericDataType(65535, "DECIMAL", "DECIMAL[(<precision>[, <scale>])]", 1L, 38, new Long(18), false, 0L, null, new Long(0L), false, null, null);
            NumericDataType numericDataType7 = new NumericDataType(65535, "NUMERIC", "NUMERIC[(<precision>[, <scale>])]", 1L, 38, new Long(18), false, 0L, null, new Long(0L), false, null, null);
            NumericDataType numericDataType8 = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, 53, null, false, null, new NumericDataType.MinMaxValue("2.23E-308", "1.79E+308", 2));
            NumericDataType numericDataType9 = new NumericDataType(65535, "REAL", new NumericDataType.MinMaxValue("1.18E-38", "3.40E+38", 2));
            NumericDataType numericDataType10 = new NumericDataType(65535, "MONEY", NumericDataType.MIN_MAX_MONEY);
            NumericDataType numericDataType11 = new NumericDataType(65535, "SMALLMONEY", NumericDataType.MIN_MAX_SMALLMONEY);
            PredefinedDataType predefinedDataType = new PredefinedDataType(65535, "DATETIME");
            PredefinedDataType predefinedDataType2 = new PredefinedDataType(65535, "SMALLDATETIME");
            CharacterDataType characterDataType = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", 1L, 8000L, 1L, false, null);
            CharacterDataType characterDataType2 = new CharacterDataType(65535, "VARCHAR", "VARCHAR[(<size>)]", 1L, 8000L, 1L, false, null);
            CharacterDataType characterDataType3 = new CharacterDataType(65535, "NCHAR", "NCHAR[(<size>)]", 1L, 4000L, 1L, false, null);
            CharacterDataType characterDataType4 = new CharacterDataType(65535, "NVARCHAR", "NVARCHAR[(<size>)]", 1L, 4000L, 1L, false, null);
            CharacterDataType characterDataType5 = new CharacterDataType(65535, "TEXT", 1L, Integer.MAX_VALUE);
            CharacterDataType characterDataType6 = new CharacterDataType(65535, "NTEXT", 1L, 0x3FFFFFFFL);
            BinaryDataType binaryDataType = new BinaryDataType(65535, "BINARY", "BINARY[(<size>)]", 1L, 8000L, 1L, false, null);
            BinaryDataType binaryDataType2 = new BinaryDataType(65535, "VARBINARY", "VARBINARY[(<size>)]", 1L, 8000L, 1L, false, null);
            BinaryDataType binaryDataType3 = new BinaryDataType(65535, "IMAGE", 1L, Integer.MAX_VALUE);
            PredefinedDataType predefinedDataType3 = new PredefinedDataType(65534, "CURSOR");
            PredefinedDataType predefinedDataType4 = new PredefinedDataType(65535, "SQL_VARIANT");
            PredefinedDataType predefinedDataType5 = new PredefinedDataType(65535, "SYSNAME");
            PredefinedDataType predefinedDataType6 = new PredefinedDataType(65534, "TABLE");
            PredefinedDataType predefinedDataType7 = new PredefinedDataType(65535, "UNIQUEIDENTIFIER");
            PredefinedDataType predefinedDataType8 = new PredefinedDataType(65535, "TIMESTAMP");
            dataTypeRegistry.registerDataType(numericDataType, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dataTypeRegistry.registerDataType(numericDataType2, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dataTypeRegistry.registerDataType(numericDataType3, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dataTypeRegistry.registerDataType(numericDataType4, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dataTypeRegistry.registerDataType(numericDataType5, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dataTypeRegistry.registerDataType(numericDataType6, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType7, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_NUMERIC);
            dataTypeRegistry.registerDataType(numericDataType8, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dataTypeRegistry.registerDataType(numericDataType9, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dataTypeRegistry.registerDataType(numericDataType10, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(numericDataType11, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dataTypeRegistry.registerDataType(predefinedDataType, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dataTypeRegistry.registerDataType(predefinedDataType2, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dataTypeRegistry.registerDataType(characterDataType, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_CHAR);
            dataTypeRegistry.registerDataType(characterDataType2, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dataTypeRegistry.registerDataType(characterDataType3, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR);
            dataTypeRegistry.registerDataType(characterDataType4, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_NATIONAL_CHAR_VARYING);
            dataTypeRegistry.registerDataType(binaryDataType, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_BIT);
            dataTypeRegistry.registerDataType(binaryDataType2, SQLServerDatabaseImpl.class, JdbcDatabase.ANSI_BIT_VARYING);
            dataTypeRegistry.registerDataType(characterDataType5, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerDataType(characterDataType6, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerDataType(binaryDataType3, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerDataType(predefinedDataType4, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerDataType(predefinedDataType5, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerDataType(predefinedDataType8, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerDataType(predefinedDataType7, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("BINARY VARYING", (DataType)binaryDataType2, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("CHAR VARYING", (DataType)characterDataType2, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("CHARACTER", (DataType)characterDataType, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("CHARACTER VARYING", (DataType)characterDataType2, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("DEC", (DataType)numericDataType6, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("INTEGER", (DataType)numericDataType2, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NATIONAL CHAR", (DataType)characterDataType3, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NATIONAL CHARACTER", (DataType)characterDataType3, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NATIONAL CHAR VARYING", (DataType)characterDataType4, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NATIONAL CHARACTER VARYING", (DataType)characterDataType4, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("NATIONAL TEXT", (DataType)characterDataType6, SQLServerDatabaseImpl.class);
            dataTypeRegistry.registerSynonym("ROWVERSION", (DataType)predefinedDataType8, SQLServerDatabaseImpl.class);
        }

        Registerer() {
        }
    }
}

