/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaObjectManager {
    private static final DBObjectID[] EMPTY_ID;
    private DBObjectProvider m_provider;
    private boolean m_registeredAll;
    private final Map m_deps;
    private final Map m_soDeps;
    private final Map m_danglers;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = SchemaObjectManager.class.desiredAssertionStatus() ^ true;
        EMPTY_ID = new DBObjectID[0];
    }

    void $init$() {
        this.m_deps = new HashMap();
        this.m_soDeps = new HashMap();
        this.m_danglers = new HashMap();
    }

    public SchemaObjectManager(DBObjectProvider dBObjectProvider) {
        this.$init$();
        if (!$assertionsDisabled && dBObjectProvider == null) {
            throw new AssertionError();
        }
        this.m_provider = dBObjectProvider;
    }

    protected DBObjectProvider getProvider() {
        return this.m_provider;
    }

    protected void clearAllCaches() {
        this.m_registeredAll = false;
        this.m_deps.clear();
        this.m_soDeps.clear();
        this.m_danglers.clear();
    }

    protected boolean supportsUnresolvedReferences() {
        return false;
    }

    public boolean isUnresolvedReference(DBObjectID dBObjectID) {
        return false;
    }

    protected boolean resolvesUnresolvedReference(DBObjectID dBObjectID, DBObjectID dBObjectID2) {
        return false;
    }

    public void registerObject(SchemaObject schemaObject) {
        boolean bl;
        if (!this.m_registeredAll && this.supportsUnresolvedReferences()) {
            this.checkInit();
        }
        if (!(bl = this.m_registeredAll)) {
            boolean bl2 = bl = !(schemaObject instanceof AbstractSchemaObject && ((AbstractSchemaObject)schemaObject).needsInitialization() || !(schemaObject instanceof View) && !(schemaObject instanceof Synonym));
        }
        if (bl) {
            this.registerObject(schemaObject, schemaObject);
            if (this.supportsUnresolvedReferences()) {
                this.checkUnresolvedReferences(schemaObject);
            }
        }
    }

    public void unregisterObject(SchemaObject schemaObject) {
        if (this.m_registeredAll) {
            DBObjectID dBObjectID = schemaObject.getID();
            if (dBObjectID != null && this.supportsUnresolvedReferences()) {
                for (Map map : this.m_danglers.values()) {
                    if (!map.containsKey(dBObjectID)) continue;
                    Map map2 = (Map)map.remove(dBObjectID);
                }
            }
            this.unregisterImpl(schemaObject);
        }
    }

    public DBObjectID[] getSchemaObjectReferers(SchemaObject schemaObject, boolean bl) {
        this.checkInit();
        DBObjectID dBObjectID = schemaObject.getID();
        Collection collection = this.getSchemaObjectReferersImpl(dBObjectID, bl ? new HashSet() : null);
        if (collection != null && collection.size() > 0) {
            return collection.toArray(new DBObjectID[collection.size()]);
        }
        return EMPTY_ID;
    }

    public DBObjectID[] getReferers(DBObject dBObject) {
        Collection collection;
        this.checkInit();
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID != null && (collection = (Collection)this.m_deps.get(dBObjectID)) != null && collection.size() > 0) {
            return collection.toArray(new DBObjectID[collection.size()]);
        }
        return EMPTY_ID;
    }

    public boolean hasUnresolvedReference(SchemaObject schemaObject, String string) {
        DBObjectID dBObjectID;
        this.checkInit();
        Map map = (Map)this.m_danglers.get(string);
        if (map != null && (dBObjectID = schemaObject.getID()) != null) {
            return map.containsKey(dBObjectID);
        }
        return false;
    }

    private void checkUnresolvedReferences(SchemaObject schemaObject) {
        Map map = this.createDanglersTypeMap(schemaObject, null);
        for (String string : map.keySet()) {
            Map map2 = (Map)this.m_danglers.get(string);
            if (map2 == null) continue;
            for (Map.Entry entry : map2.entrySet()) {
                DBObjectID dBObjectID = (DBObjectID)entry.getKey();
                Map map3 = (Map)entry.getValue();
                for (Map.Entry entry2 : map3.entrySet()) {
                    DBObjectID dBObjectID2 = (DBObjectID)entry2.getKey();
                    try {
                        DBObject dBObject = dBObjectID2.resolveID();
                        if (dBObject == null) {
                            DBUtil.getLog().trace("SchemaObjectManager contains unresolvable ID " + dBObjectID2);
                            continue;
                        }
                        HashMap<DBObjectID, DBObjectID> hashMap = null;
                        Collection collection = (Collection)entry2.getValue();
                        if (collection != null) {
                            for (DBObjectID dBObjectID3 : collection) {
                                Collection collection2 = (Collection)map.get(string);
                                for (DBObject dBObject2 : collection2) {
                                    DBObjectID dBObjectID4 = dBObject2.getID();
                                    if (!this.resolvesUnresolvedReference(dBObjectID4, dBObjectID3)) continue;
                                    if (hashMap == null) {
                                        hashMap = new HashMap<DBObjectID, DBObjectID>();
                                    }
                                    hashMap.put(dBObjectID3, dBObjectID4);
                                    this.registerDependency((SchemaObject)dBObjectID.resolveID(), dBObject, dBObject2);
                                }
                            }
                        }
                        if (hashMap == null || hashMap.size() <= 0) continue;
                        this.replaceReferences(dBObject, (Map<DBObjectID, DBObjectID>)hashMap);
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private Map createDanglersTypeMap(DBObject dBObject, Map map) {
        Map map2 = map = map != null ? map : new HashMap();
        if (this.m_danglers.containsKey(dBObject.getType())) {
            this.mapKeyToCollection(dBObject.getType(), dBObject, map);
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            this.createDanglersTypeMap(dBObjectArray[n], map);
            ++n;
        }
        return map;
    }

    private void replaceReferences(DBObject dBObject, Map<DBObjectID, DBObjectID> map) {
        dBObject.replaceReferenceIDs(map);
        SchemaObject schemaObject = DBUtil.getSchemaObject(dBObject);
        DBObjectChange.fireObjectUpdated(schemaObject);
    }

    private void unregisterImpl(DBObject dBObject) {
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID != null) {
            DBObjectID[] dBObjectIDArray = dBObject.getReferenceIDs();
            int n = 0;
            while (n < dBObjectIDArray.length) {
                Collection collection;
                if (this.m_deps.containsKey(dBObjectIDArray[n]) && (collection = (Collection)this.m_deps.get(dBObjectIDArray[n])) != null) {
                    collection.remove(dBObjectID);
                    if (collection.size() < 1) {
                        this.m_deps.remove(dBObjectIDArray[n]);
                    }
                }
                ++n;
            }
            DBObject[] dBObjectArray = dBObject.getOwnedObjects();
            int n2 = 0;
            while (n2 < dBObjectArray.length) {
                this.unregisterImpl(dBObjectArray[n2]);
                ++n2;
            }
            if (dBObject instanceof SchemaObject) {
                Iterator iterator = this.m_soDeps.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Collection collection = (Collection)entry.getValue();
                    if (collection == null) continue;
                    collection.remove(dBObjectID);
                    if (collection.size() >= 1) continue;
                    iterator.remove();
                }
            }
        }
    }

    private void unregisterChildren(DBObject dBObject) {
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID != null) {
            if (this.m_deps.containsKey(dBObjectID)) {
                Collection collection = (Collection)this.m_deps.remove(dBObjectID);
            }
            DBObject[] dBObjectArray = dBObject.getOwnedObjects();
            int n = 0;
            while (n < dBObjectArray.length) {
                this.unregisterChildren(dBObjectArray[n]);
                ++n;
            }
        }
    }

    private Collection getSchemaObjectReferersImpl(DBObjectID dBObjectID, Collection collection) {
        Collection collection2;
        if (dBObjectID != null && (collection2 = (Collection)this.m_soDeps.get(dBObjectID)) != null && collection2.size() > 0) {
            if (collection == null) {
                collection = collection2;
            } else {
                for (DBObjectID dBObjectID2 : collection2) {
                    if (dBObjectID2 == null || collection.contains(dBObjectID2)) continue;
                    collection.add(dBObjectID2);
                    this.getSchemaObjectReferersImpl(dBObjectID2, collection);
                }
            }
        }
        return collection;
    }

    private void registerObject(SchemaObject schemaObject, DBObject dBObject) {
        DBObjectID[] dBObjectIDArray = dBObject.getReferenceIDs();
        int n = 0;
        while (n < dBObjectIDArray.length) {
            if (this.supportsUnresolvedReferences() && this.isUnresolvedReference(dBObjectIDArray[n])) {
                this.registerUnresolvedReference(schemaObject, dBObject, dBObjectIDArray[n]);
            } else {
                try {
                    DBObject dBObject2 = dBObjectIDArray[n].resolveID();
                    if (dBObject2 != null) {
                        this.registerDependency(schemaObject, dBObject, dBObject2);
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            ++n;
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n2 = 0;
        while (n2 < dBObjectArray.length) {
            this.registerObject(schemaObject, dBObjectArray[n2]);
            ++n2;
        }
    }

    private void registerSchemaObjectDependency(SchemaObject schemaObject, SchemaObject schemaObject2) {
        DBObjectID dBObjectID = schemaObject.getID();
        DBObjectID dBObjectID2 = schemaObject2.getID();
        this.addMapping(dBObjectID, dBObjectID2, this.m_soDeps);
    }

    private void registerDependency(SchemaObject schemaObject, DBObject dBObject, DBObject dBObject2) {
        DBObjectID dBObjectID = dBObject.getID();
        DBObjectID dBObjectID2 = dBObject2.getID();
        this.addMapping(dBObjectID, dBObjectID2, this.m_deps);
        SchemaObject schemaObject2 = DBUtil.getSchemaObject(dBObject2);
        if (schemaObject2 != null && schemaObject != null) {
            this.registerSchemaObjectDependency(schemaObject, schemaObject2);
        }
    }

    private void addMapping(DBObjectID dBObjectID, DBObjectID dBObjectID2, Map map) {
        if (dBObjectID2 != null && dBObjectID != null && !dBObjectID2.equals(dBObjectID)) {
            this.mapKeyToCollection(dBObjectID2, dBObjectID, map);
        }
    }

    private void mapKeyToCollection(Object object, Object object2, Map map) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(object, hashSet);
        }
        hashSet.add(object2);
    }

    private void registerUnresolvedReference(SchemaObject schemaObject, DBObject dBObject, DBObjectID dBObjectID) {
        HashSet<DBObjectID> hashSet;
        HashMap hashMap;
        DBObjectID dBObjectID2 = schemaObject.getID();
        DBObjectID dBObjectID3 = dBObject.getID();
        String string = dBObjectID.getType();
        HashMap hashMap2 = (HashMap)this.m_danglers.get(string);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            this.m_danglers.put(string, hashMap2);
        }
        if ((hashMap = (HashMap)hashMap2.get(dBObjectID2)) == null) {
            hashMap = new HashMap();
            hashMap2.put(dBObjectID2, hashMap);
        }
        if ((hashSet = (HashSet<DBObjectID>)hashMap.get(dBObjectID3)) == null) {
            hashSet = new HashSet<DBObjectID>();
            hashMap.put(dBObjectID3, hashSet);
        }
        if (!hashSet.contains(dBObjectID)) {
            hashSet.add(dBObjectID);
        }
    }

    public void cascadeDelete(SchemaObject schemaObject, SchemaObject schemaObject2) {
        DBObjectID dBObjectID;
        if (schemaObject2 instanceof View) {
            SQLQuery sQLQuery = ((View)schemaObject2).getSQLQuery();
            if (sQLQuery != null) {
                String string = sQLQuery.getSQLText();
                ((View)schemaObject2).setSQLQuery(new NonDeclarativeSQLQuery(string));
                ((View)schemaObject2).setColumns(null);
                DBObjectChange.fireObjectUpdated(schemaObject2);
            }
        } else if (schemaObject2 instanceof Table && schemaObject instanceof ComplexType) {
            Column[] columnArray = ((Relation)schemaObject2).getColumns();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            int n = 0;
            while (n < columnArray.length) {
                DBObjectID dBObjectID2 = columnArray[n].getDataTypeUsage().getDataTypeID();
                if (dBObjectID2 != null && dBObjectID2.equals(schemaObject.getID())) {
                    ((Relation)schemaObject2).removeColumn(columnArray[n]);
                    arrayList.add(columnArray[n]);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                DBObjectChange.fireChildrenRemoved(schemaObject2, arrayList);
            }
        } else if (schemaObject2 instanceof Synonym && (dBObjectID = ((Synonym)schemaObject2).getReference()) != null && dBObjectID.equals(schemaObject.getID())) {
            NameBasedRefID nameBasedRefID = new NameBasedRefID(schemaObject.getSchema(), schemaObject.getName());
            ((Synonym)schemaObject2).setReference(nameBasedRefID);
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(schemaObject2, "referenceID", dBObjectID, nameBasedRefID);
            DBObjectChange.firePropertyChanged(schemaObject2, propertyChangeEvent);
        }
    }

    private void checkInit() {
        if (!(this.m_provider instanceof Database) && !this.m_registeredAll) {
            this.registerAllObjects();
        }
    }

    private synchronized void registerAllObjects() {
        try {
            this.clearAllCaches();
            this.m_registeredAll = true;
            Schema[] schemaArray = this.m_provider.listSchemas();
            int n = 0;
            while (n < schemaArray.length) {
                String[] stringArray = this.m_provider.listObjectTypes();
                SchemaObject[] schemaObjectArray = this.m_provider.listObjects(stringArray, schemaArray[n]);
                int n2 = 0;
                while (n2 < schemaObjectArray.length) {
                    this.registerObject(schemaObjectArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
            this.m_registeredAll = false;
        }
    }

    public static final SchemaObject[] getDependencies(SchemaObject schemaObject, boolean bl) {
        HashSet<SchemaObject> hashSet = new HashSet<SchemaObject>();
        hashSet.add(schemaObject);
        SchemaObjectManager.addDependencies(hashSet, schemaObject, bl);
        hashSet.remove(schemaObject);
        return hashSet.toArray(new SchemaObject[hashSet.size()]);
    }

    private static final void addDependencies(Set set, DBObject dBObject, boolean bl) {
        DBObjectID[] dBObjectIDArray = dBObject.getReferenceIDs();
        int n = 0;
        while (n < dBObjectIDArray.length) {
            try {
                DBObject dBObject2 = dBObjectIDArray[n].resolveID();
                SchemaObject schemaObject = DBUtil.getSchemaObject(dBObject2);
                if (schemaObject != null && !set.contains(schemaObject)) {
                    set.add(schemaObject);
                    if (bl) {
                        SchemaObjectManager.addDependencies(set, schemaObject, bl);
                    }
                }
            }
            catch (DBException dBException) {
                DBUtil.getLog().trace("SchemaObjectManager: failed to resolve reference on " + DBUtil.getFullyQualifiedName(dBObject));
            }
            ++n;
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        int n2 = 0;
        while (n2 < dBObjectArray.length) {
            SchemaObjectManager.addDependencies(set, dBObjectArray[n2], bl);
            ++n2;
        }
    }
}

