/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecPlSql
extends PlSql {
    private List<PlSqlAttribute> _attribList;
    private List<PlSqlMethod> _methodList;
    private boolean _isFinal;
    private boolean _isInstantiable;
    private String _body;

    void $init$() {
        this._attribList = new ArrayList<PlSqlAttribute>();
        this._methodList = new ArrayList<PlSqlMethod>();
    }

    protected SpecPlSql() {
        this.$init$();
    }

    protected SpecPlSql(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    protected void copyToImpl(SpecPlSql specPlSql, boolean bl) {
        super.copyToImpl(specPlSql, bl);
        specPlSql._attribList.clear();
        for (PlSqlAttribute plSqlAttribute : this._attribList) {
            specPlSql.addAttribute((PlSqlAttribute)plSqlAttribute.copyTo(null, specPlSql, bl));
        }
        specPlSql._methodList.clear();
        for (PlSqlMethod plSqlMethod : this._methodList) {
            specPlSql.addMethod((PlSqlMethod)plSqlMethod.copyTo(null, specPlSql, bl));
        }
        specPlSql._body = this._body;
    }

    protected boolean equalsImpl(SpecPlSql specPlSql) {
        boolean bl = super.equalsImpl(specPlSql) && ModelUtil.areEqual(this._attribList, specPlSql._attribList) && ModelUtil.areEqual(this._methodList, specPlSql._methodList) && ModelUtil.areEqual((Object)this._body, (Object)specPlSql._body);
        return bl;
    }

    public void setAttributes(PlSqlAttribute[] plSqlAttributeArray) {
        this.checkInit();
        Iterator<PlSqlAttribute> iterator = this._attribList.iterator();
        while (iterator.hasNext()) {
            iterator.next().setSpecPlSql(null);
        }
        if (plSqlAttributeArray == null) {
            plSqlAttributeArray = new PlSqlAttribute[]{};
        }
        int n = plSqlAttributeArray.length;
        this._attribList = new ArrayList<PlSqlAttribute>(n);
        int n2 = 0;
        while (n2 < n) {
            plSqlAttributeArray[n2].setSpecPlSql(this);
            this._attribList.add(plSqlAttributeArray[n2]);
            ++n2;
        }
    }

    public PlSqlAttribute[] getAttributes() {
        this.checkInit();
        return this._attribList.toArray(new PlSqlAttribute[this._attribList.size()]);
    }

    public void addAttribute(PlSqlAttribute plSqlAttribute) {
        this.checkInit();
        if (!this._attribList.contains(plSqlAttribute)) {
            plSqlAttribute.setSpecPlSql(this);
            this._attribList.add(plSqlAttribute);
        }
    }

    public void addAttribute(int n, PlSqlAttribute plSqlAttribute) {
        this.checkInit();
        if (!this._attribList.contains(plSqlAttribute)) {
            plSqlAttribute.setSpecPlSql(this);
            this._attribList.add(n, plSqlAttribute);
        }
    }

    public PlSqlAttribute getAttribute(String string) {
        this.checkInit();
        if (string != null) {
            for (PlSqlAttribute plSqlAttribute : this._attribList) {
                if (!ModelUtil.areEqual((Object)plSqlAttribute.getName(), (Object)string)) continue;
                return plSqlAttribute;
            }
        }
        return null;
    }

    public void removeAttribute(PlSqlAttribute plSqlAttribute) {
        this.checkInit();
        if (this._attribList.contains(plSqlAttribute)) {
            this._attribList.remove(plSqlAttribute);
            plSqlAttribute.setSpecPlSql(null);
        }
    }

    public void setMethods(PlSqlMethod[] plSqlMethodArray) {
        this.checkInit();
        Iterator<PlSqlMethod> iterator = this._methodList.iterator();
        while (iterator.hasNext()) {
            iterator.next().setSpecPlSql(null);
        }
        if (plSqlMethodArray == null) {
            plSqlMethodArray = new PlSqlMethod[]{};
        }
        int n = plSqlMethodArray.length;
        this._methodList = new ArrayList<PlSqlMethod>(n);
        int n2 = 0;
        while (n2 < n) {
            plSqlMethodArray[n2].setSpecPlSql(this);
            this._methodList.add(plSqlMethodArray[n2]);
            ++n2;
        }
    }

    public PlSqlMethod[] getMethods() {
        this.checkInit();
        return this._methodList.toArray(new PlSqlMethod[this._methodList.size()]);
    }

    public void addMethod(PlSqlMethod plSqlMethod) {
        this.checkInit();
        if (!this._methodList.contains(plSqlMethod)) {
            plSqlMethod.setSpecPlSql(this);
            this._methodList.add(plSqlMethod);
        }
    }

    public void addMethod(int n, PlSqlMethod plSqlMethod) {
        this.checkInit();
        if (!this._methodList.contains(plSqlMethod)) {
            plSqlMethod.setSpecPlSql(this);
            this._methodList.add(n, plSqlMethod);
        }
    }

    public PlSqlMethod getMethod(String string) {
        this.checkInit();
        if (string != null) {
            for (PlSqlMethod plSqlMethod : this._methodList) {
                if (!ModelUtil.areEqual((Object)plSqlMethod.getName(), (Object)string)) continue;
                return plSqlMethod;
            }
        }
        return null;
    }

    public void removeMethod(PlSqlMethod plSqlMethod) {
        this.checkInit();
        if (this._methodList.contains(plSqlMethod)) {
            this._methodList.remove(plSqlMethod);
            plSqlMethod.setSpecPlSql(null);
        }
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("TypeAttribute", stringArray)) {
            collection.addAll(this._attribList);
        }
        if (this.includesType("TypeMethod", stringArray)) {
            collection.addAll(this._methodList);
        }
    }

    public String getBodySource() {
        this.checkInit();
        return this._body;
    }

    public void setBodySource(String string) {
        this.checkInit();
        this._body = string;
    }

    @Override
    public void setSource(String string) {
        super.setSource(string);
    }
}

