/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends Relation {
    public static final String TABLE_TYPE_KEY = "TableType";
    private List<Index> _indexes;
    public static final String TYPE = "TABLE";

    @Override
    void $init$() {
        this._indexes = new ArrayList<Index>();
    }

    public Table() {
        this.$init$();
    }

    public Table(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        Table table = dBObject != null ? (Table)dBObject : new Table();
        this.copyToImpl(table, bl);
        if (bl) {
            Map<DBObjectID, DBObjectID> map = DBUtil.getTemporaryIDMap(table.getOwnedObjects("COLUMN", "CONSTRAINT"));
            DBUtil.replaceReferenceIDs(table, map);
        }
        return table;
    }

    protected void copyToImpl(Table table, boolean bl) {
        super.copyToImpl(table, bl);
        Index[] indexArray = this.getIndexes();
        Index[] indexArray2 = new Index[indexArray.length];
        int n = 0;
        while (n < indexArray.length) {
            indexArray2[n] = (Index)indexArray[n].copyTo(null, table, bl);
            ++n;
        }
        table.setIndexes(indexArray2);
    }

    public boolean equals(Object object) {
        return object instanceof Table && this.equalsImpl((Table)object);
    }

    protected boolean equalsImpl(Table table) {
        return super.equalsImpl(table) && table._indexes.size() == this._indexes.size() && table._indexes.containsAll(this._indexes);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Index[] getIndexes() {
        this.checkInit("INDEX");
        return this._indexes.toArray(new Index[this._indexes.size()]);
    }

    public void setIndexes(Index[] indexArray) {
        this.checkInit("INDEX");
        Index[] indexArray2 = this.getIndexes();
        int n = 0;
        while (n < indexArray2.length) {
            indexArray2[n].setTable(null);
            ++n;
        }
        this._indexes.clear();
        if (indexArray == null) {
            indexArray = new Index[]{};
        }
        int n2 = indexArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.addIndex(indexArray[n3]);
            ++n3;
        }
    }

    public void addIndex(Index index) {
        this.checkInit("INDEX");
        if (!this._indexes.contains(index)) {
            index.setTable(this);
            this._indexes.add(index);
        }
    }

    public void removeIndex(Index index) {
        this.checkInit("INDEX");
        if (this._indexes.remove(index)) {
            index.setTable(null);
        }
    }

    public Index getIndex(String string) {
        this.checkInit("INDEX");
        Index index = null;
        Index[] indexArray = this.getIndexes();
        int n = indexArray.length - 1;
        while (n >= 0) {
            if (ModelUtil.areEqual((Object)string, (Object)indexArray[n].getName())) {
                index = indexArray[n];
                break;
            }
            --n;
        }
        return index;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.includesType("INDEX", stringArray)) {
            collection.addAll(this._indexes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TableType
    extends Enum {
        private static final /* synthetic */ TableType[] $v;
        public static final /* enum */ TableType NORMAL;
        public static final /* enum */ TableType TRANSACTION_TEMP;
        public static final /* enum */ TableType SESSION_TEMP;
        public static final /* enum */ TableType INDEX_ORGANIZED;
        public static final /* enum */ TableType EXTERNAL;

        public static TableType valueOf(String string) {
            return Enum.valueOf(TableType.class, string);
        }

        public static final TableType[] values() {
            return (TableType[])$v.clone();
        }

        static {
            TableType[] tableTypeArray = new TableType[5];
            tableTypeArray[4] = EXTERNAL = new TableType();
            tableTypeArray[3] = INDEX_ORGANIZED = new TableType();
            tableTypeArray[2] = SESSION_TEMP = new TableType();
            tableTypeArray[1] = TRANSACTION_TEMP = new TableType();
            tableTypeArray[0] = NORMAL = new TableType();
            $v = tableTypeArray;
        }
    }
}

