/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

public class Trigger
extends AbstractSchemaObject {
    public static final String TYPE = "TRIGGER";
    public static final int BEFORE_TIMING = 0;
    public static final int AFTER_TIMING = 1;
    public static final int TABLE_BASE_TYPE = 0;
    public static final int VIEW_BASE_TYPE = 1;
    public static final int SCHEMA_BASE_TYPE = 2;
    public static final int DATABASE_BASE_TYPE = 3;
    public static final String[] TRIGGER_TYPES = new String[]{"TABLE", "VIEW", "SCHEMA", "DATABASE"};
    public static final String INSERT_EVENT = "INSERT";
    public static final String DELETE_EVENT = "DELETE";
    public static final String UPDATE_EVENT = "UPDATE";
    public static final String ALTER_EVENT = "ALTER";
    public static final String ANALYZE_EVENT = "ANALYZE";
    public static final String ASSOCIATE_STATISTICS_EVENT = "ASSOCIATE STATISTICS";
    public static final String AUDIT_EVENT = "AUDIT";
    public static final String COMMENT_EVENT = "COMMENT";
    public static final String CREATE_EVENT = "CREATE";
    public static final String DISASSOCIATE_STATISTICS_EVENT = "DISASSOCIATE STATISTICS";
    public static final String DROP_EVENT = "DROP";
    public static final String GRANT_EVENT = "GRANT";
    public static final String NOAUDIT_EVENT = "NOAUDIT";
    public static final String RENAME_EVENT = "RENAME";
    public static final String REVOKE_EVENT = "REVOKE";
    public static final String TRUNCATE_EVENT = "TRUNCATE";
    public static final String DDL_EVENT = "DDL";
    public static final String SERVERERROR_EVENT = "SERVERERROR";
    public static final String LOGON_EVENT = "LOGON";
    public static final String LOGOFF_EVENT = "LOGOFF";
    public static final String STARTUP_EVENT = "STARTUP";
    public static final String SHUTDOWN_EVENT = "SHUTDOWN";
    public static final String SUSPEND_EVENT = "SUSPEND";
    private static final List TABLE_EVENTS = Collections.unmodifiableList(Arrays.asList("INSERT", "DELETE", "UPDATE"));
    private static final List BEFORE_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List BEFORE_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "SHUTDOWN", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "STARTUP", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final String[] REF_NAMES = new String[]{"OLD", "NEW"};
    private int _timing;
    private boolean _statementLevel;
    private List _events;
    private Schema _tableOwner;
    private String _table;
    private int _baseType;
    private String[] _refNames;
    private String _whenClause;
    private List _columns;
    private String _code;

    public static List getEvents(int n, int n2) {
        List list;
        switch (n2) {
            case 0: 
            case 1: {
                list = TABLE_EVENTS;
                break;
            }
            case 2: {
                list = n == 0 ? BEFORE_SCHEMA_EVENTS : AFTER_SCHEMA_EVENTS;
                break;
            }
            case 3: {
                list = n == 0 ? BEFORE_DB_EVENTS : AFTER_DB_EVENTS;
                break;
            }
            default: {
                list = Collections.EMPTY_LIST;
            }
        }
        return list;
    }

    void $init$() {
        this._events = new ArrayList();
        this._refNames = new String[2];
        this._columns = new ArrayList();
    }

    public Trigger() {
        this.$init$();
    }

    public Trigger(Schema schema, String string) {
        this.$init$();
        this.setSchema(schema);
        this.setName(string);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        Trigger trigger = dBObject != null ? (Trigger)dBObject : new Trigger();
        this.copyToImpl(trigger, bl);
        return trigger;
    }

    protected void copyToImpl(Trigger trigger, boolean bl) {
        super.copyToImpl(trigger, bl);
        trigger._timing = this._timing;
        trigger._statementLevel = this._statementLevel;
        trigger._events.clear();
        trigger._events.addAll(this._events);
        trigger._tableOwner = this._tableOwner;
        trigger._table = this._table;
        trigger._baseType = this._baseType;
        int n = 0;
        while (n < this._refNames.length) {
            trigger._refNames[n] = this._refNames[n];
            ++n;
        }
        trigger._whenClause = this._whenClause;
        trigger._columns.clear();
        trigger._columns.addAll(this._columns);
        trigger._code = this._code;
    }

    public boolean equals(Object object) {
        return object instanceof Trigger && this.equalsImpl((Trigger)object);
    }

    protected boolean equalsImpl(Trigger trigger) {
        return super.equalsImpl(trigger) && this._timing == trigger._timing && this._statementLevel == trigger._statementLevel && ModelUtil.areEqual((Object)this._events, (Object)trigger._events) && ModelUtil.areEqual((Object)this._tableOwner, (Object)trigger._tableOwner) && ModelUtil.areEqual((Object)this._table, (Object)trigger._table) && this._baseType == trigger._baseType && Arrays.equals(this._refNames, trigger._refNames) && ModelUtil.areEqual((Object)this._whenClause, (Object)trigger._whenClause) && ModelUtil.areEqual((Object)this._columns, (Object)trigger._columns) && ModelUtil.areEqual((Object)this._code, (Object)trigger._code);
    }

    public String getType() {
        return TYPE;
    }

    public int getTiming() {
        this.checkInit();
        return this._timing;
    }

    public void setTiming(int n) {
        this.checkInit();
        this._timing = n;
    }

    public boolean isStatementLevel() {
        this.checkInit();
        return this._statementLevel;
    }

    public void setStatementLevel(boolean bl) {
        this.checkInit();
        this._statementLevel = bl;
    }

    public List getEvents() {
        this.checkInit();
        return new ArrayList(this._events);
    }

    public void setEvents(List list) {
        this.checkInit();
        if (ModelUtil.areDifferent((Object)this._events, (Object)list)) {
            this._events.clear();
            this._events.addAll(list);
        }
    }

    public Schema getTableOwner() {
        this.checkInit();
        return this._tableOwner;
    }

    public void setTableOwner(Schema schema) {
        this.checkInit();
        this._tableOwner = schema;
    }

    public String getTableName() {
        this.checkInit();
        return this._table;
    }

    public void setTableName(String string) {
        this.checkInit();
        this._table = string;
    }

    public int getBaseType() {
        this.checkInit();
        return this._baseType;
    }

    public void setBaseType(int n) {
        this.checkInit();
        this._baseType = n;
    }

    public String[] getReferenceNames() {
        this.checkInit();
        String[] stringArray = new String[this._refNames.length];
        int n = 0;
        while (n < this._refNames.length) {
            stringArray[n] = this._refNames[n];
            ++n;
        }
        return stringArray;
    }

    public void setReferenceNames(String[] stringArray) {
        this.checkInit();
        if (!Arrays.equals(this._refNames, stringArray)) {
            int n = 0;
            while (n < stringArray.length) {
                this._refNames[n] = stringArray[n];
                ++n;
            }
        }
    }

    public String getWhenClause() {
        this.checkInit();
        return this._whenClause;
    }

    public void setWhenClause(String string) {
        this.checkInit();
        this._whenClause = string;
    }

    public List getColumns() {
        this.checkInit();
        return new ArrayList(this._columns);
    }

    public void setColumns(List list) {
        this.checkInit();
        if (ModelUtil.areDifferent((Object)this._columns, (Object)list)) {
            this._columns.clear();
            this._columns.addAll(list);
        }
    }

    public String getCode() {
        this.checkInit();
        return this._code;
    }

    public void setCode(String string) {
        this.checkInit();
        this._code = string;
    }
}

