/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends Relation
implements SQLQueryOwner {
    private SQLQuery m_query;
    private String m_restriction;
    private boolean m_force;
    public static final String TYPE = "VIEW";
    public static final String READ_ONLY = "WITH READ ONLY";
    public static final String CHECK_OPTION = "WITH CHECK OPTION";

    public View() {
    }

    public View(String string, Schema schema) {
        super(string, schema);
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        View view = dBObject != null ? (View)dBObject : new View();
        this.copyToImpl(view, bl);
        return view;
    }

    protected void copyToImpl(View view, boolean bl) {
        super.copyToImpl(view, bl);
        view.setSQLQuery(this.m_query == null ? null : (SQLQuery)this.m_query.copyTo(null, bl));
        view.setQueryRestriction(this.m_restriction);
        view.setForceOnCreate(this.m_force);
    }

    public boolean equals(Object object) {
        return object instanceof View && this.equalsImpl((View)object);
    }

    protected boolean equalsImpl(View view) {
        return super.equalsImpl(view) && this.m_force == view.m_force && ModelUtil.areEqual((Object)this.m_query, (Object)view.m_query) && ModelUtil.areEqual((Object)this.m_restriction, (Object)view.m_restriction);
    }

    public String getViewText() throws TransientMarker {
        this.checkInit("SQLQuery");
        if (this.m_query == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_query.getSQLText().trim());
        if (this.m_restriction != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.m_restriction);
        }
        return stringBuffer.toString();
    }

    public void setViewText(String string) {
        this.checkInit("SQLQuery");
        if (this.m_query == null) {
            this.m_query = new NonDeclarativeSQLQuery(string);
        }
    }

    @Override
    public SQLQuery getSQLQuery() {
        this.checkInit("SQLQuery");
        return this.m_query;
    }

    @Override
    public void setSQLQuery(SQLQuery sQLQuery) {
        this.checkInit("SQLQuery");
        if (this.m_query != null) {
            this.m_query.setParent(null);
        }
        this.m_query = sQLQuery;
        if (this.m_query != null) {
            this.m_query.setParent(this);
        }
    }

    public boolean isDeclarative() {
        this.checkInit("SQLQuery");
        return this.m_query != null && this.m_query instanceof DeclarativeSQLQuery;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (this.m_query != null && this.includesType("SQLQuery", stringArray)) {
            collection.add(this.m_query);
        }
    }

    public String getQueryRestriction() {
        return this.m_restriction;
    }

    public void setQueryRestriction(String string) {
        this.m_restriction = string;
    }

    public boolean isForceOnCreate() {
        return this.m_force;
    }

    public void setForceOnCreate(boolean bl) {
        this.m_force = bl;
    }
}

