/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewColumn
extends Column {
    private DBObjectID m_selectID;

    public ViewColumn() {
    }

    public ViewColumn(DBObjectID dBObjectID) {
        this.setSelectObjectID(dBObjectID);
    }

    public DBObjectID getSelectObjectID() {
        return this.m_selectID;
    }

    public void setSelectObjectID(DBObjectID dBObjectID) {
        this.m_selectID = dBObjectID;
    }

    private SelectObject getSelectObject() {
        if (this.m_selectID != null) {
            try {
                SelectObject selectObject = (SelectObject)this.m_selectID.resolveID();
                return selectObject;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getName() {
        String string = super.getName();
        if (string == null) {
            SelectObject selectObject = this.getSelectObject();
            string = selectObject == null ? null : selectObject.getName();
        }
        return string;
    }

    @Override
    public void setName(String string) {
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        if (this.m_selectID != null) {
            collection.add(this.m_selectID);
        }
    }

    @Override
    public DataTypeUsage getDataTypeUsage() {
        return null;
    }

    @Override
    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ViewColumn && this.equalsImpl((ViewColumn)object);
    }

    public boolean equalsImpl(ViewColumn viewColumn) {
        return super.equalsImpl(viewColumn) && ModelUtil.areEqual((Object)this.m_selectID, (Object)viewColumn.m_selectID);
    }

    @Override
    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        ViewColumn viewColumn = dBObject == null ? new ViewColumn() : (ViewColumn)dBObject;
        this.copyToImpl(viewColumn, bl);
        return viewColumn;
    }

    protected void copyToImpl(ViewColumn viewColumn, boolean bl) {
        super.copyToImpl(viewColumn, bl);
        viewColumn.m_selectID = this.m_selectID;
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> map) {
        if (this.m_selectID != null && map.containsKey(this.m_selectID)) {
            this.m_selectID = map.get(this.m_selectID);
            return true;
        }
        return super.replaceReferenceIDs(map);
    }
}

