/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

public class BaseDateTimeDataType
extends PredefinedDataType {
    private static final int ORACLE_FIRST_YEAR = -4712;
    private static final int ORACLE_LAST_YEAR = 9999;
    private static final List validStringTypes;
    private static final List validDateTimeFunctions;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = BaseDateTimeDataType.class.desiredAssertionStatus() ^ true;
        validStringTypes = new ArrayList<Integer>(Arrays.asList(new Integer(5), new Integer(17), new Integer(23)));
        validDateTimeFunctions = new ArrayList<Integer>(Arrays.asList(new Integer(37), new Integer(38), new Integer(45), new Integer(46), new Integer(47), new Integer(48), new Integer(49), new Integer(50), new Integer(51), new Integer(52), new Integer(53), new Integer(54), new Integer(55), new Integer(56), new Integer(57), new Integer(58), new Integer(59), new Integer(60), new Integer(61), new Integer(62), new Integer(63), new Integer(64), new Integer(65), new Integer(66), new Integer(67), new Integer(68), new Integer(69), new Integer(70), new Integer(71), new Integer(72), new Integer(75), new Integer(76), new Integer(94), new Integer(95), new Integer(277), new Integer(298), new Integer(374), new Integer(298), new Integer(169)));
    }

    public BaseDateTimeDataType() {
    }

    public BaseDateTimeDataType(int n, String string) {
        super(n, string);
    }

    public BaseDateTimeDataType(int n, String string, String string2, DataTypeAttribute[] dataTypeAttributeArray) {
        super(n, string, string2, dataTypeAttributeArray);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        BaseDateTimeDataType baseDateTimeDataType = dBObject != null ? (BaseDateTimeDataType)dBObject : new BaseDateTimeDataType();
        this.copyToImpl(baseDateTimeDataType, bl);
        return baseDateTimeDataType;
    }

    protected void copyToImpl(BaseDateTimeDataType baseDateTimeDataType, boolean bl) {
        super.copyToImpl(baseDateTimeDataType, bl);
    }

    public boolean equals(Object object) {
        return object instanceof BaseDateTimeDataType && this.equalsImpl((BaseDateTimeDataType)object);
    }

    protected boolean equalsImpl(BaseDateTimeDataType baseDateTimeDataType) {
        return super.equalsImpl(baseDateTimeDataType);
    }

    public String validateDateTime(Column column, SimpleDateFormat simpleDateFormat, String string) {
        String string2;
        String string3 = null;
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        if (globalSettings.getValidateDateTime() && ModelUtil.hasLength((String)(string2 = (String)column.getDefault()))) {
            string3 = this.isQuoted(column) ? this.validateUsingFormat(column, simpleDateFormat, string) : this.validateDateExpr(column);
        }
        return string3;
    }

    private String validateDateExpr(Column column) {
        String string = null;
        String string2 = null;
        String string3 = (String)column.getDefault();
        PlsqlNode plsqlNode = null;
        try {
            PlsqlRoot plsqlRoot = ParserUtils.parseQueryString(string3, 2);
            if (!$assertionsDisabled && plsqlRoot.getUnits().length != 1) {
                throw new AssertionError((Object)("Expecting 1 parse unit but got " + plsqlRoot.getUnits().length));
            }
            plsqlNode = plsqlRoot.getUnits()[0];
            ParserUtils.checkErrors(plsqlRoot, string3);
        }
        catch (SQLQueryException sQLQueryException) {
            string = DBArb.format(139, sQLQueryException.getMessage());
        }
        if (!ParserUtils.isAllowedStringType(plsqlNode, validStringTypes) && !ParserUtils.isAllowedExpression(plsqlNode, validDateTimeFunctions)) {
            string = DBArb.format(139, string3);
        }
        if (string != null) {
            string2 = DBArb.format(143, this.getErrorMessageContext(column), string);
        }
        return string2;
    }

    private String validateUsingFormat(Column column, SimpleDateFormat simpleDateFormat, String string) {
        String string2 = (String)column.getDefault();
        String string3 = null;
        HashMap hashMap = new HashMap();
        String string4 = this.stripSpacesAndSeperators(string2, hashMap);
        boolean bl = true;
        int n = 0;
        String string5 = "";
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string4, parsePosition);
        if (date == null || parsePosition.getIndex() != string4.length()) {
            bl = false;
            n = parsePosition.getErrorIndex();
            if (-1 == n) {
                n = parsePosition.getIndex();
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n2 = calendar.get(1);
            if (n2 < -4712 || n2 > 9999) {
                bl = false;
                string5 = DBArb.format(144, Integer.toString(n2));
            }
        }
        if (!bl) {
            String string6 = "";
            if (hashMap.containsKey(new Integer(n))) {
                int n3 = (Integer)hashMap.get(new Integer(n));
                string6 = DBArb.format(145, string2.substring(n3));
            } else {
                string6 = "ran out of input characters";
            }
            string3 = DBArb.format(142, new Object[]{this.getErrorMessageContext(column), string6, string5, string});
        }
        return string3;
    }

    private String getErrorMessageContext(Column column) {
        String string = (String)column.getDefault();
        String string2 = "";
        try {
            string2 = DataTypeHelper.getDataType(column.getDataTypeUsage()).getName();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        String string3 = DBArb.format(141, new Object[]{column.getParent().getName(), column.getName(), string2, string});
        return string3;
    }

    private boolean isQuoted(Column column) {
        boolean bl = true;
        String string = (String)column.getDefault();
        String string2 = string.trim();
        if (string2.length() < 3 || !string2.startsWith("'") || !string2.endsWith("'")) {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private String stripSpacesAndSeperators(String var1_1, HashMap var2_2) {
        var3_3 = new StringBuffer();
        var4_4 = var1_1.toCharArray();
        var5_5 = 0;
        var6_6 = 0;
        ** GOTO lbl20
        {
            ++var5_5;
            do {
                if (var5_5 < var4_4.length && Character.isWhitespace(var4_4[var5_5])) continue block0;
                if (var4_4.length == var5_5) break block0;
                if (!Character.isLetterOrDigit(var4_4[var5_5])) {
                    ++var5_5;
                }
                while (var5_5 < var4_4.length && Character.isWhitespace(var4_4[var5_5])) {
                    ++var5_5;
                }
                if (var4_4.length == var5_5) break block0;
                var3_3.append(var4_4[var5_5]);
                var2_2.put(new Integer(var6_6++), new Integer(var5_5++));
lbl20:
                // 2 sources

            } while (var5_5 < var4_4.length);
        }
        var7_7 = var3_3.toString();
        return var7_7;
    }
}

