/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.util.ModelUtil;

public class DataTypeAttribute
extends AbstractDBObject {
    public static final String TYPE = "DatatypeAttribute";
    public static final String DATATYPE_NAME = "name";
    public static final String DATATYPE_SIZE = "size";
    public static final String DATATYPE_PRECISION = "precision";
    public static final String DATATYPE_SCALE = "scale";
    public static final String DATATYPE_UNSIGNED = "unsigned";
    public static final int DATATYPE_CHAR = 0;
    public static final int DATATYPE_LONG = 1;
    private final int NOLABEL;
    private int m_labelIndex;
    private int m_valueType;
    private String[] m_values;
    private Long m_minValue;
    private Long m_maxValue;
    private Object m_defaultValue;
    private boolean m_isExtensible;
    private boolean m_isMandatory;
    private boolean m_isDeclarable;

    public DataTypeAttribute() {
        this.$init$();
    }

    public DataTypeAttribute(String string, long l, long l2) {
        super(string);
        this.$init$();
        this.m_valueType = 1;
        this.m_minValue = new Long(l);
        this.m_maxValue = new Long(l2);
    }

    public DataTypeAttribute(String string, int n, long l, Long l2, Long l3, boolean bl) {
        super(string);
        this.$init$();
        this.m_valueType = 1;
        this.m_labelIndex = n;
        this.m_minValue = new Long(l);
        this.m_maxValue = l2;
        this.m_defaultValue = l3;
        this.m_isMandatory = bl;
        this.m_isDeclarable = true;
    }

    public DataTypeAttribute(String string, int n, String string2, boolean bl) {
        super(string);
        this.$init$();
        this.m_valueType = 0;
        this.m_labelIndex = n;
        this.m_defaultValue = string2;
        this.m_isMandatory = bl;
        this.m_isDeclarable = true;
        this.m_isExtensible = true;
        this.m_values = null;
    }

    public DataTypeAttribute(String string, int n, String[] stringArray, String string2, boolean bl, boolean bl2) {
        super(string);
        this.$init$();
        this.m_valueType = 0;
        this.m_labelIndex = n;
        this.m_defaultValue = string2;
        this.m_isExtensible = bl;
        this.m_isMandatory = bl2;
        this.m_values = stringArray;
        this.m_isDeclarable = true;
    }

    public int getValueType() {
        return this.m_valueType;
    }

    public String getLabel() {
        return this.m_labelIndex == -1 ? this.getName() : DBArb.getString(this.m_labelIndex);
    }

    public Long getMinValue() {
        return this.m_minValue;
    }

    public Long getMaxValue() {
        return this.m_maxValue;
    }

    public String[] getValues() {
        return this.m_values;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isDeclarable() {
        return this.m_isDeclarable;
    }

    public boolean isMandatory() {
        return this.m_isMandatory;
    }

    public boolean isExtensible() {
        return this.m_isExtensible;
    }

    public final DBObject getParent() {
        return null;
    }

    public final String getType() {
        return TYPE;
    }

    public boolean equals(Object object) {
        return object instanceof DataTypeAttribute && this.equalsImpl((DataTypeAttribute)object);
    }

    protected boolean equalsImpl(DataTypeAttribute dataTypeAttribute) {
        return dataTypeAttribute.m_labelIndex == this.m_labelIndex && dataTypeAttribute.m_valueType == this.m_valueType && dataTypeAttribute.m_isExtensible == this.m_isExtensible && dataTypeAttribute.m_isDeclarable == this.m_isDeclarable && dataTypeAttribute.m_isMandatory == this.m_isMandatory && ModelUtil.areEqual((Object)this.m_minValue, (Object)dataTypeAttribute.m_minValue) && ModelUtil.areEqual((Object)this.m_maxValue, (Object)dataTypeAttribute.m_maxValue) && ModelUtil.areEqual((Object)this.m_defaultValue, (Object)dataTypeAttribute.m_defaultValue) && ModelUtil.areEqual((Object)this.m_values, (Object)dataTypeAttribute.m_values);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        DataTypeAttribute dataTypeAttribute = dBObject != null ? (DataTypeAttribute)dBObject : new DataTypeAttribute();
        this.copyToImpl(dataTypeAttribute, bl);
        return dataTypeAttribute;
    }

    protected void copyToImpl(DataTypeAttribute dataTypeAttribute, boolean bl) {
        super.copyToImpl(dataTypeAttribute, bl);
        dataTypeAttribute.m_labelIndex = this.m_labelIndex;
        dataTypeAttribute.m_valueType = this.m_valueType;
        dataTypeAttribute.m_isExtensible = this.m_isExtensible;
        dataTypeAttribute.m_isMandatory = this.m_isMandatory;
        dataTypeAttribute.m_isDeclarable = this.m_isDeclarable;
        dataTypeAttribute.m_minValue = this.m_minValue;
        dataTypeAttribute.m_maxValue = this.m_maxValue;
        dataTypeAttribute.m_defaultValue = this.m_defaultValue;
        dataTypeAttribute.m_values = this.m_values;
    }

    void $init$() {
        this.NOLABEL = -1;
        this.m_labelIndex = -1;
        this.m_isExtensible = false;
        this.m_isMandatory = false;
        this.m_isDeclarable = false;
    }
}

