/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class DataTypeHelper {
    public static DataType getDataType(DataTypeUsage dataTypeUsage) throws DBException {
        if (dataTypeUsage != null) {
            DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
            if (dBObjectID == null) {
                throw new DBException(null, "Column's DataTypeID is not resolvable");
            }
            return (DataType)dBObjectID.resolveID();
        }
        return null;
    }

    public static Long getLongAttributeValue(DataTypeUsage dataTypeUsage, String string) {
        return DataTypeHelper.toLong(dataTypeUsage.getAttributeValue(string));
    }

    public static String getStringAttributeValue(DataTypeUsage dataTypeUsage, String string) {
        return DataTypeHelper.toString(dataTypeUsage.getAttributeValue(string));
    }

    public static String getStringAttributeDefaultValue(DataTypeUsage dataTypeUsage, String string) {
        String string2 = null;
        try {
            Object object;
            DataType dataType = DataTypeHelper.getDataType(dataTypeUsage);
            DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute(string);
            if (dataTypeAttribute != null && (object = dataTypeAttribute.getDefaultValue()) != null) {
                string2 = object.toString();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return string2;
    }

    public static Long toLong(Object object) {
        try {
            String string = object == null ? null : ModelUtil.nullifyIfEmpty((String)object.toString());
            Long l = string == null ? null : Long.valueOf(string);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String toString(Object object) {
        return object == null ? null : object.toString();
    }

    public static String getNameFromLabel(int n) {
        return DBArb.getString(n).replaceAll("&", "");
    }

    public static String getNameFromLabel(String string) {
        return string.replaceAll("&", "");
    }

    public static Object getAttributeValue(Object object, DataType dataType, String string) {
        DataTypeAttribute dataTypeAttribute;
        if (object != null && (dataTypeAttribute = dataType.getDataTypeAttribute(string)) != null) {
            if (dataTypeAttribute.getValueType() == 0) {
                return DataTypeHelper.toString(object);
            }
            return DataTypeHelper.toLong(object);
        }
        return object;
    }
}

