/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.util.ModelUtil;

public final class DataTypeID
implements DBObjectID {
    private String m_typeName;
    private String m_schemaName;
    private Class m_providerClass;

    public DataTypeID() {
    }

    DataTypeID(String string, Class clazz) {
        this.m_typeName = string;
        this.m_providerClass = clazz;
    }

    DataTypeID(String string, String string2, Class clazz) {
        this.m_schemaName = string2;
        this.m_typeName = string;
        this.m_providerClass = clazz;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String string) {
        this.m_typeName = string;
    }

    public Class getProviderClass() {
        return this.m_providerClass;
    }

    public void setProviderClass(Class clazz) {
        this.m_providerClass = clazz;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public boolean equals(DBObjectID dBObjectID) {
        return this.equals(dBObjectID, true);
    }

    public boolean equals(DBObjectID dBObjectID, boolean bl) {
        return dBObjectID instanceof DataTypeID && this.equalsImpl((DataTypeID)dBObjectID);
    }

    protected boolean equalsImpl(DataTypeID dataTypeID) {
        return ModelUtil.areEqual((Object)this.m_typeName, (Object)dataTypeID.m_typeName) && ModelUtil.areEqual((Object)this.m_schemaName, (Object)dataTypeID.m_schemaName) && ModelUtil.areEqual((Object)this.m_providerClass, (Object)dataTypeID.m_providerClass);
    }

    public String getType() {
        return null;
    }

    public DBObject resolveID() throws DBException {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        DataType dataType = null;
        dataType = this.m_schemaName != null ? dataTypeRegistry.findComplexType(this.m_typeName, this.m_schemaName, this.m_providerClass) : dataTypeRegistry.findDataType(this.m_typeName, this.m_providerClass);
        if (dataType == null) {
            DBUtil.getLog().trace("DataTypeID: DataType " + this.m_typeName + " not found in provider " + this.m_providerClass == null ? null : this.m_providerClass.getName());
            dataType = dataTypeRegistry.createUserDataType(this.m_typeName, this.m_providerClass);
        }
        return dataType;
    }

    public DBObjectID getParent() {
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof DBObjectID && this.equals((DBObjectID)object);
    }

    public String toString() {
        return this.m_providerClass + "." + this.m_typeName;
    }
}

