/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;

public final class DataTypeRegistry {
    private final Map<Class, Object> m_complexTypes;
    private final Map<Class, Object> m_dataTypes;
    private final Map<DataType, DataType> m_ansiMap;
    private Map<String, DataType> m_ansiTypes;
    private final Map<DataType, DataType> m_synonyms;
    private final Map<Class, Object> m_registered;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static DataTypeRegistry s_instance;

    void $init$() {
        this.m_complexTypes = new HashMap<Class, Object>();
        this.m_dataTypes = new HashMap<Class, Object>();
        this.m_ansiMap = new HashMap<DataType, DataType>();
        this.m_synonyms = new HashMap<DataType, DataType>();
        this.m_registered = new HashMap<Class, Object>();
    }

    private DataTypeRegistry() {
        this.$init$();
    }

    private Map getDataTypesImpl(Class clazz) {
        Object object = this.m_dataTypes.get(clazz);
        if (object instanceof Registerer) {
            this.m_dataTypes.remove(clazz);
            ((Registerer)object).registerDataTypes(this);
            this.m_registered.put(clazz, object);
            object = this.m_dataTypes.get(clazz);
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    private Map getComplexTypesImpl(Class clazz) {
        Object object = this.m_complexTypes.get(clazz);
        if (object instanceof Registerer) {
            this.m_complexTypes.remove(clazz);
            ((Registerer)object).registerComplexTypes(this);
            this.m_registered.put(clazz, object);
            object = this.m_complexTypes.get(clazz);
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        return null;
    }

    public void registerProvider(Registerer registerer, Class clazz) {
        this.m_dataTypes.put(clazz, registerer);
        this.m_complexTypes.put(clazz, registerer);
    }

    public void registerDataType(DataType dataType, Class clazz) {
        this.registerDataType(dataType, clazz, null);
    }

    static {
        $assertionsDisabled = DataTypeRegistry.class.desiredAssertionStatus() ^ true;
    }

    public void registerDataType(DataType dataType, Class clazz, DataType dataType2) {
        Object object = this.m_dataTypes.get(clazz);
        if (object instanceof Registerer) {
            throw new IllegalArgumentException("Cannot register datatypes for this provider - it has a Registerer for that purpose.");
        }
        HashMap<String, DataType> hashMap = (HashMap<String, DataType>)object;
        if (hashMap == null) {
            hashMap = new HashMap<String, DataType>();
            this.m_dataTypes.put(clazz, hashMap);
        }
        String string = dataType.getName().toUpperCase();
        if (!$assertionsDisabled && hashMap.containsKey(string)) {
            throw new AssertionError();
        }
        hashMap.put(string, dataType);
        dataType.setID(new DataTypeID(string, clazz));
        if (dataType2 != null) {
            this.mapToAnsiType(dataType, dataType2);
        }
    }

    public void registerComplexType(ComplexType complexType, Class clazz) {
        HashMap<String, ComplexType> hashMap;
        Schema schema = complexType.getSchema();
        if (!$assertionsDisabled && schema == null) {
            throw new AssertionError();
        }
        String string = schema.getName();
        Object object = this.m_complexTypes.get(clazz);
        if (object instanceof Registerer) {
            throw new IllegalArgumentException("Cannot register datatypes for this provider - it has a Registerer for that purpose.");
        }
        HashMap hashMap2 = (HashMap)object;
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            this.m_complexTypes.put(clazz, hashMap2);
        }
        if ((hashMap = (HashMap<String, ComplexType>)hashMap2.get(string)) == null) {
            hashMap = new HashMap<String, ComplexType>();
            hashMap2.put(string, hashMap);
        }
        String string2 = complexType.getName().toUpperCase();
        if (!$assertionsDisabled && hashMap.containsKey(string2)) {
            throw new AssertionError();
        }
        hashMap.put(string2, complexType);
        complexType.setID(new DataTypeID(string2, string, clazz));
    }

    public DataType createUserDataType(String string, Class clazz) {
        PredefinedDataType predefinedDataType = new PredefinedDataType(0, string);
        this.registerDataType(predefinedDataType, clazz);
        return predefinedDataType;
    }

    public DataType findDataType(String string, Class clazz) {
        if (clazz == JdbcDatabase.class) {
            return this.findAnsiType(string);
        }
        return this.findDataType(string, clazz, true);
    }

    private DataType findDataType(String string, Class clazz, boolean bl) {
        for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            DataType dataType;
            Map map = this.getDataTypesImpl(clazz2);
            if (map != null && (dataType = (DataType)map.get(string.toUpperCase())) != null) {
                return dataType;
            }
            if (bl) {
                continue;
            }
            clazz2 = null;
            break;
        }
        return null;
    }

    public ComplexType findComplexType(String string, String string2, Class clazz) {
        for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            ComplexType complexType;
            Map map;
            Map map2 = this.getComplexTypesImpl(clazz2);
            if (map2 != null && (map = (Map)map2.get(string2)) != null && (complexType = (ComplexType)map.get(string.toUpperCase())) != null) {
                return complexType;
            }
            Registerer registerer = (Registerer)this.m_registered.get(clazz2);
            if (registerer != null && registerer.includeSuperclassComplexTypes()) {
                continue;
            }
            clazz2 = null;
            break;
        }
        return null;
    }

    public DataType[] listDataTypes(Class clazz) {
        return this.listDataTypes(clazz, true);
    }

    private DataType[] listDataTypes(Class clazz, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Map map = this.getDataTypesImpl(clazz2);
            if (map != null) {
                arrayList.addAll(map.values());
            }
            if (bl) {
                continue;
            }
            clazz2 = null;
            break;
        }
        return arrayList.toArray(new DataType[arrayList.size()]);
    }

    public ComplexType[] listComplexTypes(String string, Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Registerer registerer;
            Map map;
            Map map2 = this.getComplexTypesImpl(clazz2);
            if (map2 != null && (map = (Map)map2.get(string)) != null) {
                arrayList.addAll(map.values());
            }
            if ((registerer = (Registerer)this.m_registered.get(clazz2)) != null && registerer.includeSuperclassComplexTypes()) {
                continue;
            }
            clazz2 = null;
            break;
        }
        return arrayList.toArray(new ComplexType[arrayList.size()]);
    }

    public String[] listComplexTypeSchemas(Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            Registerer registerer;
            Map map = this.getComplexTypesImpl(clazz2);
            if (map != null) {
                arrayList.addAll(map.keySet());
            }
            if ((registerer = (Registerer)this.m_registered.get(clazz2)) != null && registerer.includeSuperclassComplexTypes()) {
                continue;
            }
            clazz2 = null;
            break;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isRegisteredType(DataType dataType) {
        return dataType.getID() instanceof DataTypeID;
    }

    public DataType registerSynonym(String string, DataType dataType, Class clazz) {
        DataTypeSynonym dataTypeSynonym = new DataTypeSynonym(string, dataType);
        this.registerSynonym(dataTypeSynonym, dataType, clazz);
        return dataTypeSynonym;
    }

    public void registerSynonym(DataType dataType, DataType dataType2, Class clazz) {
        this.registerDataType(dataType, clazz);
        this.m_synonyms.put(dataType, dataType2);
    }

    public boolean isSynonymType(DataType dataType) {
        return this.m_synonyms.containsKey(dataType);
    }

    public DataType getBaseType(DataType dataType) {
        return this.m_synonyms.get(dataType);
    }

    private void registerAnsiType(DataType dataType) {
        dataType.setID(new DataTypeID(dataType.getName(), JdbcDatabase.class));
        this.m_ansiTypes.put(dataType.getName(), dataType);
    }

    public DataType findAnsiType(String string) {
        this.initAnsiTypes();
        return this.m_ansiTypes.get(string.toUpperCase());
    }

    public DataType[] getAnsiTypes() {
        this.initAnsiTypes();
        Collection<DataType> collection = this.m_ansiTypes.values();
        return collection.toArray(new DataType[collection.size()]);
    }

    public void mapToAnsiType(DataType dataType, String string) {
        DataType dataType2 = this.findAnsiType(string);
        if (!$assertionsDisabled && dataType2 == null) {
            throw new AssertionError();
        }
        this.m_ansiMap.put(dataType, dataType2);
    }

    public void mapToAnsiType(DataType dataType, DataType dataType2) {
        this.initAnsiTypes();
        if (!($assertionsDisabled || dataType2 != null && this.m_ansiTypes.containsKey(dataType2.getName()))) {
            throw new AssertionError();
        }
        this.m_ansiMap.put(dataType, dataType2);
    }

    public DataType getMappedAnsiType(DataType dataType) {
        return this.m_ansiMap.get(dataType);
    }

    public DataType getMappedType(String string, Class clazz) {
        return this.getMappedType(string, clazz, true);
    }

    private DataType getMappedType(String string, Class clazz, boolean bl) {
        while (clazz != null && !clazz.equals(Object.class)) {
            Map map = (Map)this.m_dataTypes.get(clazz);
            if (map != null) {
                Collection collection = map.values();
                for (DataType dataType : collection) {
                    DataType dataType2 = this.m_ansiMap.get(dataType);
                    if (dataType2 == null || !dataType2.getName().equals(string)) continue;
                    return dataType;
                }
            }
            if (!bl) break;
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private void initAnsiTypes() {
        if (this.m_ansiTypes == null) {
            this.m_ansiTypes = new HashMap<String, DataType>();
            this.registerAnsiType(JdbcDatabase.ANSI_BIT);
            this.registerAnsiType(JdbcDatabase.ANSI_BIT_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_CHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_CHAR_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_CHAR_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_CHARACTER);
            this.registerAnsiType(JdbcDatabase.ANSI_CHARACTER_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_CHARACTER_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_CLOB);
            this.registerAnsiType(JdbcDatabase.ANSI_VARCHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHAR_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHARACTER);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHARACTER_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHARACTER_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_NCHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_NCHAR_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_NCHAR_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_NCLOB);
            this.registerAnsiType(JdbcDatabase.ANSI_BINARY_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_BLOB);
            this.registerAnsiType(JdbcDatabase.ANSI_DATE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIME);
            this.registerAnsiType(JdbcDatabase.ANSI_TIME_WITH_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIME_WITHOUT_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIMESTAMP);
            this.registerAnsiType(JdbcDatabase.ANSI_TIMESTAMP_WITH_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIMESTAMP_WITHOUT_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_BIGINT);
            this.registerAnsiType(JdbcDatabase.ANSI_DEC);
            this.registerAnsiType(JdbcDatabase.ANSI_DECIMAL);
            this.registerAnsiType(JdbcDatabase.ANSI_DOUBLE_PRECISION);
            this.registerAnsiType(JdbcDatabase.ANSI_FLOAT);
            this.registerAnsiType(JdbcDatabase.ANSI_INT);
            this.registerAnsiType(JdbcDatabase.ANSI_INTEGER);
            this.registerAnsiType(JdbcDatabase.ANSI_NUMERIC);
            this.registerAnsiType(JdbcDatabase.ANSI_REAL);
            this.registerAnsiType(JdbcDatabase.ANSI_SMALLINT);
            this.registerAnsiType(JdbcDatabase.ANSI_BOOLEAN);
            this.registerAnsiType(JdbcDatabase.ANSI_INTERVAL);
            this.registerAnsiType(JdbcDatabase.ANSI_REF);
            this.registerAnsiType(JdbcDatabase.ANSI_ROW);
        }
    }

    public static DataTypeRegistry getInstance() {
        if (s_instance == null) {
            s_instance = new DataTypeRegistry();
            DBObjectProviderFactory.uncacheProvider(null);
        }
        return s_instance;
    }

    public static class Registerer {
        protected void registerDataTypes(DataTypeRegistry dataTypeRegistry) {
        }

        protected void registerComplexTypes(DataTypeRegistry dataTypeRegistry) {
        }

        protected boolean includeSuperclassTypes() {
            return true;
        }

        protected boolean includeSuperclassComplexTypes() {
            return true;
        }
    }
}

