/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

public class NumericDataType
extends PredefinedDataType {
    public static final DataTypeAttribute UNSIGNED = new DataTypeAttribute("unsigned", 105, new String[]{"UNSIGNED"}, null, false, false);
    public static final MinMaxValue MIN_MAX_BIGINT = new MinMaxValue("-9223372036854775808", "9223372036854775807", 0);
    public static final MinMaxValue MIN_MAX_INT = new MinMaxValue("-2147483648", "2147483647", 0);
    public static final MinMaxValue MIN_MAX_MEDIUMINT = new MinMaxValue("-8388608", "8388607", 0);
    public static final MinMaxValue MIN_MAX_SMALLINT = new MinMaxValue("-32768", "32767", 0);
    public static final MinMaxValue MIN_MAX_SIGNED_TINYINT = new MinMaxValue("-128", "127", 0);
    public static final MinMaxValue MIN_MAX_UNSIGNED_TINYINT = new MinMaxValue("0", "255", 1);
    public static final MinMaxValue MIN_MAX_MONEY = new MinMaxValue("-922337203685477.5808", "922337203685477.5807", 0);
    public static final MinMaxValue MIN_MAX_SMALLMONEY = new MinMaxValue("-214748.3648", "214748.3647", 0);
    public static final MinMaxValue MIN_MAX_BIT = new MinMaxValue("0", "1", 1);
    private static final BigDecimal DECIMAL_0 = new BigDecimal("0");
    private static final BigDecimal DECIMAL_1 = new BigDecimal("1");
    private static final BigDecimal DECIMAL_2 = new BigDecimal("2");
    private int m_valueType;
    private BigDecimal m_minIntValue;
    private BigDecimal m_maxIntValue;
    private BigDecimal m_maxUnsignedValue;
    private BigDecimal m_minNegativeValue;
    private BigDecimal m_maxNegativeValue;
    private BigDecimal m_minPositiveValue;
    private BigDecimal m_maxPositiveValue;

    public NumericDataType() {
        this.$init$();
    }

    public NumericDataType(int n, String string, MinMaxValue minMaxValue) {
        super(n, string);
        this.$init$();
        this.setMinMaxValues(minMaxValue);
    }

    public NumericDataType(int n, String string, String string2, DataTypeAttribute[] dataTypeAttributeArray, MinMaxValue minMaxValue) {
        super(n, string, string2, dataTypeAttributeArray);
        this.$init$();
        this.setMinMaxValues(minMaxValue);
    }

    public NumericDataType(int n, String string, String string2, long l, long l2, Long l3, boolean bl, DataTypeAttribute[] dataTypeAttributeArray, MinMaxValue minMaxValue) {
        super(n, string, string2, dataTypeAttributeArray);
        this.$init$();
        this.setMinMaxValues(minMaxValue);
        this.addAttribute(new DataTypeAttribute("precision", 93, l, new Long(l2), l3, bl), 0);
    }

    public NumericDataType(int n, String string, String string2, long l, long l2, Long l3, boolean bl, long l4, Long l5, Long l6, boolean bl2, DataTypeAttribute[] dataTypeAttributeArray, MinMaxValue minMaxValue) {
        super(n, string, string2, dataTypeAttributeArray);
        this.$init$();
        this.setMinMaxValues(minMaxValue);
        this.addAttribute(new DataTypeAttribute("precision", 93, l, new Long(l2), l3, bl), 0);
        this.addAttribute(new DataTypeAttribute("scale", 94, l4, l5, l6, bl2), 1);
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        NumericDataType numericDataType = dBObject != null ? (NumericDataType)dBObject : new NumericDataType();
        this.copyToImpl(numericDataType, bl);
        return numericDataType;
    }

    protected void copyToImpl(NumericDataType numericDataType, boolean bl) {
        super.copyToImpl(numericDataType, bl);
        numericDataType.m_valueType = this.m_valueType;
        numericDataType.m_minIntValue = this.m_minIntValue;
        numericDataType.m_maxIntValue = this.m_maxIntValue;
        numericDataType.m_maxUnsignedValue = this.m_maxUnsignedValue;
        numericDataType.m_minPositiveValue = this.m_minPositiveValue;
        numericDataType.m_minNegativeValue = this.m_minNegativeValue;
        numericDataType.m_maxPositiveValue = this.m_maxPositiveValue;
        numericDataType.m_maxNegativeValue = this.m_maxNegativeValue;
    }

    public boolean equals(Object object) {
        return object instanceof NumericDataType && this.equalsImpl((NumericDataType)object);
    }

    protected boolean equalsImpl(NumericDataType numericDataType) {
        return super.equalsImpl(numericDataType) && this.m_valueType == numericDataType.m_valueType && ModelUtil.areEqual((Object)this.m_minIntValue, (Object)numericDataType.m_minIntValue) && ModelUtil.areEqual((Object)this.m_maxIntValue, (Object)numericDataType.m_maxIntValue) && ModelUtil.areEqual((Object)this.m_minPositiveValue, (Object)numericDataType.m_minPositiveValue) && ModelUtil.areEqual((Object)this.m_maxPositiveValue, (Object)numericDataType.m_maxPositiveValue);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dBObject);
        DataTypeAttribute dataTypeAttribute = this.getDataTypeAttribute("precision");
        DataTypeAttribute dataTypeAttribute2 = this.getDataTypeAttribute("scale");
        if (dataTypeAttribute != null && dataTypeAttribute2 != null && dataTypeAttribute2.isDeclarable() && dataTypeUsage.hasAttributeValue("scale")) {
            Long l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "precision");
            if (l == null) {
                l = (Long)dataTypeAttribute.getDefaultValue();
            }
            if (dataTypeAttribute2.getMaxValue() == null) {
                if (l == null) {
                    throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(123, dataTypeAttribute2.getMinValue()));
                }
                Long l2 = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
                if (l2 != null && l2.compareTo(l) > 0) {
                    throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(124, l));
                }
            }
        }
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
        super.validateDefaultValue(object, dataTypeUsage, dBObject);
        if (dataTypeUsage != null && object != null) {
            String string = object.toString().trim();
            PlsqlNode plsqlNode = null;
            try {
                PlsqlRoot plsqlRoot = ParserUtils.parseQueryString(string, 2);
                if (plsqlRoot.getUnits().length != 1) {
                    DBUtil.getLog().trace("Expecting 1 parse unit but got " + plsqlRoot.getUnits().length);
                    return;
                }
                plsqlNode = plsqlRoot.getUnits()[0];
                ParserUtils.checkErrors(plsqlRoot, string);
            }
            catch (SQLQueryException sQLQueryException) {
                throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.format(139, sQLQueryException.getMessage()));
            }
            if (ParserUtils.isConstant(plsqlNode)) {
                Long l;
                BigDecimal bigDecimal = null;
                try {
                    bigDecimal = new BigDecimal(ParserUtils.getConstant(plsqlNode));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.getString(140));
                }
                DataTypeAttribute dataTypeAttribute = this.getDataTypeAttribute("precision");
                DataTypeAttribute dataTypeAttribute2 = this.getDataTypeAttribute("scale");
                Long l2 = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "precision");
                if (l2 == null && dataTypeAttribute != null) {
                    l2 = (Long)dataTypeAttribute.getDefaultValue();
                }
                if ((l = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale")) == null && dataTypeAttribute2 != null) {
                    l = (Long)dataTypeAttribute2.getDefaultValue();
                }
                if (l2 != null && l != null) {
                    int n = bigDecimal.scale();
                    BigInteger bigInteger = bigDecimal.abs().unscaledValue();
                    String string2 = bigInteger.toString();
                    int n2 = string2.length();
                    int n3 = 0;
                    while (n2 > 0 && n3 < n) {
                        if (string2.charAt(n2 - 1) != '0') break;
                        --n2;
                        ++n3;
                    }
                    if (n == 0) {
                        n = n2 - string2.length();
                    }
                    if (l.intValue() >= 0) {
                        if (n > l.intValue()) {
                            throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.format(134, new Long(n), l));
                        }
                    } else if (n > 0) {
                        throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.getString(137));
                    }
                    if (n2 - n > l2.intValue() - l.intValue()) {
                        throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.format(133, string, l2, l));
                    }
                } else {
                    boolean bl;
                    boolean bl2 = false;
                    boolean bl3 = bl = dataTypeUsage.getAttributeValue("unsigned") != null;
                    if (this.m_valueType == 2) {
                        if (bigDecimal.compareTo(DECIMAL_0) == 0 || (this.m_minPositiveValue == null || bigDecimal.compareTo(this.m_minPositiveValue) >= 0) && (this.m_maxPositiveValue == null || bigDecimal.compareTo(this.m_maxPositiveValue) <= 0)) {
                            bl2 = true;
                        }
                        if (!(bl || this.m_minNegativeValue != null && bigDecimal.compareTo(this.m_minNegativeValue) < 0 || this.m_maxNegativeValue != null && bigDecimal.compareTo(this.m_maxNegativeValue) > 0)) {
                            bl2 = true;
                        }
                    } else if (this.m_valueType == 0) {
                        BigDecimal bigDecimal2;
                        BigDecimal bigDecimal3 = bl ? DECIMAL_0 : this.m_minIntValue;
                        BigDecimal bigDecimal4 = bigDecimal2 = bl ? this.m_maxUnsignedValue : this.m_maxIntValue;
                        if (!(bigDecimal3 != null && bigDecimal.compareTo(bigDecimal3) < 0 || bigDecimal2 != null && bigDecimal.compareTo(bigDecimal2) > 0)) {
                            bl2 = true;
                        }
                    } else if (this.m_valueType == 1) {
                        if (!(this.m_minIntValue != null && bigDecimal.compareTo(this.m_minIntValue) < 0 || this.m_maxIntValue != null && bigDecimal.compareTo(this.m_maxIntValue) > 0)) {
                            bl2 = true;
                        }
                    } else {
                        DBUtil.getLog().trace("Min Max range not defined for " + this.getName());
                        bl2 = true;
                    }
                    if (!bl2) {
                        throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.format(136, string));
                    }
                }
            }
        }
    }

    private void setMinMaxValues(MinMaxValue minMaxValue) {
        if (minMaxValue != null) {
            this.m_valueType = minMaxValue.getValueType();
            if (this.m_valueType == 2) {
                this.m_minPositiveValue = minMaxValue.getMinValue();
                this.m_maxPositiveValue = minMaxValue.getMaxValue();
                this.m_minNegativeValue = minMaxValue.getMaxValue().negate();
                this.m_maxNegativeValue = minMaxValue.getMinValue().negate();
            } else {
                this.m_minIntValue = minMaxValue.getMinValue();
                this.m_maxIntValue = minMaxValue.getMaxValue();
                if (this.m_valueType == 0 && this.m_maxIntValue != null) {
                    this.m_maxUnsignedValue = this.m_maxIntValue.multiply(DECIMAL_2).add(DECIMAL_1);
                }
            }
        }
    }

    void $init$() {
        this.m_valueType = -1;
    }

    public static class MinMaxValue {
        public static final int SIGNED_INT = 0;
        public static final int UNSIGNED_INT = 1;
        public static final int FLOAT = 2;
        static final /* synthetic */ boolean $assertionsDisabled;
        private BigDecimal m_minValue;
        private BigDecimal m_maxValue;
        private int m_valueType;

        static {
            $assertionsDisabled = MinMaxValue.class.desiredAssertionStatus() ^ true;
        }

        public MinMaxValue() {
            this.$init$();
        }

        public MinMaxValue(String string, String string2, int n) {
            this.$init$();
            this.m_minValue = new BigDecimal(string);
            this.m_maxValue = new BigDecimal(string2);
            this.m_valueType = n;
            if (!$assertionsDisabled && this.m_valueType != 2 && this.m_valueType != 0 && this.m_valueType != 1) {
                throw new AssertionError();
            }
        }

        public BigDecimal getMinValue() {
            return this.m_minValue;
        }

        public BigDecimal getMaxValue() {
            return this.m_maxValue;
        }

        public int getValueType() {
            return this.m_valueType;
        }

        void $init$() {
            this.m_valueType = -1;
        }
    }
}

