/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.plsql.ObjectTypeDeclarator;
import oracle.javatools.db.plsql.PlSqlDeclarator;

public class ObjectType
extends SpecPlSql
implements ComplexType {
    public static final String BODY_TYPE = "TYPE BODY";
    private boolean _isFinal;
    private boolean _isInstantiable;
    private String _typeCode;

    void $init$() {
        this._typeCode = "OBJECT";
    }

    public ObjectType() {
        this.$init$();
    }

    public ObjectType(String string, Schema schema) {
        super(string, schema);
        this.$init$();
    }

    public String getType() {
        return "TYPE";
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        ObjectType objectType = dBObject != null ? (ObjectType)dBObject : new ObjectType();
        this.copyToImpl(objectType, bl);
        return objectType;
    }

    public boolean equals(Object object) {
        return object instanceof ObjectType && this.equalsImpl((ObjectType)object);
    }

    protected void copyToImpl(ObjectType objectType, boolean bl) {
        super.copyToImpl(objectType, bl);
        objectType._typeCode = this._typeCode;
        objectType._isFinal = this._isFinal;
        objectType._isInstantiable = this._isInstantiable;
    }

    protected boolean equalsImpl(ObjectType objectType) {
        return super.equalsImpl(objectType) && this._typeCode == objectType._typeCode && this._isFinal == objectType._isFinal && this._isInstantiable == objectType._isInstantiable;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public void setFinal(boolean bl) {
        this.checkInit();
        this._isFinal = bl;
    }

    public boolean isInstantiable() {
        return this._isInstantiable;
    }

    public void setInstantiable(boolean bl) {
        this.checkInit();
        this._isInstantiable = bl;
    }

    public PlSqlDeclarator getDeclarator(DBObjectProvider dBObjectProvider) {
        return new ObjectTypeDeclarator(dBObjectProvider);
    }

    public String getTypeCode() {
        return this._typeCode;
    }

    public void setTypeCode(String string) {
        if (!"OBJECT".equals(string) && !"COLLECTION".equals(string)) {
            throw new IllegalArgumentException("ObjectType: Invalid typecode " + string);
        }
        this._typeCode = string;
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        StringBuffer stringBuffer = new StringBuffer();
        Schema schema = this.getSchema();
        if (schema != null) {
            stringBuffer.append(schema.getName()).append(".");
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public DataTypeAttribute[] getDataTypeAttributes() {
        return null;
    }

    public boolean hasDataTypeAttribute(String string) {
        return false;
    }

    public DataTypeAttribute getDataTypeAttribute(String string) {
        return null;
    }

    public DataTypeUsage createDefaultUsage() {
        return new ObjectTypeUsage(this);
    }

    public DataTypeUsage createUsage(Map map) {
        return new ObjectTypeUsage(this);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
    }
}

