/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.util.ModelUtil;

public class PredefinedDataType
extends AbstractDBObject
implements DataType {
    static final /* synthetic */ boolean $assertionsDisabled;
    private int m_domain;
    private List m_attributes;
    private String m_definition;
    private String[] m_tokenizedDefinition;
    private int w_index;
    private int w_valueIndex;
    private String w_dataType;

    public PredefinedDataType() {
        this.$init$();
    }

    public PredefinedDataType(int n, String string) {
        super(string);
        this.$init$();
        this.m_domain = n;
        this.m_definition = string;
    }

    public PredefinedDataType(int n, String string, String string2, DataTypeAttribute[] dataTypeAttributeArray) {
        super(string);
        this.$init$();
        this.m_domain = n;
        this.m_definition = string2;
        if (dataTypeAttributeArray != null) {
            int n2 = 0;
            while (n2 < dataTypeAttributeArray.length) {
                this.m_attributes.add(dataTypeAttributeArray[n2]);
                ++n2;
            }
        }
    }

    public PredefinedDataType(int n, String string, String string2, long l, long l2, long l3, boolean bl, DataTypeAttribute[] dataTypeAttributeArray) {
        super(string);
        this.$init$();
        this.m_domain = n;
        this.m_definition = string2;
        this.m_attributes.add(new DataTypeAttribute("size", 92, l, new Long(l2), new Long(l3), bl));
        if (dataTypeAttributeArray != null) {
            int n2 = 0;
            while (n2 < dataTypeAttributeArray.length) {
                this.m_attributes.add(dataTypeAttributeArray[n2]);
                ++n2;
            }
        }
    }

    public void addAttribute(DataTypeAttribute dataTypeAttribute, int n) {
        this.m_attributes.add(n, dataTypeAttribute);
    }

    public void removeAttribute(DataTypeAttribute dataTypeAttribute) {
        this.m_attributes.remove(this.m_attributes.indexOf(dataTypeAttribute));
    }

    public DataTypeUsage createDefaultUsage() {
        PredefinedDataTypeUsage predefinedDataTypeUsage = new PredefinedDataTypeUsage(this);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        while (n < this.m_attributes.size()) {
            DataTypeAttribute dataTypeAttribute = (DataTypeAttribute)this.m_attributes.get(n);
            if (dataTypeAttribute.isMandatory()) {
                hashMap.put(dataTypeAttribute.getName(), dataTypeAttribute.getDefaultValue());
            }
            ++n;
        }
        if (hashMap.size() > 0) {
            predefinedDataTypeUsage.setAttributeValues(hashMap);
        }
        return predefinedDataTypeUsage;
    }

    static {
        $assertionsDisabled = PredefinedDataType.class.desiredAssertionStatus() ^ true;
    }

    public DataTypeUsage createUsage(Map map) {
        if (!$assertionsDisabled && map == null) {
            throw new AssertionError();
        }
        PredefinedDataTypeUsage predefinedDataTypeUsage = new PredefinedDataTypeUsage(this);
        HashMap hashMap = new HashMap();
        for (String string : map.keySet()) {
            DataTypeAttribute dataTypeAttribute = this.getDataTypeAttribute(string);
            if (dataTypeAttribute == null || !dataTypeAttribute.isDeclarable()) continue;
            hashMap.put(string, map.get(string));
        }
        String string = (String)map.get("name");
        if (string != null) {
            this.addAttributeValues(hashMap, string);
        }
        predefinedDataTypeUsage.setAttributeValues(hashMap);
        return predefinedDataTypeUsage;
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
        Map map = dataTypeUsage.getAttributeValues();
        int n = 0;
        while (n < this.m_attributes.size()) {
            DataTypeAttribute dataTypeAttribute = (DataTypeAttribute)this.m_attributes.get(n);
            Object v = map.get(dataTypeAttribute.getName());
            if (dataTypeAttribute.isMandatory() && v == null) {
                throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(119, DataTypeHelper.getNameFromLabel(dataTypeAttribute.getLabel())));
            }
            if (dataTypeAttribute.isDeclarable()) {
                if (dataTypeAttribute.getValueType() == 0) {
                    String string = DataTypeHelper.toString(v);
                    String[] stringArray = dataTypeAttribute.getValues();
                    if (string != null && stringArray != null && !dataTypeAttribute.isExtensible()) {
                        boolean bl = false;
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            if (stringArray[n2].compareToIgnoreCase(string) == 0) {
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!bl) {
                            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(120, string, DataTypeHelper.getNameFromLabel(dataTypeAttribute.getLabel())));
                        }
                    }
                } else {
                    Long l = DataTypeHelper.toLong(v);
                    Long l2 = dataTypeAttribute.getMinValue();
                    Long l3 = dataTypeAttribute.getMaxValue();
                    if (l != null) {
                        if (l.compareTo(l2) < 0) {
                            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(121, DataTypeHelper.getNameFromLabel(dataTypeAttribute.getLabel()), l2));
                        }
                        if (l3 != null && l.compareTo(l3) > 0) {
                            throw new DataTypeValidationException(dBObject, this.getName(), DBArb.format(122, DataTypeHelper.getNameFromLabel(dataTypeAttribute.getLabel()), l3));
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
        String string;
        Collection collection;
        if (dataTypeUsage != null && object != null && (collection = ParserUtils.getColumnNames(string = ((String)object).trim())).size() > 0) {
            throw new DefaultValueValidationException(dBObject, this.getName(), DBArb.format(135, collection.toArray()));
        }
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        Map map = dataTypeUsage.getAttributeValues();
        String string = "";
        this.w_index = 0;
        while (this.w_index < this.m_definition.length()) {
            string = string + this.getDDL(map, false);
            ++this.w_index;
        }
        return string;
    }

    public final boolean hasDataTypeAttribute(String string) {
        return this.getDataTypeAttribute(string) != null;
    }

    public final DataTypeAttribute getDataTypeAttribute(String string) {
        int n = 0;
        while (n < this.m_attributes.size()) {
            if (((DataTypeAttribute)this.m_attributes.get(n)).getName().equalsIgnoreCase(string)) {
                return (DataTypeAttribute)this.m_attributes.get(n);
            }
            ++n;
        }
        return null;
    }

    public final DataTypeAttribute[] getDataTypeAttributes() {
        return this.m_attributes.size() == 0 ? null : this.m_attributes.toArray(new DataTypeAttribute[this.m_attributes.size()]);
    }

    public final DBObject getParent() {
        return null;
    }

    public final String getType() {
        return "DATATYPE";
    }

    public DBObject copyTo(DBObject dBObject, DBObject dBObject2, boolean bl) {
        PredefinedDataType predefinedDataType = dBObject != null ? (PredefinedDataType)dBObject : new PredefinedDataType();
        this.copyToImpl(predefinedDataType, bl);
        return predefinedDataType;
    }

    protected void copyToImpl(PredefinedDataType predefinedDataType, boolean bl) {
        super.copyToImpl(predefinedDataType, bl);
        predefinedDataType.m_attributes = new ArrayList();
        ModelUtil.deepCopy((List)this.m_attributes, (List)predefinedDataType.m_attributes);
        predefinedDataType.m_definition = this.m_definition;
        predefinedDataType.m_domain = this.m_domain;
    }

    public boolean equals(Object object) {
        return object instanceof PredefinedDataType && this.equalsImpl((PredefinedDataType)object);
    }

    protected boolean equalsImpl(PredefinedDataType predefinedDataType) {
        return super.equalsImpl(predefinedDataType) && ModelUtil.areEqual((Object)this.m_attributes, (Object)predefinedDataType.m_attributes) && ModelUtil.areEqual((Object)this.m_definition, (Object)predefinedDataType.m_definition) && this.m_domain == predefinedDataType.m_domain;
    }

    private String getDDL(Map map, boolean bl) {
        String string = "";
        while (this.w_index < this.m_definition.length() && this.m_definition.charAt(this.w_index) != ']') {
            char c = this.m_definition.charAt(this.w_index);
            if (c == '[') {
                string = string + this.getOptionalDDL(map);
            } else if (c == '<') {
                String string2 = "";
                while (++this.w_index < this.m_definition.length() && this.m_definition.charAt(this.w_index) != '>') {
                    string2 = string2 + this.m_definition.charAt(this.w_index);
                }
                Object v = map.get(string2);
                if (bl && v == null) {
                    return "";
                }
                if (!bl && v == null && !$assertionsDisabled) {
                    throw new AssertionError();
                }
                string = string + v.toString();
            } else {
                string = string + c;
            }
            ++this.w_index;
        }
        return string;
    }

    private String getOptionalDDL(Map map) {
        ++this.w_index;
        String string = this.getDDL(map, true);
        if (string.length() == 0) {
            while (this.w_index < this.m_definition.length() && this.m_definition.charAt(this.w_index) != ']') {
                if (this.m_definition.charAt(this.w_index) == '[') {
                    this.getOptionalDDL(map);
                }
                ++this.w_index;
            }
        }
        return string;
    }

    public void validateDefinition() {
        int n = 0;
        while (n < this.m_definition.length()) {
            char c = this.m_definition.charAt(n);
            if (c == '[') {
                n = this.findChar(']', n + 1);
            } else if (c == '<') {
                n = this.validateAttributeName(n);
            }
            ++n;
        }
    }

    private int findChar(char c, int n) {
        while (n < this.m_definition.length()) {
            char c2 = this.m_definition.charAt(n);
            if (!$assertionsDisabled && c == '>' && c2 == '<') {
                throw new AssertionError((Object)"Invalid nested attributes");
            }
            if (c2 == '[') {
                n = this.findChar(']', n + 1);
            } else if (c2 == '<') {
                n = this.validateAttributeName(n);
            } else if (c2 == c) {
                return n;
            }
            ++n;
        }
        return n;
    }

    private int validateAttributeName(int n) {
        int n2 = n + 1;
        n = this.findChar('>', n2);
        String string = this.m_definition.substring(n2, n);
        if (!$assertionsDisabled && this.getDataTypeAttribute(string) == null) {
            throw new AssertionError((Object)("Attribute <" + string + "> not defined for data type" + this.m_definition));
        }
        return n;
    }

    private void addAttributeValues(Map map, String string) {
        if (this.m_tokenizedDefinition == null) {
            this.m_tokenizedDefinition = PredefinedDataType.tokenize(this.m_definition, "[]( ),");
        }
        this.w_dataType = string;
        String[] stringArray = PredefinedDataType.tokenize(string, "( ),");
        this.w_index = 0;
        this.w_valueIndex = 0;
        while (this.w_index < this.m_tokenizedDefinition.length && this.w_valueIndex < stringArray.length) {
            this.addAttributeValues(map, stringArray, false);
            ++this.w_index;
        }
    }

    private void addOptionalAttributeValue(Map map, String[] stringArray) {
        ++this.w_index;
        if (!this.addAttributeValues(map, stringArray, true)) {
            int n = 1;
            do {
                if (this.m_tokenizedDefinition[this.w_index].equals("[")) {
                    ++n;
                    continue;
                }
                if (!this.m_tokenizedDefinition[this.w_index].equals("]")) continue;
                --n;
            } while (n > 0 && ++this.w_index < this.m_tokenizedDefinition.length);
        }
    }

    private boolean addAttributeValues(Map map, String[] stringArray, boolean bl) {
        while (this.w_valueIndex < stringArray.length && this.w_index < this.m_tokenizedDefinition.length && !this.m_tokenizedDefinition[this.w_index].equals("]")) {
            if (this.m_tokenizedDefinition[this.w_index].equals("[")) {
                this.addOptionalAttributeValue(map, stringArray);
            } else if (this.m_tokenizedDefinition[this.w_index].charAt(0) == '<') {
                String string = this.m_tokenizedDefinition[this.w_index].substring(1, this.m_tokenizedDefinition[this.w_index].length() - 1);
                int n = this.getDataTypeAttribute(string).getValueType();
                if (n == 1) {
                    try {
                        map.put(string, Long.valueOf(stringArray[this.w_valueIndex]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        DBUtil.getLog().trace("Can't match \"" + stringArray[this.w_valueIndex] + "\" in \"" + this.w_dataType + "\" with definition : " + this.m_definition);
                    }
                } else {
                    String string2 = stringArray[this.w_valueIndex];
                    if (this.getDataTypeAttribute(string).getValues() != null) {
                        int n2;
                        String[] stringArray2 = this.getDataTypeAttribute(string).getValues();
                        while ((n2 = this.isValidValue(string2, stringArray2)) == -1 && ++this.w_valueIndex < stringArray.length) {
                            string2 = string2 + stringArray[this.w_valueIndex];
                        }
                        if (this.w_valueIndex < stringArray.length) {
                            map.put(string, stringArray2[n2]);
                        } else {
                            DBUtil.getLog().trace("Data type \"" + this.w_dataType + "\" doesn't match its definition : " + this.m_definition);
                        }
                    }
                }
                ++this.w_valueIndex;
            } else {
                if (bl) {
                    if (this.m_tokenizedDefinition[this.w_index].compareToIgnoreCase(stringArray[this.w_valueIndex]) != 0) {
                        return false;
                    }
                } else if (!$assertionsDisabled && this.m_tokenizedDefinition[this.w_index].compareToIgnoreCase(stringArray[this.w_valueIndex]) != 0) {
                    throw new AssertionError((Object)("Data type \"" + this.w_dataType + "\" doesn't match its definition : " + this.m_definition));
                }
                ++this.w_valueIndex;
            }
            ++this.w_index;
        }
        return true;
    }

    private int isValidValue(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].replaceAll("\\s", "").compareToIgnoreCase(string) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected static String[] tokenize(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll("\\s", " "), string2, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.charAt(0) == ' ') continue;
            arrayList.add(string3);
            ++n;
        }
        return arrayList.toArray(new String[n]);
    }

    void $init$() {
        this.m_attributes = new ArrayList();
    }
}

