/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2UniversalDatabaseImpl;
import oracle.javatools.db.mysql.MySQLDatabaseDescriptor;

public class DB2UniversalDatabaseFactory
extends DatabaseFactory {
    private DatabaseDescriptor m_descriptor;

    public DB2UniversalDatabaseFactory() {
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        dataTypeRegistry.registerProvider(new DB2UniversalDatabaseImpl.Registerer(), DB2UniversalDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String string, Connection connection) {
        if (this.isDB2UniversalConnection(connection)) {
            return new DB2UniversalDatabaseImpl(string, connection);
        }
        return null;
    }

    protected boolean isDB2UniversalConnection(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                if (string.indexOf("DB2") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        if (DB2UniversalDatabase.class.isAssignableFrom(clazz)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new MySQLDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

