/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class DataTypeUsageDiffer
implements Differ {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = DataTypeUsageDiffer.class.desiredAssertionStatus() ^ true;
    }

    public boolean diff(Object object, Object object2, ResultSet resultSet, DiffContext diffContext) {
        if (!$assertionsDisabled && object == null && object2 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && object != null && !(object instanceof DataTypeUsage)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && object2 != null && !(object2 instanceof DataTypeUsage)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !"MAP".equals(resultSet.getType())) {
            throw new AssertionError();
        }
        DataTypeUsage dataTypeUsage = (DataTypeUsage)object;
        DataTypeUsage dataTypeUsage2 = (DataTypeUsage)object2;
        String string = null;
        String string2 = null;
        try {
            if (dataTypeUsage != null) {
                string = DataTypeHelper.getDataType(dataTypeUsage).getDDL(dataTypeUsage);
                resultSet.setAVal(string);
            }
            if (dataTypeUsage2 != null) {
                string2 = DataTypeHelper.getDataType(dataTypeUsage2).getDDL(dataTypeUsage2);
                resultSet.setBVal(string2);
            }
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        Comparator comparator = diffContext.getEngine().getComparator(DataTypeUsage.class);
        boolean bl = true;
        bl &= this.diffDatatypeName(dataTypeUsage, dataTypeUsage2, resultSet);
        resultSet.setSame(bl &= this.diffDatatypeAttr(dataTypeUsage, dataTypeUsage2, resultSet));
        if (!bl) {
            for (ResultSet resultSet2 : resultSet.getAllObjectsMap().values()) {
                resultSet2.setSame(false);
            }
        }
        return true;
    }

    protected boolean diffDatatypeName(DataTypeUsage dataTypeUsage, DataTypeUsage dataTypeUsage2, ResultSet resultSet) {
        boolean bl = false;
        String string = null;
        String string2 = this.getDataTypeName(dataTypeUsage);
        String string3 = this.getDataTypeBaseName(dataTypeUsage);
        String string4 = this.getDataTypeName(dataTypeUsage2);
        String string5 = this.getDataTypeBaseName(dataTypeUsage2);
        if (dataTypeUsage2 != null) {
            string = string4;
            if (dataTypeUsage != null) {
                bl = string3.equals(string5);
            }
        } else {
            bl = false;
            string = string2;
        }
        new ResultSet(resultSet, bl, (Object)dataTypeUsage, dataTypeUsage2, "Datatype", string2, string4);
        return bl;
    }

    protected String getDataTypeName(DataTypeUsage dataTypeUsage) {
        String string = null;
        try {
            if (dataTypeUsage != null) {
                DBObject dBObject = dataTypeUsage.getDataTypeID().resolveID();
                string = dBObject instanceof SchemaObject ? ((SchemaObject)dBObject).getSchema().getName() + "." + dBObject.getName() : dBObject.getName();
            }
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        return string;
    }

    private boolean diffDatatypeAttr(DataTypeUsage dataTypeUsage, DataTypeUsage dataTypeUsage2, ResultSet resultSet) {
        boolean bl = true;
        DataType dataType = null;
        DataType dataType2 = null;
        try {
            if (dataTypeUsage != null) {
                DBObject dBObject = dataTypeUsage.getDataTypeID().resolveID();
                if (!$assertionsDisabled && !(dBObject instanceof DataType)) {
                    throw new AssertionError();
                }
                dataType = (DataType)dBObject;
            }
            if (dataTypeUsage2 != null) {
                DBObject dBObject = dataTypeUsage2.getDataTypeID().resolveID();
                if (!$assertionsDisabled && !(dBObject instanceof DataType)) {
                    throw new AssertionError();
                }
                dataType2 = (DataType)dBObject;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        Map map = null;
        Map map2 = dataTypeUsage2 == null ? null : dataTypeUsage2.getAttributeValues();
        HashMap hashMap = map2 == null ? null : new HashMap(map2);
        ArrayList arrayList = new ArrayList();
        if (dataTypeUsage != null && dataTypeUsage.getAttributeValues() != null) {
            map = dataTypeUsage.getAttributeValues();
            for (String string : map.keySet()) {
                Object object = this.getValueOrDefault(dataType, dataTypeUsage, string);
                Object object2 = null;
                String string2 = DataTypeHelper.getStringAttributeValue(dataTypeUsage, string);
                if (dataType2.hasDataTypeAttribute(string) || object == null) {
                    object2 = this.getValueOrDefault(dataType2, dataTypeUsage2, string);
                    String string3 = DataTypeHelper.getStringAttributeValue(dataTypeUsage2, string);
                    if (ModelUtil.areEqual((Object)object, (Object)object2) || object2 == null && this.isSynonym(dataTypeUsage2)) {
                        new ResultSet(resultSet, true, (Object)dataTypeUsage, dataTypeUsage2, string, string2, string3);
                    } else {
                        new ResultSet(resultSet, false, (Object)dataTypeUsage, dataTypeUsage2, string, string2, string3);
                        bl = false;
                    }
                    hashMap.remove(string);
                    continue;
                }
                boolean bl2 = this.isSynonym(dataTypeUsage2);
                new ResultSet(resultSet, bl2, (Object)dataTypeUsage, dataTypeUsage2, string, string2, null);
                bl &= bl2;
            }
        }
        if (hashMap != null) {
            for (String string : hashMap.keySet()) {
                String string4 = DataTypeHelper.getStringAttributeValue(dataTypeUsage2, string);
                Object object = this.getValueOrDefault(dataType2, dataTypeUsage2, string);
                Object object3 = null;
                if (dataType != null && dataType.hasDataTypeAttribute(string)) {
                    object3 = this.getValueOrDefault(dataType, dataTypeUsage, string);
                    String string5 = DataTypeHelper.getStringAttributeValue(dataTypeUsage, string);
                    if (ModelUtil.areEqual((Object)object3, (Object)object) || object3 == null || this.isSynonym(dataTypeUsage)) {
                        new ResultSet(resultSet, true, (Object)dataTypeUsage, dataTypeUsage2, string, string5, string4);
                        continue;
                    }
                    new ResultSet(resultSet, false, (Object)dataTypeUsage, dataTypeUsage2, string, string5, string4);
                    bl = false;
                    continue;
                }
                boolean bl3 = this.isSynonym(dataTypeUsage);
                new ResultSet(resultSet, bl3, (Object)dataTypeUsage, dataTypeUsage2, string, null, string4);
                bl &= bl3;
            }
        }
        return bl;
    }

    protected String getDataTypeBaseName(DataTypeUsage dataTypeUsage) {
        return this.getDataTypeName(dataTypeUsage);
    }

    protected boolean isSynonym(DataTypeUsage dataTypeUsage) {
        return false;
    }

    protected Object getValueOrDefault(DataType dataType, DataTypeUsage dataTypeUsage, String string) {
        Object object = null;
        if (dataTypeUsage != null && (object = dataTypeUsage.getAttributeValue(string)) == null && dataType.hasDataTypeAttribute(string)) {
            DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute(string);
            object = dataTypeAttribute.getDefaultValue();
        }
        return object;
    }
}

