/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DataTypeUsageDiffer;

public class DataTypeUsageDifferIgnorSynonyms
extends DataTypeUsageDiffer {
    protected String getDataTypeBaseName(DataTypeUsage dataTypeUsage) {
        String string = this.getDataTypeName(dataTypeUsage);
        try {
            DataTypeRegistry dataTypeRegistry;
            DataType dataType;
            DBObject dBObject;
            if (dataTypeUsage != null && (dBObject = dataTypeUsage.getDataTypeID().resolveID()) instanceof DataType && (dataType = (dataTypeRegistry = DataTypeRegistry.getInstance()).getBaseType((DataType)dBObject)) != null) {
                string = dataType.getName();
            }
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        return string;
    }

    protected boolean isSynonym(DataTypeUsage dataTypeUsage) {
        boolean bl = false;
        try {
            DataTypeRegistry dataTypeRegistry;
            DataType dataType;
            DBObject dBObject;
            if (dataTypeUsage != null && (dBObject = dataTypeUsage.getDataTypeID().resolveID()) instanceof DataType && (dataType = (dataTypeRegistry = DataTypeRegistry.getInstance()).getBaseType((DataType)dBObject)) != null) {
                bl = true;
            }
        }
        catch (DBException dBException) {
            DBUtil.logStackTrace(dBException);
        }
        return bl;
    }

    protected Object getValueOrDefault(DataType dataType, DataTypeUsage dataTypeUsage, String string) {
        Object object = null;
        if (dataTypeUsage != null && (object = dataTypeUsage.getAttributeValue(string)) == null && dataType.hasDataTypeAttribute(string)) {
            DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute(string);
            object = dataTypeAttribute.getDefaultValue();
        }
        return object;
    }
}

