/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngineCancelledException;
import oracle.javatools.db.diff.DiffFactory;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;

public class DiffEngine {
    private boolean m_cancelled;
    private Map m_registeredDiffers = new HashMap(DiffFactory.getDifferMap());
    private Map m_registeredListDiffers = new HashMap(DiffFactory.getListDifferMap());
    private Map m_registeredComparators = new HashMap(DiffFactory.getComparatorMap());
    static final /* synthetic */ boolean $assertionsDisabled;

    public DiffEngine() {
    }

    public DiffEngine(Map map, Map map2, Map map3) {
        this();
        if (map != null) {
            this.m_registeredDiffers.putAll(map);
        }
        if (map2 != null) {
            this.m_registeredDiffers.putAll(map2);
        }
        if (map3 != null) {
            this.m_registeredDiffers.putAll(map3);
        }
    }

    public DiffContext diff(Object object, Object object2) {
        this.checkProgress();
        ResultSet resultSet = new ResultSet(null, object, object2, null, "MAP");
        DiffContext diffContext = new DiffContext(this, resultSet);
        return this.diff(object, object2, resultSet, diffContext);
    }

    public DiffContext diff(Object[] objectArray, Object[] objectArray2) {
        this.checkProgress();
        ResultSet resultSet = new ResultSet(null, objectArray, objectArray2, null, "LIST");
        DiffContext diffContext = new DiffContext(this, resultSet);
        return this.diff(objectArray, objectArray2, resultSet, diffContext);
    }

    static {
        $assertionsDisabled = DiffEngine.class.desiredAssertionStatus() ^ true;
    }

    public DiffContext diff(Object object, Object object2, ResultSet resultSet, DiffContext diffContext) {
        this.checkProgress();
        if (!$assertionsDisabled && object == null && object2 == null) {
            throw new AssertionError();
        }
        Differ differ = null;
        String string = "";
        if (object != null) {
            differ = this.getDiffer(object.getClass());
            string = object.getClass().getName();
        } else {
            differ = this.getDiffer(object2.getClass());
            string = object2.getClass().getName();
        }
        if (!$assertionsDisabled && differ == null) {
            throw new AssertionError((Object)("no differ for class " + string));
        }
        boolean bl = differ.diff(object, object2, resultSet, diffContext);
        return diffContext;
    }

    public DiffContext diff(Object[] objectArray, Object[] objectArray2, ResultSet resultSet) {
        this.checkProgress();
        DiffContext diffContext = new DiffContext(this, resultSet);
        return this.diff(objectArray, objectArray2, resultSet, diffContext);
    }

    public DiffContext diff(Object[] objectArray, Object[] objectArray2, ResultSet resultSet, DiffContext diffContext) {
        this.checkProgress();
        Differ differ = this.getListDiffer(objectArray.getClass());
        boolean bl = differ.diff(Arrays.asList(objectArray), Arrays.asList(objectArray2), resultSet, diffContext);
        return diffContext;
    }

    public DiffContext diff(List list, List list2, ResultSet resultSet, DiffContext diffContext) {
        this.checkProgress();
        resultSet.setA(list);
        resultSet.setB(list2);
        Differ differ = null;
        if (list != null && list.size() > 0 && list.get(0) != null) {
            differ = this.getListDiffer(list.get(0).getClass());
        } else if (list2 != null && list2.size() > 0 && list2.get(0) != null) {
            differ = this.getListDiffer(list2.get(0).getClass());
        } else {
            resultSet.setSame(true);
        }
        if (differ != null) {
            boolean bl = differ.diff(list, list2, resultSet, diffContext);
        }
        return diffContext;
    }

    public void registerDiffer(Differ differ, Class clazz) {
        this.m_registeredDiffers.put(clazz, differ);
    }

    public void registerListDiffer(Differ differ, Class clazz) {
        this.m_registeredListDiffers.put(clazz, differ);
    }

    public void registerComparator(Comparator comparator, Class clazz) {
        this.m_registeredComparators.put(clazz, comparator);
    }

    public static Object searchMap(Map map, Class clazz) {
        Object var2_2 = null;
        block0: while (clazz != null) {
            if (map.containsKey(clazz)) {
                var2_2 = map.get(clazz);
                break;
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if (map.containsKey(classArray[n])) {
                    var2_2 = map.get(classArray[n]);
                    break block0;
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return var2_2;
    }

    private Differ getDiffer(Class clazz) {
        return (Differ)DiffEngine.searchMap(this.m_registeredDiffers, clazz);
    }

    private Differ getListDiffer(Class clazz) {
        return (Differ)DiffEngine.searchMap(this.m_registeredListDiffers, clazz);
    }

    public Comparator getComparator(Class clazz) {
        return (Comparator)DiffEngine.searchMap(this.m_registeredComparators, clazz);
    }

    public synchronized void checkProgress() {
        if (this.m_cancelled) {
            throw new DiffEngineCancelledException();
        }
    }

    public synchronized void cancelDiff() {
        this.m_cancelled = true;
    }
}

