/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBUtil;

public class ResultSet {
    private boolean m_same;
    private Object m_a;
    private Object m_b;
    private String m_name;
    private boolean m_display;
    private String m_aVal;
    private String m_bVal;
    private int m_indexOfA;
    private int m_indexOfB;
    private boolean m_listReordered;
    private List m_list;
    private Map m_map;
    public static final String LIST = "LIST";
    public static final String MAP = "MAP";
    public static final String LEAF = "LEAF";
    static final /* synthetic */ boolean $assertionsDisabled;

    void $init$() {
        this.m_display = true;
        this.m_indexOfA = -1;
        this.m_indexOfB = -1;
    }

    static {
        $assertionsDisabled = ResultSet.class.desiredAssertionStatus() ^ true;
    }

    public ResultSet(ResultSet resultSet, Object object, Object object2, int n, int n2, String string, String string2) {
        this.$init$();
        if (!(n < 0 && n2 < 0 || $assertionsDisabled || resultSet.getType().equals(LIST))) {
            throw new AssertionError();
        }
        this.m_a = object;
        this.m_b = object2;
        this.m_name = string;
        if (string2.equals(LIST)) {
            this.m_list = new ArrayList();
        } else if (string2.equals(MAP)) {
            this.m_map = new HashMap();
        }
        if (resultSet != null) {
            if (LIST.equals(resultSet.getType())) {
                resultSet.addToList(this);
                this.m_indexOfA = n;
                this.m_indexOfB = n2;
            }
            if (MAP.equals(resultSet.getType())) {
                resultSet.addToMap(string, this);
            }
        }
    }

    public ResultSet(ResultSet resultSet, Object object, Object object2, String string, String string2) {
        this(resultSet, object, object2, -1, -1, string, string2);
    }

    public ResultSet(ResultSet resultSet, boolean bl, Object object, Object object2, String string, String string2, String string3) {
        this(resultSet, object, object2, string, LEAF);
        this.m_same = bl;
        this.m_aVal = string2;
        this.m_bVal = string3;
    }

    public String getType() {
        String string = LEAF;
        if (this.m_list != null) {
            string = LIST;
        } else if (this.m_map != null) {
            string = MAP;
        }
        return string;
    }

    public void addToList(ResultSet resultSet) {
        this.m_list.add(resultSet);
    }

    public void addToMap(String string, ResultSet resultSet) {
        this.m_map.put(string, resultSet);
    }

    public boolean isModified() {
        return !this.isSame() && !this.inBbutNotA() && !this.inAbutNotB();
    }

    public boolean isSame() {
        return this.m_same;
    }

    public void setSame(boolean bl) {
        this.m_same = bl;
    }

    public Object a() {
        return this.m_a;
    }

    public void setA(Object object) {
        this.m_a = object;
    }

    public Object b() {
        return this.m_b;
    }

    public void setB(Object object) {
        this.m_b = object;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public void setAVal(String string) {
        this.m_aVal = string;
    }

    public String getAVal() {
        return this.m_aVal;
    }

    public void setBVal(String string) {
        this.m_bVal = string;
    }

    public String getBVal() {
        return this.m_bVal;
    }

    public void setDisplay(boolean bl) {
        this.m_display = bl;
    }

    public boolean isDisplay() {
        return this.m_display;
    }

    public boolean isChildListReorder() {
        return this.m_listReordered;
    }

    public void setListReordered(boolean bl) {
        this.m_listReordered = bl;
    }

    public List getModifiedObjectList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet resultSet : this.m_list) {
                if (resultSet.a() == null || resultSet.b() == null || resultSet.isSame()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List getNotSameObjectList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet resultSet : this.m_list) {
                if (resultSet.isSame()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public boolean inBbutNotA() {
        return !this.m_same && this.m_a == null && this.m_b != null;
    }

    public int getIndexOfA() {
        return this.m_indexOfA;
    }

    public int getIndexOfB() {
        return this.m_indexOfB;
    }

    public List getAList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet resultSet : this.m_list) {
                if (!resultSet.inA()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List getBList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet resultSet : this.m_list) {
                if (!resultSet.inB()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List getBonlyList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet resultSet : this.m_list) {
                if (!resultSet.inBbutNotA()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public boolean inA() {
        return this.m_a != null;
    }

    public boolean inB() {
        return this.m_b != null;
    }

    public boolean inAbutNotB() {
        return !this.m_same && this.m_a != null && this.m_b == null;
    }

    public List getAonlyList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet resultSet : this.m_list) {
                if (!resultSet.inAbutNotB()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List getAllObjectsList() {
        return this.m_list;
    }

    public Map getModifiedObjectMap() {
        HashMap hashMap = new HashMap();
        if (this.m_map != null) {
            for (Object k : this.m_map.keySet()) {
                ResultSet resultSet = (ResultSet)this.m_map.get(k);
                if (resultSet.a() == null || resultSet.b() == null || resultSet.isSame()) continue;
                hashMap.put(k, resultSet);
            }
        }
        return hashMap;
    }

    public Map getNotSameObjectMap() {
        HashMap hashMap = new HashMap();
        if (this.m_map != null) {
            for (Object k : this.m_map.keySet()) {
                ResultSet resultSet = (ResultSet)this.m_map.get(k);
                if (resultSet.isSame()) continue;
                hashMap.put(k, resultSet);
            }
        }
        return hashMap;
    }

    public Map getBonlyMap() {
        HashMap hashMap = new HashMap();
        if (this.m_map != null) {
            for (Object k : this.m_map.keySet()) {
                ResultSet resultSet = (ResultSet)this.m_map.get(k);
                if (resultSet.a() != null || resultSet.b() == null) continue;
                hashMap.put(k, resultSet);
            }
        }
        return hashMap;
    }

    public Map getAonlyMap() {
        HashMap hashMap = new HashMap();
        if (this.m_map != null) {
            for (Object k : this.m_map.keySet()) {
                ResultSet resultSet = (ResultSet)this.m_map.get(k);
                if (resultSet.a() == null || resultSet.b() != null) continue;
                hashMap.put(k, resultSet);
            }
        }
        return hashMap;
    }

    public Map getAllObjectsMap() {
        return this.m_map;
    }

    public Class getResultSetClass() {
        Class<?> clazz = null;
        Object object = this.getResultSetObject();
        if (object != null) {
            clazz = object.getClass();
        }
        return clazz;
    }

    public Object getResultSetObject() {
        Object object = null;
        if (this.m_a != null) {
            object = this.m_a;
        } else if (this.m_b != null) {
            object = this.m_b;
        }
        return object;
    }

    public void print() {
        this.print("", -1);
    }

    public void printOne() {
        this.print("", 1);
    }

    private void print(String string, int n) {
        if (this.m_map != null) {
            String string2 = this.m_same ? "SAME " : "XXXX ";
            String string3 = this.m_name != null ? this.m_name : "";
            DBUtil.getLog().trace(string + string2 + string3 + " " + this.m_indexOfA + " " + this.m_indexOfB);
            if (n-- != 0) {
                Iterator iterator = this.m_map.keySet().iterator();
                while (iterator.hasNext()) {
                    ResultSet resultSet = (ResultSet)this.m_map.get(iterator.next());
                    resultSet.print(string + "  ", n);
                }
            }
        } else if (this.m_list != null) {
            String string4 = this.m_same ? "SAME " : "XXXX ";
            String string5 = this.m_name != null ? this.m_name : "";
            String string6 = this.isChildListReorder() ? " reordered" : "";
            DBUtil.getLog().trace(string + string4 + string5 + " list" + string6);
            if (n-- != 0) {
                for (ResultSet resultSet : this.m_list) {
                    resultSet.print(string + "  ", n);
                }
            }
        } else {
            String string7 = this.m_same ? "SAME " : "XXXX ";
            String string8 = this.m_display ? "  " : "X ";
            String string9 = this.m_name != null ? this.m_name : "";
            String string10 = this.m_aVal == null ? "" : " aval=" + this.m_aVal;
            String string11 = this.m_bVal == null ? "" : " bval=" + this.m_bVal;
            DBUtil.getLog().trace(string + string7 + string8 + string9 + string10 + string11);
        }
    }
}

